
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Deprecated;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}MiningSchema"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Output" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelExplanation" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Targets" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}LocalTransformations" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}TextDictionary"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}TextCorpus"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}DocumentTermMatrix"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}TextModelNormalization" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}TextModelSimiliarity" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelVerification" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="modelName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="functionName" use="required" type="{http://www.dmg.org/PMML-4_2}MINING-FUNCTION" />
 *       &lt;attribute name="algorithmName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="numberOfTerms" use="required" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="numberOfDocuments" use="required" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="isScorable" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "textDictionary",
    "textCorpus",
    "documentTermMatrix",
    "textModelNormalization",
    "textModelSimiliarity",
    "modelVerification"
})
@XmlRootElement(name = "TextModel", namespace = "http://www.dmg.org/PMML-4_2")
@Deprecated(Version.PMML_4_2)
public class TextModel
    extends Model
    implements HasExtensions
{

    @XmlAttribute(name = "modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    private MiningFunctionType functionName;
    @XmlAttribute(name = "algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "numberOfTerms", required = true)
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    private Integer numberOfTerms;
    @XmlAttribute(name = "numberOfDocuments", required = true)
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    private Integer numberOfDocuments;
    @XmlAttribute(name = "isScorable")
    @Added(Version.PMML_4_1)
    private Boolean scorable;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_2")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_2")
    private ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_2")
    @Added(Version.PMML_4_0)
    private ModelExplanation modelExplanation;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_2")
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_2")
    private LocalTransformations localTransformations;
    @XmlElement(name = "TextDictionary", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private TextDictionary textDictionary;
    @XmlElement(name = "TextCorpus", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private TextCorpus textCorpus;
    @XmlElement(name = "DocumentTermMatrix", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private DocumentTermMatrix documentTermMatrix;
    @XmlElement(name = "TextModelNormalization", namespace = "http://www.dmg.org/PMML-4_2")
    private TextModelNormalization textModelNormalization;
    @XmlElement(name = "TextModelSimiliarity", namespace = "http://www.dmg.org/PMML-4_2")
    private TextModelSimiliarity textModelSimiliarity;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_2")
    private ModelVerification modelVerification;
    private final static Boolean DEFAULT_SCORABLE = true;

    public TextModel() {
        super();
    }

    public TextModel(final MiningFunctionType functionName, final Integer numberOfTerms, final Integer numberOfDocuments, final MiningSchema miningSchema, final TextDictionary textDictionary, final TextCorpus textCorpus, final DocumentTermMatrix documentTermMatrix) {
        super();
        this.functionName = functionName;
        this.numberOfTerms = numberOfTerms;
        this.numberOfDocuments = numberOfDocuments;
        this.miningSchema = miningSchema;
        this.textDictionary = textDictionary;
        this.textCorpus = textCorpus;
        this.documentTermMatrix = documentTermMatrix;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Sets the value of the modelName property.
     * 
     * @param modelName
     *     allowed object is
     *     {@link String }
     *     
     */
    public TextModel setModelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    /**
     * Gets the value of the functionName property.
     * 
     * @return
     *     possible object is
     *     {@link MiningFunctionType }
     *     
     */
    public MiningFunctionType getFunctionName() {
        return functionName;
    }

    /**
     * Sets the value of the functionName property.
     * 
     * @param functionName
     *     allowed object is
     *     {@link MiningFunctionType }
     *     
     */
    public TextModel setFunctionName(MiningFunctionType functionName) {
        this.functionName = functionName;
        return this;
    }

    /**
     * Gets the value of the algorithmName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithmName() {
        return algorithmName;
    }

    /**
     * Sets the value of the algorithmName property.
     * 
     * @param algorithmName
     *     allowed object is
     *     {@link String }
     *     
     */
    public TextModel setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    /**
     * Gets the value of the numberOfTerms property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getNumberOfTerms() {
        return numberOfTerms;
    }

    /**
     * Sets the value of the numberOfTerms property.
     * 
     * @param numberOfTerms
     *     allowed object is
     *     {@link String }
     *     
     */
    public TextModel setNumberOfTerms(Integer numberOfTerms) {
        this.numberOfTerms = numberOfTerms;
        return this;
    }

    /**
     * Gets the value of the numberOfDocuments property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getNumberOfDocuments() {
        return numberOfDocuments;
    }

    /**
     * Sets the value of the numberOfDocuments property.
     * 
     * @param numberOfDocuments
     *     allowed object is
     *     {@link String }
     *     
     */
    public TextModel setNumberOfDocuments(Integer numberOfDocuments) {
        this.numberOfDocuments = numberOfDocuments;
        return this;
    }

    /**
     * Gets the value of the scorable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    /**
     * Sets the value of the scorable property.
     * 
     * @param scorable
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public TextModel setScorable(Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the miningSchema property.
     * 
     * @return
     *     possible object is
     *     {@link MiningSchema }
     *     
     */
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    /**
     * Sets the value of the miningSchema property.
     * 
     * @param miningSchema
     *     allowed object is
     *     {@link MiningSchema }
     *     
     */
    public TextModel setMiningSchema(MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    /**
     * Gets the value of the output property.
     * 
     * @return
     *     possible object is
     *     {@link Output }
     *     
     */
    public Output getOutput() {
        return output;
    }

    /**
     * Sets the value of the output property.
     * 
     * @param output
     *     allowed object is
     *     {@link Output }
     *     
     */
    public TextModel setOutput(Output output) {
        this.output = output;
        return this;
    }

    /**
     * Gets the value of the modelStats property.
     * 
     * @return
     *     possible object is
     *     {@link ModelStats }
     *     
     */
    public ModelStats getModelStats() {
        return modelStats;
    }

    /**
     * Sets the value of the modelStats property.
     * 
     * @param modelStats
     *     allowed object is
     *     {@link ModelStats }
     *     
     */
    public TextModel setModelStats(ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    /**
     * Gets the value of the modelExplanation property.
     * 
     * @return
     *     possible object is
     *     {@link ModelExplanation }
     *     
     */
    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    /**
     * Sets the value of the modelExplanation property.
     * 
     * @param modelExplanation
     *     allowed object is
     *     {@link ModelExplanation }
     *     
     */
    public TextModel setModelExplanation(ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    /**
     * Gets the value of the targets property.
     * 
     * @return
     *     possible object is
     *     {@link Targets }
     *     
     */
    public Targets getTargets() {
        return targets;
    }

    /**
     * Sets the value of the targets property.
     * 
     * @param targets
     *     allowed object is
     *     {@link Targets }
     *     
     */
    public TextModel setTargets(Targets targets) {
        this.targets = targets;
        return this;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param localTransformations
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public TextModel setLocalTransformations(LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    /**
     * Gets the value of the textDictionary property.
     * 
     * @return
     *     possible object is
     *     {@link TextDictionary }
     *     
     */
    public TextDictionary getTextDictionary() {
        return textDictionary;
    }

    /**
     * Sets the value of the textDictionary property.
     * 
     * @param textDictionary
     *     allowed object is
     *     {@link TextDictionary }
     *     
     */
    public TextModel setTextDictionary(TextDictionary textDictionary) {
        this.textDictionary = textDictionary;
        return this;
    }

    /**
     * Gets the value of the textCorpus property.
     * 
     * @return
     *     possible object is
     *     {@link TextCorpus }
     *     
     */
    public TextCorpus getTextCorpus() {
        return textCorpus;
    }

    /**
     * Sets the value of the textCorpus property.
     * 
     * @param textCorpus
     *     allowed object is
     *     {@link TextCorpus }
     *     
     */
    public TextModel setTextCorpus(TextCorpus textCorpus) {
        this.textCorpus = textCorpus;
        return this;
    }

    /**
     * Gets the value of the documentTermMatrix property.
     * 
     * @return
     *     possible object is
     *     {@link DocumentTermMatrix }
     *     
     */
    public DocumentTermMatrix getDocumentTermMatrix() {
        return documentTermMatrix;
    }

    /**
     * Sets the value of the documentTermMatrix property.
     * 
     * @param documentTermMatrix
     *     allowed object is
     *     {@link DocumentTermMatrix }
     *     
     */
    public TextModel setDocumentTermMatrix(DocumentTermMatrix documentTermMatrix) {
        this.documentTermMatrix = documentTermMatrix;
        return this;
    }

    /**
     * Gets the value of the textModelNormalization property.
     * 
     * @return
     *     possible object is
     *     {@link TextModelNormalization }
     *     
     */
    public TextModelNormalization getTextModelNormalization() {
        return textModelNormalization;
    }

    /**
     * Sets the value of the textModelNormalization property.
     * 
     * @param textModelNormalization
     *     allowed object is
     *     {@link TextModelNormalization }
     *     
     */
    public TextModel setTextModelNormalization(TextModelNormalization textModelNormalization) {
        this.textModelNormalization = textModelNormalization;
        return this;
    }

    /**
     * Gets the value of the textModelSimiliarity property.
     * 
     * @return
     *     possible object is
     *     {@link TextModelSimiliarity }
     *     
     */
    public TextModelSimiliarity getTextModelSimiliarity() {
        return textModelSimiliarity;
    }

    /**
     * Sets the value of the textModelSimiliarity property.
     * 
     * @param textModelSimiliarity
     *     allowed object is
     *     {@link TextModelSimiliarity }
     *     
     */
    public TextModel setTextModelSimiliarity(TextModelSimiliarity textModelSimiliarity) {
        this.textModelSimiliarity = textModelSimiliarity;
        return this;
    }

    /**
     * Gets the value of the modelVerification property.
     * 
     * @return
     *     possible object is
     *     {@link ModelVerification }
     *     
     */
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    /**
     * Sets the value of the modelVerification property.
     * 
     * @param modelVerification
     *     allowed object is
     *     {@link ModelVerification }
     *     
     */
    public TextModel setModelVerification(ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public TextModel addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getModelExplanation(), getTargets(), getLocalTransformations(), getTextDictionary(), getTextCorpus(), getDocumentTermMatrix(), getTextModelNormalization(), getTextModelSimiliarity(), getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
