
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}InstanceFields"/>
 *         &lt;choice>
 *           &lt;element ref="{http://www.dmg.org/PMML-4_2}TableLocator"/>
 *           &lt;element ref="{http://www.dmg.org/PMML-4_2}InlineTable"/>
 *         &lt;/choice>
 *       &lt;/sequence>
 *       &lt;attribute name="isTransformed" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       &lt;attribute name="recordCount" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="fieldCount" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "instanceFields",
    "tableLocator",
    "inlineTable"
})
@XmlRootElement(name = "TrainingInstances", namespace = "http://www.dmg.org/PMML-4_2")
@Added(Version.PMML_4_1)
public class TrainingInstances
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions
{

    @XmlAttribute(name = "isTransformed")
    private Boolean transformed;
    @XmlAttribute(name = "recordCount")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    private Integer recordCount;
    @XmlAttribute(name = "fieldCount")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    private Integer fieldCount;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name = "InstanceFields", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private InstanceFields instanceFields;
    @XmlElement(name = "TableLocator", namespace = "http://www.dmg.org/PMML-4_2")
    private TableLocator tableLocator;
    @XmlElement(name = "InlineTable", namespace = "http://www.dmg.org/PMML-4_2")
    private InlineTable inlineTable;
    private final static Boolean DEFAULT_TRANSFORMED = false;

    public TrainingInstances() {
        super();
    }

    public TrainingInstances(final InstanceFields instanceFields) {
        super();
        this.instanceFields = instanceFields;
    }

    /**
     * Gets the value of the transformed property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isTransformed() {
        if (transformed == null) {
            return DEFAULT_TRANSFORMED;
        } else {
            return transformed;
        }
    }

    /**
     * Sets the value of the transformed property.
     * 
     * @param transformed
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public TrainingInstances setTransformed(Boolean transformed) {
        this.transformed = transformed;
        return this;
    }

    /**
     * Gets the value of the recordCount property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getRecordCount() {
        return recordCount;
    }

    /**
     * Sets the value of the recordCount property.
     * 
     * @param recordCount
     *     allowed object is
     *     {@link String }
     *     
     */
    public TrainingInstances setRecordCount(Integer recordCount) {
        this.recordCount = recordCount;
        return this;
    }

    /**
     * Gets the value of the fieldCount property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getFieldCount() {
        return fieldCount;
    }

    /**
     * Sets the value of the fieldCount property.
     * 
     * @param fieldCount
     *     allowed object is
     *     {@link String }
     *     
     */
    public TrainingInstances setFieldCount(Integer fieldCount) {
        this.fieldCount = fieldCount;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the instanceFields property.
     * 
     * @return
     *     possible object is
     *     {@link InstanceFields }
     *     
     */
    public InstanceFields getInstanceFields() {
        return instanceFields;
    }

    /**
     * Sets the value of the instanceFields property.
     * 
     * @param instanceFields
     *     allowed object is
     *     {@link InstanceFields }
     *     
     */
    public TrainingInstances setInstanceFields(InstanceFields instanceFields) {
        this.instanceFields = instanceFields;
        return this;
    }

    /**
     * Gets the value of the tableLocator property.
     * 
     * @return
     *     possible object is
     *     {@link TableLocator }
     *     
     */
    public TableLocator getTableLocator() {
        return tableLocator;
    }

    /**
     * Sets the value of the tableLocator property.
     * 
     * @param tableLocator
     *     allowed object is
     *     {@link TableLocator }
     *     
     */
    public TrainingInstances setTableLocator(TableLocator tableLocator) {
        this.tableLocator = tableLocator;
        return this;
    }

    /**
     * Gets the value of the inlineTable property.
     * 
     * @return
     *     possible object is
     *     {@link InlineTable }
     *     
     */
    public InlineTable getInlineTable() {
        return inlineTable;
    }

    /**
     * Sets the value of the inlineTable property.
     * 
     * @param inlineTable
     *     allowed object is
     *     {@link InlineTable }
     *     
     */
    public TrainingInstances setInlineTable(InlineTable inlineTable) {
        this.inlineTable = inlineTable;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public TrainingInstances addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getInstanceFields(), getTableLocator(), getInlineTable());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
