
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;
import org.w3c.dom.Element;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}AntecedentSequence"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Delimiter"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Time" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ConsequentSequence"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Time" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="id" use="required" type="{http://www.dmg.org/PMML-4_2}ELEMENT-ID" />
 *       &lt;attribute name="numberOfSets" use="required" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="occurrence" use="required" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="support" use="required" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" />
 *       &lt;attribute name="confidence" use="required" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" />
 *       &lt;attribute name="lift" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "content"
})
@XmlRootElement(name = "SequenceRule", namespace = "http://www.dmg.org/PMML-4_2")
public class SequenceRule
    extends Entity
{

    @XmlAttribute(name = "id", required = true)
    private String id;
    @XmlAttribute(name = "numberOfSets", required = true)
    private int numberOfSets;
    @XmlAttribute(name = "occurrence", required = true)
    private int occurrence;
    @XmlAttribute(name = "support", required = true)
    private double support;
    @XmlAttribute(name = "confidence", required = true)
    private double confidence;
    @XmlAttribute(name = "lift")
    @Added(Version.PMML_3_1)
    private Double lift;
    @XmlElementRefs({
        @XmlElementRef(name = "ConsequentSequence", namespace = "http://www.dmg.org/PMML-4_2", type = ConsequentSequence.class, required = false),
        @XmlElementRef(name = "AntecedentSequence", namespace = "http://www.dmg.org/PMML-4_2", type = AntecedentSequence.class, required = false),
        @XmlElementRef(name = "Time", namespace = "http://www.dmg.org/PMML-4_2", type = Time.class, required = false),
        @XmlElementRef(name = "Delimiter", namespace = "http://www.dmg.org/PMML-4_2", type = Delimiter.class, required = false),
        @XmlElementRef(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2", type = Extension.class, required = false)
    })
    @XmlAnyElement(lax = true)
    private List<Object> content;

    public SequenceRule() {
        super();
    }

    public SequenceRule(final String id, final int numberOfSets, final int occurrence, final double support, final double confidence) {
        super();
        this.id = id;
        this.numberOfSets = numberOfSets;
        this.occurrence = occurrence;
        this.support = support;
        this.confidence = confidence;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param id
     *     allowed object is
     *     {@link String }
     *     
     */
    public SequenceRule setId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Gets the value of the numberOfSets property.
     * 
     */
    public int getNumberOfSets() {
        return numberOfSets;
    }

    /**
     * Sets the value of the numberOfSets property.
     * 
     */
    public SequenceRule setNumberOfSets(int numberOfSets) {
        this.numberOfSets = numberOfSets;
        return this;
    }

    /**
     * Gets the value of the occurrence property.
     * 
     */
    public int getOccurrence() {
        return occurrence;
    }

    /**
     * Sets the value of the occurrence property.
     * 
     */
    public SequenceRule setOccurrence(int occurrence) {
        this.occurrence = occurrence;
        return this;
    }

    /**
     * Gets the value of the support property.
     * 
     */
    public double getSupport() {
        return support;
    }

    /**
     * Sets the value of the support property.
     * 
     */
    public SequenceRule setSupport(double support) {
        this.support = support;
        return this;
    }

    /**
     * Gets the value of the confidence property.
     * 
     */
    public double getConfidence() {
        return confidence;
    }

    /**
     * Sets the value of the confidence property.
     * 
     */
    public SequenceRule setConfidence(double confidence) {
        this.confidence = confidence;
        return this;
    }

    /**
     * Gets the value of the lift property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getLift() {
        return lift;
    }

    /**
     * Sets the value of the lift property.
     * 
     * @param lift
     *     allowed object is
     *     {@link Double }
     *     
     */
    public SequenceRule setLift(Double lift) {
        this.lift = lift;
        return this;
    }

    /**
     * Gets the rest of the content model. 
     * 
     * <p>
     * You are getting this "catch-all" property because of the following reason: 
     * The field name "Time" is used by two different parts of a schema. See: 
     * line 2716 of file:/home/vfed/Workspace/jpmml-model/target/checkout/pmml-model/target/transformed-schema/pmml.xsd
     * line 2714 of file:/home/vfed/Workspace/jpmml-model/target/checkout/pmml-model/target/transformed-schema/pmml.xsd
     * <p>
     * To get rid of this property, apply a property customization to one 
     * of both of the following declarations to change their names: 
     * Gets the value of the content property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the content property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getContent().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ConsequentSequence }
     * {@link Object }
     * {@link Delimiter }
     * {@link Extension }
     * {@link Element }
     * {@link AntecedentSequence }
     * {@link Time }
     * 
     * 
     */
    public List<Object> getContent() {
        if (content == null) {
            content = new ArrayList<Object>();
        }
        return this.content;
    }

    public boolean hasContent() {
        return ((this.content!= null)&&(this.content.size()> 0));
    }

    public SequenceRule addContent(Object... content) {
        getContent().addAll(Arrays.asList(content));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasContent()) {
                status = PMMLObject.traverseMixed(visitor, getContent());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
