
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;choice minOccurs="0">
 *           &lt;element ref="{http://www.dmg.org/PMML-4_2}TableLocator"/>
 *           &lt;element ref="{http://www.dmg.org/PMML-4_2}InlineTable"/>
 *         &lt;/choice>
 *       &lt;/sequence>
 *       &lt;attribute name="inField" type="{http://www.w3.org/2001/XMLSchema}string" default="string" />
 *       &lt;attribute name="outField" type="{http://www.w3.org/2001/XMLSchema}string" default="stem" />
 *       &lt;attribute name="regexField" type="{http://www.w3.org/2001/XMLSchema}string" default="regex" />
 *       &lt;attribute name="recursive" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       &lt;attribute name="isCaseSensitive" type="{http://www.w3.org/2001/XMLSchema}boolean" />
 *       &lt;attribute name="maxLevenshteinDistance" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="wordSeparatorCharacterRE" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="tokenize" type="{http://www.w3.org/2001/XMLSchema}boolean" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "tableLocator",
    "inlineTable"
})
@XmlRootElement(name = "TextIndexNormalization", namespace = "http://www.dmg.org/PMML-4_2")
@Added(Version.PMML_4_2)
public class TextIndexNormalization
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions
{

    @XmlAttribute(name = "inField")
    private String inField;
    @XmlAttribute(name = "outField")
    private String outField;
    @XmlAttribute(name = "regexField")
    private String regexField;
    @XmlAttribute(name = "recursive")
    private Boolean recursive;
    @XmlAttribute(name = "isCaseSensitive")
    private Boolean isCaseSensitive;
    @XmlAttribute(name = "maxLevenshteinDistance")
    private Integer maxLevenshteinDistance;
    @XmlAttribute(name = "wordSeparatorCharacterRE")
    private String wordSeparatorCharacterRE;
    @XmlAttribute(name = "tokenize")
    private Boolean tokenize;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name = "TableLocator", namespace = "http://www.dmg.org/PMML-4_2")
    private TableLocator tableLocator;
    @XmlElement(name = "InlineTable", namespace = "http://www.dmg.org/PMML-4_2")
    private InlineTable inlineTable;
    private final static Boolean DEFAULT_RECURSIVE = false;

    /**
     * Gets the value of the inField property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getInField() {
        if (inField == null) {
            return "string";
        } else {
            return inField;
        }
    }

    /**
     * Sets the value of the inField property.
     * 
     * @param inField
     *     allowed object is
     *     {@link String }
     *     
     */
    public TextIndexNormalization setInField(String inField) {
        this.inField = inField;
        return this;
    }

    /**
     * Gets the value of the outField property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getOutField() {
        if (outField == null) {
            return "stem";
        } else {
            return outField;
        }
    }

    /**
     * Sets the value of the outField property.
     * 
     * @param outField
     *     allowed object is
     *     {@link String }
     *     
     */
    public TextIndexNormalization setOutField(String outField) {
        this.outField = outField;
        return this;
    }

    /**
     * Gets the value of the regexField property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getRegexField() {
        if (regexField == null) {
            return "regex";
        } else {
            return regexField;
        }
    }

    /**
     * Sets the value of the regexField property.
     * 
     * @param regexField
     *     allowed object is
     *     {@link String }
     *     
     */
    public TextIndexNormalization setRegexField(String regexField) {
        this.regexField = regexField;
        return this;
    }

    /**
     * Gets the value of the recursive property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isRecursive() {
        if (recursive == null) {
            return DEFAULT_RECURSIVE;
        } else {
            return recursive;
        }
    }

    /**
     * Sets the value of the recursive property.
     * 
     * @param recursive
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public TextIndexNormalization setRecursive(Boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    /**
     * Gets the value of the isCaseSensitive property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isIsCaseSensitive() {
        return isCaseSensitive;
    }

    /**
     * Sets the value of the isCaseSensitive property.
     * 
     * @param isCaseSensitive
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public TextIndexNormalization setIsCaseSensitive(Boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
        return this;
    }

    /**
     * Gets the value of the maxLevenshteinDistance property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public Integer getMaxLevenshteinDistance() {
        return maxLevenshteinDistance;
    }

    /**
     * Sets the value of the maxLevenshteinDistance property.
     * 
     * @param maxLevenshteinDistance
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public TextIndexNormalization setMaxLevenshteinDistance(Integer maxLevenshteinDistance) {
        this.maxLevenshteinDistance = maxLevenshteinDistance;
        return this;
    }

    /**
     * Gets the value of the wordSeparatorCharacterRE property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getWordSeparatorCharacterRE() {
        return wordSeparatorCharacterRE;
    }

    /**
     * Sets the value of the wordSeparatorCharacterRE property.
     * 
     * @param wordSeparatorCharacterRE
     *     allowed object is
     *     {@link String }
     *     
     */
    public TextIndexNormalization setWordSeparatorCharacterRE(String wordSeparatorCharacterRE) {
        this.wordSeparatorCharacterRE = wordSeparatorCharacterRE;
        return this;
    }

    /**
     * Gets the value of the tokenize property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isTokenize() {
        return tokenize;
    }

    /**
     * Sets the value of the tokenize property.
     * 
     * @param tokenize
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public TextIndexNormalization setTokenize(Boolean tokenize) {
        this.tokenize = tokenize;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the tableLocator property.
     * 
     * @return
     *     possible object is
     *     {@link TableLocator }
     *     
     */
    public TableLocator getTableLocator() {
        return tableLocator;
    }

    /**
     * Sets the value of the tableLocator property.
     * 
     * @param tableLocator
     *     allowed object is
     *     {@link TableLocator }
     *     
     */
    public TextIndexNormalization setTableLocator(TableLocator tableLocator) {
        this.tableLocator = tableLocator;
        return this;
    }

    /**
     * Gets the value of the inlineTable property.
     * 
     * @return
     *     possible object is
     *     {@link InlineTable }
     *     
     */
    public InlineTable getInlineTable() {
        return inlineTable;
    }

    /**
     * Sets the value of the inlineTable property.
     * 
     * @param inlineTable
     *     allowed object is
     *     {@link InlineTable }
     *     
     */
    public TextIndexNormalization setInlineTable(InlineTable inlineTable) {
        this.inlineTable = inlineTable;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public TextIndexNormalization addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTableLocator(), getInlineTable());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
