
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Neuron" maxOccurs="unbounded"/>
 *       &lt;/sequence>
 *       &lt;attribute name="numberOfNeurons" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *       &lt;attribute name="activationFunction" type="{http://www.dmg.org/PMML-4_2}ACTIVATION-FUNCTION" />
 *       &lt;attribute name="threshold" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" />
 *       &lt;attribute name="width" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" />
 *       &lt;attribute name="altitude" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" />
 *       &lt;attribute name="normalizationMethod" type="{http://www.dmg.org/PMML-4_2}NN-NORMALIZATION-METHOD" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "neurons"
})
@XmlRootElement(name = "NeuralLayer", namespace = "http://www.dmg.org/PMML-4_2")
public class NeuralLayer
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions
{

    @XmlAttribute(name = "numberOfNeurons")
    private Integer numberOfNeurons;
    @XmlAttribute(name = "activationFunction")
    private ActivationFunctionType activationFunction;
    @XmlAttribute(name = "threshold")
    private Double threshold;
    @XmlAttribute(name = "width")
    private Double width;
    @XmlAttribute(name = "altitude")
    private Double altitude;
    @XmlAttribute(name = "normalizationMethod")
    private NnNormalizationMethodType normalizationMethod;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name = "Neuron", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private List<Neuron> neurons;

    public NeuralLayer() {
        super();
    }

    public NeuralLayer(final List<Neuron> neurons) {
        super();
        this.neurons = neurons;
    }

    /**
     * Gets the value of the numberOfNeurons property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public Integer getNumberOfNeurons() {
        return numberOfNeurons;
    }

    /**
     * Sets the value of the numberOfNeurons property.
     * 
     * @param numberOfNeurons
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public NeuralLayer setNumberOfNeurons(Integer numberOfNeurons) {
        this.numberOfNeurons = numberOfNeurons;
        return this;
    }

    /**
     * Gets the value of the activationFunction property.
     * 
     * @return
     *     possible object is
     *     {@link ActivationFunctionType }
     *     
     */
    public ActivationFunctionType getActivationFunction() {
        return activationFunction;
    }

    /**
     * Sets the value of the activationFunction property.
     * 
     * @param activationFunction
     *     allowed object is
     *     {@link ActivationFunctionType }
     *     
     */
    public NeuralLayer setActivationFunction(ActivationFunctionType activationFunction) {
        this.activationFunction = activationFunction;
        return this;
    }

    /**
     * Gets the value of the threshold property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getThreshold() {
        return threshold;
    }

    /**
     * Sets the value of the threshold property.
     * 
     * @param threshold
     *     allowed object is
     *     {@link Double }
     *     
     */
    public NeuralLayer setThreshold(Double threshold) {
        this.threshold = threshold;
        return this;
    }

    /**
     * Gets the value of the width property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getWidth() {
        return width;
    }

    /**
     * Sets the value of the width property.
     * 
     * @param width
     *     allowed object is
     *     {@link Double }
     *     
     */
    public NeuralLayer setWidth(Double width) {
        this.width = width;
        return this;
    }

    /**
     * Gets the value of the altitude property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getAltitude() {
        return altitude;
    }

    /**
     * Sets the value of the altitude property.
     * 
     * @param altitude
     *     allowed object is
     *     {@link Double }
     *     
     */
    public NeuralLayer setAltitude(Double altitude) {
        this.altitude = altitude;
        return this;
    }

    /**
     * Gets the value of the normalizationMethod property.
     * 
     * @return
     *     possible object is
     *     {@link NnNormalizationMethodType }
     *     
     */
    public NnNormalizationMethodType getNormalizationMethod() {
        return normalizationMethod;
    }

    /**
     * Sets the value of the normalizationMethod property.
     * 
     * @param normalizationMethod
     *     allowed object is
     *     {@link NnNormalizationMethodType }
     *     
     */
    public NeuralLayer setNormalizationMethod(NnNormalizationMethodType normalizationMethod) {
        this.normalizationMethod = normalizationMethod;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the neurons property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the neurons property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getNeurons().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Neuron }
     * 
     * 
     */
    public List<Neuron> getNeurons() {
        if (neurons == null) {
            neurons = new ArrayList<Neuron>();
        }
        return this.neurons;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public NeuralLayer addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasNeurons() {
        return ((this.neurons!= null)&&(this.neurons.size()> 0));
    }

    public NeuralLayer addNeurons(Neuron... neurons) {
        getNeurons().addAll(Arrays.asList(neurons));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasNeurons()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getNeurons());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
