
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.schema.Added;
import org.jpmml.schema.Removed;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}LocalTransformations" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Segment" maxOccurs="unbounded"/>
 *       &lt;/sequence>
 *       &lt;attribute name="multipleModelMethod" use="required" type="{http://www.dmg.org/PMML-4_2}MULTIPLE-MODEL-METHOD" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "localTransformations",
    "segments"
})
@XmlRootElement(name = "Segmentation", namespace = "http://www.dmg.org/PMML-4_2")
@Added(Version.PMML_4_0)
public class Segmentation
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions
{

    @XmlAttribute(name = "multipleModelMethod", required = true)
    private MultipleModelMethodType multipleModelMethod;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_2")
    @Removed(Version.PMML_4_1)
    private LocalTransformations localTransformations;
    @XmlElement(name = "Segment", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private List<Segment> segments;

    public Segmentation() {
        super();
    }

    public Segmentation(final MultipleModelMethodType multipleModelMethod, final List<Segment> segments) {
        super();
        this.multipleModelMethod = multipleModelMethod;
        this.segments = segments;
    }

    /**
     * Gets the value of the multipleModelMethod property.
     * 
     * @return
     *     possible object is
     *     {@link MultipleModelMethodType }
     *     
     */
    public MultipleModelMethodType getMultipleModelMethod() {
        return multipleModelMethod;
    }

    /**
     * Sets the value of the multipleModelMethod property.
     * 
     * @param multipleModelMethod
     *     allowed object is
     *     {@link MultipleModelMethodType }
     *     
     */
    public Segmentation setMultipleModelMethod(MultipleModelMethodType multipleModelMethod) {
        this.multipleModelMethod = multipleModelMethod;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param localTransformations
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public Segmentation setLocalTransformations(LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    /**
     * Gets the value of the segments property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the segments property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSegments().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Segment }
     * 
     * 
     */
    public List<Segment> getSegments() {
        if (segments == null) {
            segments = new ArrayList<Segment>();
        }
        return this.segments;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Segmentation addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasSegments() {
        return ((this.segments!= null)&&(this.segments.size()> 0));
    }

    public Segmentation addSegments(Segment... segments) {
        getSegments().addAll(Arrays.asList(segments));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getLocalTransformations());
            }
            if ((status == VisitorAction.CONTINUE)&&hasSegments()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getSegments());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
