
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}FieldRef" maxOccurs="unbounded"/>
 *       &lt;/sequence>
 *       &lt;attribute name="numberOfFields" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "fieldRefs"
})
@XmlRootElement(name = "VectorFields", namespace = "http://www.dmg.org/PMML-4_2")
@Added(Version.PMML_3_1)
public class VectorFields
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions
{

    @XmlAttribute(name = "numberOfFields")
    private Integer numberOfFields;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name = "FieldRef", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private List<FieldRef> fieldRefs;

    public VectorFields() {
        super();
    }

    public VectorFields(final List<FieldRef> fieldRefs) {
        super();
        this.fieldRefs = fieldRefs;
    }

    /**
     * Gets the value of the numberOfFields property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public Integer getNumberOfFields() {
        return numberOfFields;
    }

    /**
     * Sets the value of the numberOfFields property.
     * 
     * @param numberOfFields
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public VectorFields setNumberOfFields(Integer numberOfFields) {
        this.numberOfFields = numberOfFields;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the fieldRefs property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the fieldRefs property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getFieldRefs().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FieldRef }
     * 
     * 
     */
    public List<FieldRef> getFieldRefs() {
        if (fieldRefs == null) {
            fieldRefs = new ArrayList<FieldRef>();
        }
        return this.fieldRefs;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public VectorFields addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasFieldRefs() {
        return ((this.fieldRefs!= null)&&(this.fieldRefs.size()> 0));
    }

    public VectorFields addFieldRefs(FieldRef... fieldRefs) {
        getFieldRefs().addAll(Arrays.asList(fieldRefs));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasFieldRefs()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getFieldRefs());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
