
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}MiningSchema"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Output" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelExplanation" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Targets" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}LocalTransformations" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Characteristics"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelVerification" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="modelName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="functionName" use="required" type="{http://www.dmg.org/PMML-4_2}MINING-FUNCTION" />
 *       &lt;attribute name="algorithmName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="initialScore" type="{http://www.dmg.org/PMML-4_2}NUMBER" default="0" />
 *       &lt;attribute name="useReasonCodes" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       &lt;attribute name="reasonCodeAlgorithm" default="pointsBelow">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="pointsAbove"/>
 *             &lt;enumeration value="pointsBelow"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="baselineScore" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *       &lt;attribute name="baselineMethod" default="other">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="max"/>
 *             &lt;enumeration value="min"/>
 *             &lt;enumeration value="mean"/>
 *             &lt;enumeration value="neutral"/>
 *             &lt;enumeration value="other"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="isScorable" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "characteristics",
    "modelVerification"
})
@XmlRootElement(name = "Scorecard", namespace = "http://www.dmg.org/PMML-4_2")
@Added(Version.PMML_4_1)
public class Scorecard
    extends Model
    implements HasExtensions
{

    @XmlAttribute(name = "modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    private MiningFunctionType functionName;
    @XmlAttribute(name = "algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "initialScore")
    private Double initialScore;
    @XmlAttribute(name = "useReasonCodes")
    private Boolean useReasonCodes;
    @XmlAttribute(name = "reasonCodeAlgorithm")
    private Scorecard.ReasonCodeAlgorithm reasonCodeAlgorithm;
    @XmlAttribute(name = "baselineScore")
    private Double baselineScore;
    @XmlAttribute(name = "baselineMethod")
    private Scorecard.BaselineMethod baselineMethod;
    @XmlAttribute(name = "isScorable")
    @Added(Version.PMML_4_1)
    private Boolean scorable;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_2")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_2")
    private ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_2")
    private ModelExplanation modelExplanation;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_2")
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_2")
    private LocalTransformations localTransformations;
    @XmlElement(name = "Characteristics", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private Characteristics characteristics;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_2")
    private ModelVerification modelVerification;

    public Scorecard() {
        super();
    }

    public Scorecard(final MiningFunctionType functionName, final MiningSchema miningSchema, final Characteristics characteristics) {
        super();
        this.functionName = functionName;
        this.miningSchema = miningSchema;
        this.characteristics = characteristics;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Sets the value of the modelName property.
     * 
     * @param modelName
     *     allowed object is
     *     {@link String }
     *     
     */
    public Scorecard setModelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    /**
     * Gets the value of the functionName property.
     * 
     * @return
     *     possible object is
     *     {@link MiningFunctionType }
     *     
     */
    public MiningFunctionType getFunctionName() {
        return functionName;
    }

    /**
     * Sets the value of the functionName property.
     * 
     * @param functionName
     *     allowed object is
     *     {@link MiningFunctionType }
     *     
     */
    public Scorecard setFunctionName(MiningFunctionType functionName) {
        this.functionName = functionName;
        return this;
    }

    /**
     * Gets the value of the algorithmName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithmName() {
        return algorithmName;
    }

    /**
     * Sets the value of the algorithmName property.
     * 
     * @param algorithmName
     *     allowed object is
     *     {@link String }
     *     
     */
    public Scorecard setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    /**
     * Gets the value of the initialScore property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public double getInitialScore() {
        if (initialScore == null) {
            return  0.0D;
        } else {
            return initialScore;
        }
    }

    /**
     * Sets the value of the initialScore property.
     * 
     * @param initialScore
     *     allowed object is
     *     {@link Double }
     *     
     */
    public Scorecard setInitialScore(Double initialScore) {
        this.initialScore = initialScore;
        return this;
    }

    /**
     * Gets the value of the useReasonCodes property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isUseReasonCodes() {
        if (useReasonCodes == null) {
            return true;
        } else {
            return useReasonCodes;
        }
    }

    /**
     * Sets the value of the useReasonCodes property.
     * 
     * @param useReasonCodes
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public Scorecard setUseReasonCodes(Boolean useReasonCodes) {
        this.useReasonCodes = useReasonCodes;
        return this;
    }

    /**
     * Gets the value of the reasonCodeAlgorithm property.
     * 
     * @return
     *     possible object is
     *     {@link Scorecard.ReasonCodeAlgorithm }
     *     
     */
    public Scorecard.ReasonCodeAlgorithm getReasonCodeAlgorithm() {
        if (reasonCodeAlgorithm == null) {
            return Scorecard.ReasonCodeAlgorithm.POINTS_BELOW;
        } else {
            return reasonCodeAlgorithm;
        }
    }

    /**
     * Sets the value of the reasonCodeAlgorithm property.
     * 
     * @param reasonCodeAlgorithm
     *     allowed object is
     *     {@link Scorecard.ReasonCodeAlgorithm }
     *     
     */
    public Scorecard setReasonCodeAlgorithm(Scorecard.ReasonCodeAlgorithm reasonCodeAlgorithm) {
        this.reasonCodeAlgorithm = reasonCodeAlgorithm;
        return this;
    }

    /**
     * Gets the value of the baselineScore property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getBaselineScore() {
        return baselineScore;
    }

    /**
     * Sets the value of the baselineScore property.
     * 
     * @param baselineScore
     *     allowed object is
     *     {@link Double }
     *     
     */
    public Scorecard setBaselineScore(Double baselineScore) {
        this.baselineScore = baselineScore;
        return this;
    }

    /**
     * Gets the value of the baselineMethod property.
     * 
     * @return
     *     possible object is
     *     {@link Scorecard.BaselineMethod }
     *     
     */
    public Scorecard.BaselineMethod getBaselineMethod() {
        if (baselineMethod == null) {
            return Scorecard.BaselineMethod.OTHER;
        } else {
            return baselineMethod;
        }
    }

    /**
     * Sets the value of the baselineMethod property.
     * 
     * @param baselineMethod
     *     allowed object is
     *     {@link Scorecard.BaselineMethod }
     *     
     */
    public Scorecard setBaselineMethod(Scorecard.BaselineMethod baselineMethod) {
        this.baselineMethod = baselineMethod;
        return this;
    }

    /**
     * Gets the value of the scorable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isScorable() {
        if (scorable == null) {
            return true;
        } else {
            return scorable;
        }
    }

    /**
     * Sets the value of the scorable property.
     * 
     * @param scorable
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public Scorecard setScorable(Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the miningSchema property.
     * 
     * @return
     *     possible object is
     *     {@link MiningSchema }
     *     
     */
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    /**
     * Sets the value of the miningSchema property.
     * 
     * @param miningSchema
     *     allowed object is
     *     {@link MiningSchema }
     *     
     */
    public Scorecard setMiningSchema(MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    /**
     * Gets the value of the output property.
     * 
     * @return
     *     possible object is
     *     {@link Output }
     *     
     */
    public Output getOutput() {
        return output;
    }

    /**
     * Sets the value of the output property.
     * 
     * @param output
     *     allowed object is
     *     {@link Output }
     *     
     */
    public Scorecard setOutput(Output output) {
        this.output = output;
        return this;
    }

    /**
     * Gets the value of the modelStats property.
     * 
     * @return
     *     possible object is
     *     {@link ModelStats }
     *     
     */
    public ModelStats getModelStats() {
        return modelStats;
    }

    /**
     * Sets the value of the modelStats property.
     * 
     * @param modelStats
     *     allowed object is
     *     {@link ModelStats }
     *     
     */
    public Scorecard setModelStats(ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    /**
     * Gets the value of the modelExplanation property.
     * 
     * @return
     *     possible object is
     *     {@link ModelExplanation }
     *     
     */
    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    /**
     * Sets the value of the modelExplanation property.
     * 
     * @param modelExplanation
     *     allowed object is
     *     {@link ModelExplanation }
     *     
     */
    public Scorecard setModelExplanation(ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    /**
     * Gets the value of the targets property.
     * 
     * @return
     *     possible object is
     *     {@link Targets }
     *     
     */
    public Targets getTargets() {
        return targets;
    }

    /**
     * Sets the value of the targets property.
     * 
     * @param targets
     *     allowed object is
     *     {@link Targets }
     *     
     */
    public Scorecard setTargets(Targets targets) {
        this.targets = targets;
        return this;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param localTransformations
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public Scorecard setLocalTransformations(LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    /**
     * Gets the value of the characteristics property.
     * 
     * @return
     *     possible object is
     *     {@link Characteristics }
     *     
     */
    public Characteristics getCharacteristics() {
        return characteristics;
    }

    /**
     * Sets the value of the characteristics property.
     * 
     * @param characteristics
     *     allowed object is
     *     {@link Characteristics }
     *     
     */
    public Scorecard setCharacteristics(Characteristics characteristics) {
        this.characteristics = characteristics;
        return this;
    }

    /**
     * Gets the value of the modelVerification property.
     * 
     * @return
     *     possible object is
     *     {@link ModelVerification }
     *     
     */
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    /**
     * Sets the value of the modelVerification property.
     * 
     * @param modelVerification
     *     allowed object is
     *     {@link ModelVerification }
     *     
     */
    public Scorecard setModelVerification(ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Scorecard addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
            status = PMMLObject.traverse(visitor, getExtensions());
        }
        if (status == VisitorAction.CONTINUE) {
            status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getModelExplanation(), getTargets(), getLocalTransformations(), getCharacteristics(), getModelVerification());
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="max"/>
     *     &lt;enumeration value="min"/>
     *     &lt;enumeration value="mean"/>
     *     &lt;enumeration value="neutral"/>
     *     &lt;enumeration value="other"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum BaselineMethod {

        @XmlEnumValue("max")
        MAX("max"),
        @XmlEnumValue("min")
        MIN("min"),
        @XmlEnumValue("mean")
        MEAN("mean"),
        @XmlEnumValue("neutral")
        NEUTRAL("neutral"),
        @XmlEnumValue("other")
        OTHER("other");
        private final String value;

        BaselineMethod(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static Scorecard.BaselineMethod fromValue(String v) {
            for (Scorecard.BaselineMethod c: Scorecard.BaselineMethod.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="pointsAbove"/>
     *     &lt;enumeration value="pointsBelow"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum ReasonCodeAlgorithm {

        @XmlEnumValue("pointsAbove")
        POINTS_ABOVE("pointsAbove"),
        @XmlEnumValue("pointsBelow")
        POINTS_BELOW("pointsBelow");
        private final String value;

        ReasonCodeAlgorithm(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static Scorecard.ReasonCodeAlgorithm fromValue(String v) {
            for (Scorecard.ReasonCodeAlgorithm c: Scorecard.ReasonCodeAlgorithm.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
