
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Baseline"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Alternate" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="field" use="required" type="{http://www.dmg.org/PMML-4_2}FIELD-NAME" />
 *       &lt;attribute name="testStatistic" use="required" type="{http://www.dmg.org/PMML-4_2}BASELINE-TEST-STATISTIC" />
 *       &lt;attribute name="resetValue" type="{http://www.dmg.org/PMML-4_2}REAL-NUMBER" default="0.0" />
 *       &lt;attribute name="windowSize" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" default="0" />
 *       &lt;attribute name="weightField" type="{http://www.dmg.org/PMML-4_2}FIELD-NAME" />
 *       &lt;attribute name="normalizationScheme" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "baseline",
    "alternate",
    "extensions"
})
@XmlRootElement(name = "TestDistributions", namespace = "http://www.dmg.org/PMML-4_2")
@Added(Version.PMML_4_1)
public class TestDistributions
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName field;
    @XmlAttribute(name = "testStatistic", required = true)
    private BaselineTestStatisticType testStatistic;
    @XmlAttribute(name = "resetValue")
    private Double resetValue;
    @XmlAttribute(name = "windowSize")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    private Integer windowSize;
    @XmlAttribute(name = "weightField")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName weightField;
    @XmlAttribute(name = "normalizationScheme")
    private String normalizationScheme;
    @XmlElement(name = "Baseline", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private Baseline baseline;
    @XmlElement(name = "Alternate", namespace = "http://www.dmg.org/PMML-4_2")
    private Alternate alternate;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;

    public TestDistributions() {
        super();
    }

    public TestDistributions(final FieldName field, final BaselineTestStatisticType testStatistic, final Baseline baseline) {
        super();
        this.field = field;
        this.testStatistic = testStatistic;
        this.baseline = baseline;
    }

    /**
     * Gets the value of the field property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getField() {
        return field;
    }

    /**
     * Sets the value of the field property.
     * 
     * @param field
     *     allowed object is
     *     {@link String }
     *     
     */
    public TestDistributions setField(FieldName field) {
        this.field = field;
        return this;
    }

    /**
     * Gets the value of the testStatistic property.
     * 
     * @return
     *     possible object is
     *     {@link BaselineTestStatisticType }
     *     
     */
    public BaselineTestStatisticType getTestStatistic() {
        return testStatistic;
    }

    /**
     * Sets the value of the testStatistic property.
     * 
     * @param testStatistic
     *     allowed object is
     *     {@link BaselineTestStatisticType }
     *     
     */
    public TestDistributions setTestStatistic(BaselineTestStatisticType testStatistic) {
        this.testStatistic = testStatistic;
        return this;
    }

    /**
     * Gets the value of the resetValue property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public double getResetValue() {
        if (resetValue == null) {
            return  0.0D;
        } else {
            return resetValue;
        }
    }

    /**
     * Sets the value of the resetValue property.
     * 
     * @param resetValue
     *     allowed object is
     *     {@link Double }
     *     
     */
    public TestDistributions setResetValue(Double resetValue) {
        this.resetValue = resetValue;
        return this;
    }

    /**
     * Gets the value of the windowSize property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public int getWindowSize() {
        if (windowSize == null) {
            return new IntegerAdapter().unmarshal("0");
        } else {
            return windowSize;
        }
    }

    /**
     * Sets the value of the windowSize property.
     * 
     * @param windowSize
     *     allowed object is
     *     {@link String }
     *     
     */
    public TestDistributions setWindowSize(Integer windowSize) {
        this.windowSize = windowSize;
        return this;
    }

    /**
     * Gets the value of the weightField property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getWeightField() {
        return weightField;
    }

    /**
     * Sets the value of the weightField property.
     * 
     * @param weightField
     *     allowed object is
     *     {@link String }
     *     
     */
    public TestDistributions setWeightField(FieldName weightField) {
        this.weightField = weightField;
        return this;
    }

    /**
     * Gets the value of the normalizationScheme property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getNormalizationScheme() {
        return normalizationScheme;
    }

    /**
     * Sets the value of the normalizationScheme property.
     * 
     * @param normalizationScheme
     *     allowed object is
     *     {@link String }
     *     
     */
    public TestDistributions setNormalizationScheme(String normalizationScheme) {
        this.normalizationScheme = normalizationScheme;
        return this;
    }

    /**
     * Gets the value of the baseline property.
     * 
     * @return
     *     possible object is
     *     {@link Baseline }
     *     
     */
    public Baseline getBaseline() {
        return baseline;
    }

    /**
     * Sets the value of the baseline property.
     * 
     * @param baseline
     *     allowed object is
     *     {@link Baseline }
     *     
     */
    public TestDistributions setBaseline(Baseline baseline) {
        this.baseline = baseline;
        return this;
    }

    /**
     * Gets the value of the alternate property.
     * 
     * @return
     *     possible object is
     *     {@link Alternate }
     *     
     */
    public Alternate getAlternate() {
        return alternate;
    }

    /**
     * Sets the value of the alternate property.
     * 
     * @param alternate
     *     allowed object is
     *     {@link Alternate }
     *     
     */
    public TestDistributions setAlternate(Alternate alternate) {
        this.alternate = alternate;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public TestDistributions addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if (status == VisitorAction.CONTINUE) {
            status = org.dmg.pmml.PMMLObject.traverse(visitor, getBaseline(), getAlternate());
        }
        if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
            status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
