
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.DecimalAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="antecedent" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="consequent" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="support" use="required" type="{http://www.dmg.org/PMML-4_2}PROB-NUMBER" />
 *       &lt;attribute name="confidence" use="required" type="{http://www.dmg.org/PMML-4_2}PROB-NUMBER" />
 *       &lt;attribute name="lift" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *       &lt;attribute name="leverage" type="{http://www.dmg.org/PMML-4_2}NUMBER" />
 *       &lt;attribute name="affinity" type="{http://www.dmg.org/PMML-4_2}PROB-NUMBER" />
 *       &lt;attribute name="id" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "AssociationRule", namespace = "http://www.dmg.org/PMML-4_2")
public class AssociationRule
    extends Entity
    implements HasExtensions, HasId
{

    @XmlAttribute(name = "antecedent", required = true)
    private String antecedent;
    @XmlAttribute(name = "consequent", required = true)
    private String consequent;
    @XmlAttribute(name = "support", required = true)
    @XmlJavaTypeAdapter(DecimalAdapter.class)
    private Double support;
    @XmlAttribute(name = "confidence", required = true)
    @XmlJavaTypeAdapter(DecimalAdapter.class)
    private Double confidence;
    @XmlAttribute(name = "lift")
    private Double lift;
    @XmlAttribute(name = "leverage")
    @Added(Version.PMML_4_1)
    private Double leverage;
    @XmlAttribute(name = "affinity")
    @XmlJavaTypeAdapter(DecimalAdapter.class)
    @Added(Version.PMML_4_1)
    private Double affinity;
    @XmlAttribute(name = "id")
    private String id;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;

    public AssociationRule() {
        super();
    }

    public AssociationRule(final String antecedent, final String consequent, final Double support, final Double confidence) {
        super();
        this.antecedent = antecedent;
        this.consequent = consequent;
        this.support = support;
        this.confidence = confidence;
    }

    /**
     * Gets the value of the antecedent property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAntecedent() {
        return antecedent;
    }

    /**
     * Sets the value of the antecedent property.
     * 
     * @param antecedent
     *     allowed object is
     *     {@link String }
     *     
     */
    public AssociationRule setAntecedent(String antecedent) {
        this.antecedent = antecedent;
        return this;
    }

    /**
     * Gets the value of the consequent property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getConsequent() {
        return consequent;
    }

    /**
     * Sets the value of the consequent property.
     * 
     * @param consequent
     *     allowed object is
     *     {@link String }
     *     
     */
    public AssociationRule setConsequent(String consequent) {
        this.consequent = consequent;
        return this;
    }

    /**
     * Gets the value of the support property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Double getSupport() {
        return support;
    }

    /**
     * Sets the value of the support property.
     * 
     * @param support
     *     allowed object is
     *     {@link String }
     *     
     */
    public AssociationRule setSupport(Double support) {
        this.support = support;
        return this;
    }

    /**
     * Gets the value of the confidence property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Double getConfidence() {
        return confidence;
    }

    /**
     * Sets the value of the confidence property.
     * 
     * @param confidence
     *     allowed object is
     *     {@link String }
     *     
     */
    public AssociationRule setConfidence(Double confidence) {
        this.confidence = confidence;
        return this;
    }

    /**
     * Gets the value of the lift property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getLift() {
        return lift;
    }

    /**
     * Sets the value of the lift property.
     * 
     * @param lift
     *     allowed object is
     *     {@link Double }
     *     
     */
    public AssociationRule setLift(Double lift) {
        this.lift = lift;
        return this;
    }

    /**
     * Gets the value of the leverage property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getLeverage() {
        return leverage;
    }

    /**
     * Sets the value of the leverage property.
     * 
     * @param leverage
     *     allowed object is
     *     {@link Double }
     *     
     */
    public AssociationRule setLeverage(Double leverage) {
        this.leverage = leverage;
        return this;
    }

    /**
     * Gets the value of the affinity property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Double getAffinity() {
        return affinity;
    }

    /**
     * Sets the value of the affinity property.
     * 
     * @param affinity
     *     allowed object is
     *     {@link String }
     *     
     */
    public AssociationRule setAffinity(Double affinity) {
        this.affinity = affinity;
        return this;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param id
     *     allowed object is
     *     {@link String }
     *     
     */
    public AssociationRule setId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public AssociationRule addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
            status = PMMLObject.traverse(visitor, getExtensions());
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
