
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;group ref="{http://www.dmg.org/PMML-4_2}EXPRESSION" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="function" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="mapMissingTo" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="defaultValue" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="invalidValueTreatment" type="{http://www.dmg.org/PMML-4_2}INVALID-VALUE-TREATMENT-METHOD" default="returnInvalid" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "expressions"
})
@XmlRootElement(name = "Apply", namespace = "http://www.dmg.org/PMML-4_2")
public class Apply
    extends org.dmg.pmml.Expression
    implements HasExtensions
{

    @XmlAttribute(name = "function", required = true)
    private String function;
    @XmlAttribute(name = "mapMissingTo")
    @Added(Version.PMML_4_1)
    private String mapMissingTo;
    @XmlAttribute(name = "defaultValue")
    @Added(Version.PMML_4_2)
    private String defaultValue;
    @XmlAttribute(name = "invalidValueTreatment")
    @Added(Version.PMML_4_1)
    private InvalidValueTreatmentMethodType invalidValueTreatment;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElements({
        @XmlElement(name = "Constant", namespace = "http://www.dmg.org/PMML-4_2", type = Constant.class),
        @XmlElement(name = "FieldRef", namespace = "http://www.dmg.org/PMML-4_2", type = FieldRef.class),
        @XmlElement(name = "NormContinuous", namespace = "http://www.dmg.org/PMML-4_2", type = NormContinuous.class),
        @XmlElement(name = "NormDiscrete", namespace = "http://www.dmg.org/PMML-4_2", type = NormDiscrete.class),
        @XmlElement(name = "Discretize", namespace = "http://www.dmg.org/PMML-4_2", type = Discretize.class),
        @XmlElement(name = "MapValues", namespace = "http://www.dmg.org/PMML-4_2", type = MapValues.class),
        @XmlElement(name = "TextIndex", namespace = "http://www.dmg.org/PMML-4_2", type = TextIndex.class),
        @XmlElement(name = "Apply", namespace = "http://www.dmg.org/PMML-4_2", type = Apply.class),
        @XmlElement(name = "Aggregate", namespace = "http://www.dmg.org/PMML-4_2", type = Aggregate.class)
    })
    private List<org.dmg.pmml.Expression> expressions;

    public Apply() {
        super();
    }

    public Apply(final String function) {
        super();
        this.function = function;
    }

    /**
     * Gets the value of the function property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFunction() {
        return function;
    }

    /**
     * Sets the value of the function property.
     * 
     * @param function
     *     allowed object is
     *     {@link String }
     *     
     */
    public Apply setFunction(String function) {
        this.function = function;
        return this;
    }

    /**
     * Gets the value of the mapMissingTo property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getMapMissingTo() {
        return mapMissingTo;
    }

    /**
     * Sets the value of the mapMissingTo property.
     * 
     * @param mapMissingTo
     *     allowed object is
     *     {@link String }
     *     
     */
    public Apply setMapMissingTo(String mapMissingTo) {
        this.mapMissingTo = mapMissingTo;
        return this;
    }

    /**
     * Gets the value of the defaultValue property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDefaultValue() {
        return defaultValue;
    }

    /**
     * Sets the value of the defaultValue property.
     * 
     * @param defaultValue
     *     allowed object is
     *     {@link String }
     *     
     */
    public Apply setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    /**
     * Gets the value of the invalidValueTreatment property.
     * 
     * @return
     *     possible object is
     *     {@link InvalidValueTreatmentMethodType }
     *     
     */
    public InvalidValueTreatmentMethodType getInvalidValueTreatment() {
        if (invalidValueTreatment == null) {
            return InvalidValueTreatmentMethodType.RETURN_INVALID;
        } else {
            return invalidValueTreatment;
        }
    }

    /**
     * Sets the value of the invalidValueTreatment property.
     * 
     * @param invalidValueTreatment
     *     allowed object is
     *     {@link InvalidValueTreatmentMethodType }
     *     
     */
    public Apply setInvalidValueTreatment(InvalidValueTreatmentMethodType invalidValueTreatment) {
        this.invalidValueTreatment = invalidValueTreatment;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the expressions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the expressions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExpressions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Constant }
     * {@link FieldRef }
     * {@link NormContinuous }
     * {@link NormDiscrete }
     * {@link Discretize }
     * {@link MapValues }
     * {@link TextIndex }
     * {@link Apply }
     * {@link Aggregate }
     * 
     * 
     */
    public List<org.dmg.pmml.Expression> getExpressions() {
        if (expressions == null) {
            expressions = new ArrayList<org.dmg.pmml.Expression>();
        }
        return this.expressions;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Apply addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasExpressions() {
        return ((this.expressions!= null)&&(this.expressions.size()> 0));
    }

    public Apply addExpressions(org.dmg.pmml.Expression... expressions) {
        getExpressions().addAll(Arrays.asList(expressions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
            status = PMMLObject.traverse(visitor, getExtensions());
        }
        if ((status == VisitorAction.CONTINUE)&&hasExpressions()) {
            status = PMMLObject.traverse(visitor, getExpressions());
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
