
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;group ref="{http://www.dmg.org/PMML-4_2}PREDICATE"/>
 *         &lt;group ref="{http://www.dmg.org/PMML-4_2}MODEL-ELEMENT"/>
 *       &lt;/sequence>
 *       &lt;attribute name="id" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="weight" type="{http://www.dmg.org/PMML-4_2}NUMBER" default="1" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "predicate",
    "model"
})
@XmlRootElement(name = "Segment", namespace = "http://www.dmg.org/PMML-4_2")
@Added(Version.PMML_4_0)
public class Segment
    extends Entity
    implements HasExtensions, HasPredicate
{

    @XmlAttribute(name = "id")
    private String id;
    @XmlAttribute(name = "weight")
    private Double weight;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElements({
        @XmlElement(name = "SimplePredicate", namespace = "http://www.dmg.org/PMML-4_2", type = SimplePredicate.class),
        @XmlElement(name = "CompoundPredicate", namespace = "http://www.dmg.org/PMML-4_2", type = CompoundPredicate.class),
        @XmlElement(name = "SimpleSetPredicate", namespace = "http://www.dmg.org/PMML-4_2", type = SimpleSetPredicate.class),
        @XmlElement(name = "True", namespace = "http://www.dmg.org/PMML-4_2", type = True.class),
        @XmlElement(name = "False", namespace = "http://www.dmg.org/PMML-4_2", type = False.class)
    })
    private Predicate predicate;
    @XmlElements({
        @XmlElement(name = "AssociationModel", namespace = "http://www.dmg.org/PMML-4_2", type = AssociationModel.class),
        @XmlElement(name = "BaselineModel", namespace = "http://www.dmg.org/PMML-4_2", type = BaselineModel.class),
        @XmlElement(name = "ClusteringModel", namespace = "http://www.dmg.org/PMML-4_2", type = ClusteringModel.class),
        @XmlElement(name = "GeneralRegressionModel", namespace = "http://www.dmg.org/PMML-4_2", type = GeneralRegressionModel.class),
        @XmlElement(name = "MiningModel", namespace = "http://www.dmg.org/PMML-4_2", type = MiningModel.class),
        @XmlElement(name = "NaiveBayesModel", namespace = "http://www.dmg.org/PMML-4_2", type = NaiveBayesModel.class),
        @XmlElement(name = "NearestNeighborModel", namespace = "http://www.dmg.org/PMML-4_2", type = NearestNeighborModel.class),
        @XmlElement(name = "NeuralNetwork", namespace = "http://www.dmg.org/PMML-4_2", type = NeuralNetwork.class),
        @XmlElement(name = "RegressionModel", namespace = "http://www.dmg.org/PMML-4_2", type = RegressionModel.class),
        @XmlElement(name = "RuleSetModel", namespace = "http://www.dmg.org/PMML-4_2", type = RuleSetModel.class),
        @XmlElement(name = "SequenceModel", namespace = "http://www.dmg.org/PMML-4_2", type = SequenceModel.class),
        @XmlElement(name = "Scorecard", namespace = "http://www.dmg.org/PMML-4_2", type = Scorecard.class),
        @XmlElement(name = "SupportVectorMachineModel", namespace = "http://www.dmg.org/PMML-4_2", type = SupportVectorMachineModel.class),
        @XmlElement(name = "TextModel", namespace = "http://www.dmg.org/PMML-4_2", type = TextModel.class),
        @XmlElement(name = "TimeSeriesModel", namespace = "http://www.dmg.org/PMML-4_2", type = TimeSeriesModel.class),
        @XmlElement(name = "TreeModel", namespace = "http://www.dmg.org/PMML-4_2", type = TreeModel.class)
    })
    private Model model;

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param id
     *     allowed object is
     *     {@link String }
     *     
     */
    public Segment setId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Gets the value of the weight property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getWeight() {
        if (weight == null) {
            return  1.0D;
        } else {
            return weight;
        }
    }

    /**
     * Sets the value of the weight property.
     * 
     * @param weight
     *     allowed object is
     *     {@link Double }
     *     
     */
    public Segment setWeight(Double weight) {
        this.weight = weight;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the predicate property.
     * 
     * @return
     *     possible object is
     *     {@link SimplePredicate }
     *     {@link CompoundPredicate }
     *     {@link SimpleSetPredicate }
     *     {@link True }
     *     {@link False }
     *     
     */
    public Predicate getPredicate() {
        return predicate;
    }

    /**
     * Sets the value of the predicate property.
     * 
     * @param predicate
     *     allowed object is
     *     {@link SimplePredicate }
     *     {@link CompoundPredicate }
     *     {@link SimpleSetPredicate }
     *     {@link True }
     *     {@link False }
     *     
     */
    public Segment setPredicate(Predicate predicate) {
        this.predicate = predicate;
        return this;
    }

    /**
     * Gets the value of the model property.
     * 
     * @return
     *     possible object is
     *     {@link AssociationModel }
     *     {@link BaselineModel }
     *     {@link ClusteringModel }
     *     {@link GeneralRegressionModel }
     *     {@link MiningModel }
     *     {@link NaiveBayesModel }
     *     {@link NearestNeighborModel }
     *     {@link NeuralNetwork }
     *     {@link RegressionModel }
     *     {@link RuleSetModel }
     *     {@link SequenceModel }
     *     {@link Scorecard }
     *     {@link SupportVectorMachineModel }
     *     {@link TextModel }
     *     {@link TimeSeriesModel }
     *     {@link TreeModel }
     *     
     */
    public Model getModel() {
        return model;
    }

    /**
     * Sets the value of the model property.
     * 
     * @param model
     *     allowed object is
     *     {@link AssociationModel }
     *     {@link BaselineModel }
     *     {@link ClusteringModel }
     *     {@link GeneralRegressionModel }
     *     {@link MiningModel }
     *     {@link NaiveBayesModel }
     *     {@link NearestNeighborModel }
     *     {@link NeuralNetwork }
     *     {@link RegressionModel }
     *     {@link RuleSetModel }
     *     {@link SequenceModel }
     *     {@link Scorecard }
     *     {@link SupportVectorMachineModel }
     *     {@link TextModel }
     *     {@link TimeSeriesModel }
     *     {@link TreeModel }
     *     
     */
    public Segment setModel(Model model) {
        this.model = model;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Segment addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
            status = PMMLObject.traverse(visitor, getExtensions());
        }
        if (status == VisitorAction.CONTINUE) {
            status = PMMLObject.traverse(visitor, getPredicate(), getModel());
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
