
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.DecimalAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Deprecated;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Output" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ModelStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Targets" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}LocalTransformations" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}ResultField" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Node"/>
 *       &lt;/sequence>
 *       &lt;attribute name="modelName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="functionName" use="required" type="{http://www.dmg.org/PMML-4_2}MINING-FUNCTION" />
 *       &lt;attribute name="algorithmName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="missingValueStrategy" type="{http://www.dmg.org/PMML-4_2}MISSING-VALUE-STRATEGY" default="none" />
 *       &lt;attribute name="missingValuePenalty" type="{http://www.dmg.org/PMML-4_2}PROB-NUMBER" default="1.0" />
 *       &lt;attribute name="noTrueChildStrategy" type="{http://www.dmg.org/PMML-4_2}NO-TRUE-CHILD-STRATEGY" default="returnNullPrediction" />
 *       &lt;attribute name="splitCharacteristic" default="multiSplit">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="binarySplit"/>
 *             &lt;enumeration value="multiSplit"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "output",
    "modelStats",
    "targets",
    "localTransformations",
    "resultFields",
    "node"
})
@XmlRootElement(name = "DecisionTree", namespace = "http://www.dmg.org/PMML-4_2")
@Deprecated(Version.PMML_4_1)
public class DecisionTree
    extends EmbeddedModel
    implements HasExtensions
{

    @XmlAttribute(name = "modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    private MiningFunctionType functionName;
    @XmlAttribute(name = "algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "missingValueStrategy")
    @Added(Version.PMML_3_1)
    private MissingValueStrategyType missingValueStrategy;
    @XmlAttribute(name = "missingValuePenalty")
    @XmlJavaTypeAdapter(DecimalAdapter.class)
    @Added(Version.PMML_3_1)
    private Double missingValuePenalty;
    @XmlAttribute(name = "noTrueChildStrategy")
    @Added(Version.PMML_3_1)
    private NoTrueChildStrategyType noTrueChildStrategy;
    @XmlAttribute(name = "splitCharacteristic")
    private DecisionTree.SplitCharacteristic splitCharacteristic;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_2")
    @Added(Version.PMML_4_0)
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_2")
    @Added(Version.PMML_4_0)
    private ModelStats modelStats;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_2")
    @Added(Version.PMML_4_0)
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_2")
    private LocalTransformations localTransformations;
    @XmlElement(name = "ResultField", namespace = "http://www.dmg.org/PMML-4_2")
    private List<ResultField> resultFields;
    @XmlElement(name = "Node", namespace = "http://www.dmg.org/PMML-4_2", required = true)
    private Node node;

    public DecisionTree() {
        super();
    }

    public DecisionTree(final MiningFunctionType functionName, final Node node) {
        super();
        this.functionName = functionName;
        this.node = node;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Sets the value of the modelName property.
     * 
     * @param modelName
     *     allowed object is
     *     {@link String }
     *     
     */
    public DecisionTree setModelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    /**
     * Gets the value of the functionName property.
     * 
     * @return
     *     possible object is
     *     {@link MiningFunctionType }
     *     
     */
    public MiningFunctionType getFunctionName() {
        return functionName;
    }

    /**
     * Sets the value of the functionName property.
     * 
     * @param functionName
     *     allowed object is
     *     {@link MiningFunctionType }
     *     
     */
    public DecisionTree setFunctionName(MiningFunctionType functionName) {
        this.functionName = functionName;
        return this;
    }

    /**
     * Gets the value of the algorithmName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithmName() {
        return algorithmName;
    }

    /**
     * Sets the value of the algorithmName property.
     * 
     * @param algorithmName
     *     allowed object is
     *     {@link String }
     *     
     */
    public DecisionTree setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    /**
     * Gets the value of the missingValueStrategy property.
     * 
     * @return
     *     possible object is
     *     {@link MissingValueStrategyType }
     *     
     */
    public MissingValueStrategyType getMissingValueStrategy() {
        if (missingValueStrategy == null) {
            return MissingValueStrategyType.NONE;
        } else {
            return missingValueStrategy;
        }
    }

    /**
     * Sets the value of the missingValueStrategy property.
     * 
     * @param missingValueStrategy
     *     allowed object is
     *     {@link MissingValueStrategyType }
     *     
     */
    public DecisionTree setMissingValueStrategy(MissingValueStrategyType missingValueStrategy) {
        this.missingValueStrategy = missingValueStrategy;
        return this;
    }

    /**
     * Gets the value of the missingValuePenalty property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Double getMissingValuePenalty() {
        if (missingValuePenalty == null) {
            return new DecimalAdapter().unmarshal("1.0");
        } else {
            return missingValuePenalty;
        }
    }

    /**
     * Sets the value of the missingValuePenalty property.
     * 
     * @param missingValuePenalty
     *     allowed object is
     *     {@link String }
     *     
     */
    public DecisionTree setMissingValuePenalty(Double missingValuePenalty) {
        this.missingValuePenalty = missingValuePenalty;
        return this;
    }

    /**
     * Gets the value of the noTrueChildStrategy property.
     * 
     * @return
     *     possible object is
     *     {@link NoTrueChildStrategyType }
     *     
     */
    public NoTrueChildStrategyType getNoTrueChildStrategy() {
        if (noTrueChildStrategy == null) {
            return NoTrueChildStrategyType.RETURN_NULL_PREDICTION;
        } else {
            return noTrueChildStrategy;
        }
    }

    /**
     * Sets the value of the noTrueChildStrategy property.
     * 
     * @param noTrueChildStrategy
     *     allowed object is
     *     {@link NoTrueChildStrategyType }
     *     
     */
    public DecisionTree setNoTrueChildStrategy(NoTrueChildStrategyType noTrueChildStrategy) {
        this.noTrueChildStrategy = noTrueChildStrategy;
        return this;
    }

    /**
     * Gets the value of the splitCharacteristic property.
     * 
     * @return
     *     possible object is
     *     {@link DecisionTree.SplitCharacteristic }
     *     
     */
    public DecisionTree.SplitCharacteristic getSplitCharacteristic() {
        if (splitCharacteristic == null) {
            return DecisionTree.SplitCharacteristic.MULTI_SPLIT;
        } else {
            return splitCharacteristic;
        }
    }

    /**
     * Sets the value of the splitCharacteristic property.
     * 
     * @param splitCharacteristic
     *     allowed object is
     *     {@link DecisionTree.SplitCharacteristic }
     *     
     */
    public DecisionTree setSplitCharacteristic(DecisionTree.SplitCharacteristic splitCharacteristic) {
        this.splitCharacteristic = splitCharacteristic;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the output property.
     * 
     * @return
     *     possible object is
     *     {@link Output }
     *     
     */
    public Output getOutput() {
        return output;
    }

    /**
     * Sets the value of the output property.
     * 
     * @param output
     *     allowed object is
     *     {@link Output }
     *     
     */
    public DecisionTree setOutput(Output output) {
        this.output = output;
        return this;
    }

    /**
     * Gets the value of the modelStats property.
     * 
     * @return
     *     possible object is
     *     {@link ModelStats }
     *     
     */
    public ModelStats getModelStats() {
        return modelStats;
    }

    /**
     * Sets the value of the modelStats property.
     * 
     * @param modelStats
     *     allowed object is
     *     {@link ModelStats }
     *     
     */
    public DecisionTree setModelStats(ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    /**
     * Gets the value of the targets property.
     * 
     * @return
     *     possible object is
     *     {@link Targets }
     *     
     */
    public Targets getTargets() {
        return targets;
    }

    /**
     * Sets the value of the targets property.
     * 
     * @param targets
     *     allowed object is
     *     {@link Targets }
     *     
     */
    public DecisionTree setTargets(Targets targets) {
        this.targets = targets;
        return this;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param localTransformations
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public DecisionTree setLocalTransformations(LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    /**
     * Gets the value of the resultFields property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the resultFields property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getResultFields().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ResultField }
     * 
     * 
     */
    public List<ResultField> getResultFields() {
        if (resultFields == null) {
            resultFields = new ArrayList<ResultField>();
        }
        return this.resultFields;
    }

    /**
     * Gets the value of the node property.
     * 
     * @return
     *     possible object is
     *     {@link Node }
     *     
     */
    public Node getNode() {
        return node;
    }

    /**
     * Sets the value of the node property.
     * 
     * @param node
     *     allowed object is
     *     {@link Node }
     *     
     */
    public DecisionTree setNode(Node node) {
        this.node = node;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public DecisionTree addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasResultFields() {
        return ((this.resultFields!= null)&&(this.resultFields.size()> 0));
    }

    public DecisionTree addResultFields(ResultField... resultFields) {
        getResultFields().addAll(Arrays.asList(resultFields));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
            status = PMMLObject.traverse(visitor, getExtensions());
        }
        if (status == VisitorAction.CONTINUE) {
            status = PMMLObject.traverse(visitor, getOutput(), getModelStats(), getTargets(), getLocalTransformations());
        }
        if ((status == VisitorAction.CONTINUE)&&hasResultFields()) {
            status = PMMLObject.traverse(visitor, getResultFields());
        }
        if (status == VisitorAction.CONTINUE) {
            status = PMMLObject.traverse(visitor, getNode());
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="binarySplit"/>
     *     &lt;enumeration value="multiSplit"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum SplitCharacteristic {

        @XmlEnumValue("binarySplit")
        BINARY_SPLIT("binarySplit"),
        @XmlEnumValue("multiSplit")
        MULTI_SPLIT("multiSplit");
        private final String value;

        SplitCharacteristic(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static DecisionTree.SplitCharacteristic fromValue(String v) {
            for (DecisionTree.SplitCharacteristic c: DecisionTree.SplitCharacteristic.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
