
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_2}TextIndexNormalization" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;group ref="{http://www.dmg.org/PMML-4_2}EXPRESSION"/>
 *       &lt;/sequence>
 *       &lt;attribute name="textField" use="required" type="{http://www.dmg.org/PMML-4_2}FIELD-NAME" />
 *       &lt;attribute name="localTermWeights" default="termFrequency">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="termFrequency"/>
 *             &lt;enumeration value="binary"/>
 *             &lt;enumeration value="logarithmic"/>
 *             &lt;enumeration value="augmentedNormalizedTermFrequency"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="isCaseSensitive" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       &lt;attribute name="maxLevenshteinDistance" type="{http://www.dmg.org/PMML-4_2}INT-NUMBER" default="0" />
 *       &lt;attribute name="countHits" default="allHits">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="allHits"/>
 *             &lt;enumeration value="bestHits"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="wordSeparatorCharacterRE" type="{http://www.w3.org/2001/XMLSchema}string" default="\s" />
 *       &lt;attribute name="tokenize" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "textIndexNormalizations",
    "expression"
})
@XmlRootElement(name = "TextIndex", namespace = "http://www.dmg.org/PMML-4_2")
@Added(Version.PMML_4_2)
public class TextIndex
    extends org.dmg.pmml.Expression
    implements HasExpression, HasExtensions
{

    @XmlAttribute(name = "textField", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName textField;
    @XmlAttribute(name = "localTermWeights")
    private String localTermWeights;
    @XmlAttribute(name = "isCaseSensitive")
    private Boolean isCaseSensitive;
    @XmlAttribute(name = "maxLevenshteinDistance")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    private Integer maxLevenshteinDistance;
    @XmlAttribute(name = "countHits")
    private String countHits;
    @XmlAttribute(name = "wordSeparatorCharacterRE")
    private String wordSeparatorCharacterRE;
    @XmlAttribute(name = "tokenize")
    private Boolean tokenize;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name = "TextIndexNormalization", namespace = "http://www.dmg.org/PMML-4_2")
    private List<TextIndexNormalization> textIndexNormalizations;
    @XmlElements({
        @XmlElement(name = "Constant", namespace = "http://www.dmg.org/PMML-4_2", type = Constant.class),
        @XmlElement(name = "FieldRef", namespace = "http://www.dmg.org/PMML-4_2", type = FieldRef.class),
        @XmlElement(name = "NormContinuous", namespace = "http://www.dmg.org/PMML-4_2", type = NormContinuous.class),
        @XmlElement(name = "NormDiscrete", namespace = "http://www.dmg.org/PMML-4_2", type = NormDiscrete.class),
        @XmlElement(name = "Discretize", namespace = "http://www.dmg.org/PMML-4_2", type = Discretize.class),
        @XmlElement(name = "MapValues", namespace = "http://www.dmg.org/PMML-4_2", type = MapValues.class),
        @XmlElement(name = "TextIndex", namespace = "http://www.dmg.org/PMML-4_2", type = TextIndex.class),
        @XmlElement(name = "Apply", namespace = "http://www.dmg.org/PMML-4_2", type = Apply.class),
        @XmlElement(name = "Aggregate", namespace = "http://www.dmg.org/PMML-4_2", type = Aggregate.class)
    })
    private org.dmg.pmml.Expression expression;

    public TextIndex() {
        super();
    }

    public TextIndex(final FieldName textField) {
        super();
        this.textField = textField;
    }

    /**
     * Gets the value of the textField property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getTextField() {
        return textField;
    }

    /**
     * Sets the value of the textField property.
     * 
     * @param textField
     *     allowed object is
     *     {@link String }
     *     
     */
    public TextIndex setTextField(FieldName textField) {
        this.textField = textField;
        return this;
    }

    /**
     * Gets the value of the localTermWeights property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLocalTermWeights() {
        if (localTermWeights == null) {
            return "termFrequency";
        } else {
            return localTermWeights;
        }
    }

    /**
     * Sets the value of the localTermWeights property.
     * 
     * @param localTermWeights
     *     allowed object is
     *     {@link String }
     *     
     */
    public TextIndex setLocalTermWeights(String localTermWeights) {
        this.localTermWeights = localTermWeights;
        return this;
    }

    /**
     * Gets the value of the isCaseSensitive property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isIsCaseSensitive() {
        if (isCaseSensitive == null) {
            return false;
        } else {
            return isCaseSensitive;
        }
    }

    /**
     * Sets the value of the isCaseSensitive property.
     * 
     * @param isCaseSensitive
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public TextIndex setIsCaseSensitive(Boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
        return this;
    }

    /**
     * Gets the value of the maxLevenshteinDistance property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Integer getMaxLevenshteinDistance() {
        if (maxLevenshteinDistance == null) {
            return new IntegerAdapter().unmarshal("0");
        } else {
            return maxLevenshteinDistance;
        }
    }

    /**
     * Sets the value of the maxLevenshteinDistance property.
     * 
     * @param maxLevenshteinDistance
     *     allowed object is
     *     {@link String }
     *     
     */
    public TextIndex setMaxLevenshteinDistance(Integer maxLevenshteinDistance) {
        this.maxLevenshteinDistance = maxLevenshteinDistance;
        return this;
    }

    /**
     * Gets the value of the countHits property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCountHits() {
        if (countHits == null) {
            return "allHits";
        } else {
            return countHits;
        }
    }

    /**
     * Sets the value of the countHits property.
     * 
     * @param countHits
     *     allowed object is
     *     {@link String }
     *     
     */
    public TextIndex setCountHits(String countHits) {
        this.countHits = countHits;
        return this;
    }

    /**
     * Gets the value of the wordSeparatorCharacterRE property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getWordSeparatorCharacterRE() {
        if (wordSeparatorCharacterRE == null) {
            return "\\s";
        } else {
            return wordSeparatorCharacterRE;
        }
    }

    /**
     * Sets the value of the wordSeparatorCharacterRE property.
     * 
     * @param wordSeparatorCharacterRE
     *     allowed object is
     *     {@link String }
     *     
     */
    public TextIndex setWordSeparatorCharacterRE(String wordSeparatorCharacterRE) {
        this.wordSeparatorCharacterRE = wordSeparatorCharacterRE;
        return this;
    }

    /**
     * Gets the value of the tokenize property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isTokenize() {
        if (tokenize == null) {
            return true;
        } else {
            return tokenize;
        }
    }

    /**
     * Sets the value of the tokenize property.
     * 
     * @param tokenize
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public TextIndex setTokenize(Boolean tokenize) {
        this.tokenize = tokenize;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the textIndexNormalizations property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the textIndexNormalizations property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTextIndexNormalizations().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextIndexNormalization }
     * 
     * 
     */
    public List<TextIndexNormalization> getTextIndexNormalizations() {
        if (textIndexNormalizations == null) {
            textIndexNormalizations = new ArrayList<TextIndexNormalization>();
        }
        return this.textIndexNormalizations;
    }

    /**
     * Gets the value of the expression property.
     * 
     * @return
     *     possible object is
     *     {@link Constant }
     *     {@link FieldRef }
     *     {@link NormContinuous }
     *     {@link NormDiscrete }
     *     {@link Discretize }
     *     {@link MapValues }
     *     {@link TextIndex }
     *     {@link Apply }
     *     {@link Aggregate }
     *     
     */
    public org.dmg.pmml.Expression getExpression() {
        return expression;
    }

    /**
     * Sets the value of the expression property.
     * 
     * @param expression
     *     allowed object is
     *     {@link Constant }
     *     {@link FieldRef }
     *     {@link NormContinuous }
     *     {@link NormDiscrete }
     *     {@link Discretize }
     *     {@link MapValues }
     *     {@link TextIndex }
     *     {@link Apply }
     *     {@link Aggregate }
     *     
     */
    public TextIndex setExpression(org.dmg.pmml.Expression expression) {
        this.expression = expression;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public TextIndex addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasTextIndexNormalizations() {
        return ((this.textIndexNormalizations!= null)&&(this.textIndexNormalizations.size()> 0));
    }

    public TextIndex addTextIndexNormalizations(TextIndexNormalization... textIndexNormalizations) {
        getTextIndexNormalizations().addAll(Arrays.asList(textIndexNormalizations));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
            status = PMMLObject.traverse(visitor, getExtensions());
        }
        if ((status == VisitorAction.CONTINUE)&&hasTextIndexNormalizations()) {
            status = PMMLObject.traverse(visitor, getTextIndexNormalizations());
        }
        if (status == VisitorAction.CONTINUE) {
            status = PMMLObject.traverse(visitor, getExpression());
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
