
package org.dmg.pmml;

import java.util.Deque;

public interface Visitor {


    /**
     * @see Visitable#accept(Visitor)
     * 
     */
    public void applyTo(Visitable visitable);

    public void pushParent(PMMLObject object);

    public PMMLObject popParent();

    public Deque<PMMLObject> getParents();

    public VisitorAction visit(NormDiscrete normDiscrete);

    public VisitorAction visit(Interval interval);

    public VisitorAction visit(Aggregate aggregate);

    public VisitorAction visit(OutputField outputField);

    public VisitorAction visit(Array array);

    public VisitorAction visit(UnivariateStats univariateStats);

    public VisitorAction visit(Matrix matrix);

    public VisitorAction visit(PartitionFieldStats partitionFieldStats);

    public VisitorAction visit(Target target);

    public VisitorAction visit(Value value);

    public VisitorAction visit(SimplePredicate simplePredicate);

    public VisitorAction visit(SimpleSetPredicate simpleSetPredicate);

    public VisitorAction visit(CompoundPredicate compoundPredicate);

    public VisitorAction visit(DecisionTree decisionTree);

    public VisitorAction visit(ComparisonMeasure comparisonMeasure);

    public VisitorAction visit(ClusteringField clusteringField);

    public VisitorAction visit(ClusteringModel clusteringModel);

    public VisitorAction visit(PCovMatrix pCovMatrix);

    public VisitorAction visit(GeneralRegressionModel generalRegressionModel);

    public VisitorAction visit(RegressionModel regressionModel);

    public VisitorAction visit(RuleSelectionMethod ruleSelectionMethod);

    public VisitorAction visit(Scorecard scorecard);

    public VisitorAction visit(ChildParent childParent);

    public VisitorAction visit(TextModelNormalization textModelNormalization);

    public VisitorAction visit(TextModelSimiliarity textModelSimiliarity);

    public VisitorAction visit(TrendExpoSmooth trendExpoSmooth);

    public VisitorAction visit(TreeModel treeModel);

    public VisitorAction visit(DataField dataField);

    public VisitorAction visit(DefineFunction defineFunction);

    public VisitorAction visit(Extension extension);

    public VisitorAction visit(ParameterField parameterField);

    public VisitorAction visit(Constant constant);

    public VisitorAction visit(FieldRef fieldRef);

    public VisitorAction visit(NormContinuous normContinuous);

    public VisitorAction visit(LinearNorm linearNorm);

    public VisitorAction visit(Discretize discretize);

    public VisitorAction visit(DiscretizeBin discretizeBin);

    public VisitorAction visit(MapValues mapValues);

    public VisitorAction visit(FieldColumnPair fieldColumnPair);

    public VisitorAction visit(TableLocator tableLocator);

    public VisitorAction visit(InlineTable inlineTable);

    public VisitorAction visit(Row row);

    public VisitorAction visit(TextIndex textIndex);

    public VisitorAction visit(TextIndexNormalization textIndexNormalization);

    public VisitorAction visit(Apply apply);

    public VisitorAction visit(MiningModel miningModel);

    public VisitorAction visit(MiningSchema miningSchema);

    public VisitorAction visit(MiningField miningField);

    public VisitorAction visit(Output output);

    public VisitorAction visit(Decisions decisions);

    public VisitorAction visit(Decision decision);

    public VisitorAction visit(ModelStats modelStats);

    public VisitorAction visit(Counts counts);

    public VisitorAction visit(NumericInfo numericInfo);

    public VisitorAction visit(Quantile quantile);

    public VisitorAction visit(DiscrStats discrStats);

    public VisitorAction visit(ContStats contStats);

    public VisitorAction visit(Anova anova);

    public VisitorAction visit(AnovaRow anovaRow);

    public VisitorAction visit(MultivariateStats multivariateStats);

    public VisitorAction visit(MultivariateStat multivariateStat);

    public VisitorAction visit(ModelExplanation modelExplanation);

    public VisitorAction visit(PredictiveModelQuality predictiveModelQuality);

    public VisitorAction visit(ConfusionMatrix confusionMatrix);

    public VisitorAction visit(ClassLabels classLabels);

    public VisitorAction visit(MatCell matCell);

    public VisitorAction visit(LiftData liftData);

    public VisitorAction visit(ModelLiftGraph modelLiftGraph);

    public VisitorAction visit(LiftGraph liftGraph);

    public VisitorAction visit(XCoordinates xCoordinates);

    public VisitorAction visit(YCoordinates yCoordinates);

    public VisitorAction visit(BoundaryValues boundaryValues);

    public VisitorAction visit(BoundaryValueMeans boundaryValueMeans);

    public VisitorAction visit(OptimumLiftGraph optimumLiftGraph);

    public VisitorAction visit(RandomLiftGraph randomLiftGraph);

    public VisitorAction visit(ROC roc);

    public VisitorAction visit(ROCGraph rocGraph);

    public VisitorAction visit(ClusteringModelQuality clusteringModelQuality);

    public VisitorAction visit(Correlations correlations);

    public VisitorAction visit(CorrelationFields correlationFields);

    public VisitorAction visit(CorrelationValues correlationValues);

    public VisitorAction visit(CorrelationMethods correlationMethods);

    public VisitorAction visit(Targets targets);

    public VisitorAction visit(TargetValue targetValue);

    public VisitorAction visit(Partition partition);

    public VisitorAction visit(LocalTransformations localTransformations);

    public VisitorAction visit(DerivedField derivedField);

    public VisitorAction visit(Regression regression);

    public VisitorAction visit(ResultField resultField);

    public VisitorAction visit(RegressionTable regressionTable);

    public VisitorAction visit(NumericPredictor numericPredictor);

    public VisitorAction visit(CategoricalPredictor categoricalPredictor);

    public VisitorAction visit(PredictorTerm predictorTerm);

    public VisitorAction visit(Node node);

    public VisitorAction visit(True _true);

    public VisitorAction visit(False _false);

    public VisitorAction visit(ScoreDistribution scoreDistribution);

    public VisitorAction visit(Segmentation segmentation);

    public VisitorAction visit(Segment segment);

    public VisitorAction visit(AssociationModel associationModel);

    public VisitorAction visit(Item item);

    public VisitorAction visit(Itemset itemset);

    public VisitorAction visit(ItemRef itemRef);

    public VisitorAction visit(AssociationRule associationRule);

    public VisitorAction visit(ModelVerification modelVerification);

    public VisitorAction visit(VerificationFields verificationFields);

    public VisitorAction visit(VerificationField verificationField);

    public VisitorAction visit(BaselineModel baselineModel);

    public VisitorAction visit(TestDistributions testDistributions);

    public VisitorAction visit(Baseline baseline);

    public VisitorAction visit(AnyDistribution anyDistribution);

    public VisitorAction visit(GaussianDistribution gaussianDistribution);

    public VisitorAction visit(PoissonDistribution poissonDistribution);

    public VisitorAction visit(UniformDistribution uniformDistribution);

    public VisitorAction visit(CountTable countTable);

    public VisitorAction visit(Alternate alternate);

    public VisitorAction visit(Euclidean euclidean);

    public VisitorAction visit(SquaredEuclidean squaredEuclidean);

    public VisitorAction visit(Chebychev chebychev);

    public VisitorAction visit(CityBlock cityBlock);

    public VisitorAction visit(Minkowski minkowski);

    public VisitorAction visit(SimpleMatching simpleMatching);

    public VisitorAction visit(Jaccard jaccard);

    public VisitorAction visit(Tanimoto tanimoto);

    public VisitorAction visit(BinarySimilarity binarySimilarity);

    public VisitorAction visit(Comparisons comparisons);

    public VisitorAction visit(CenterFields centerFields);

    public VisitorAction visit(MissingValueWeights missingValueWeights);

    public VisitorAction visit(Cluster cluster);

    public VisitorAction visit(KohonenMap kohonenMap);

    public VisitorAction visit(Covariances covariances);

    public VisitorAction visit(ParameterList parameterList);

    public VisitorAction visit(Parameter parameter);

    public VisitorAction visit(FactorList factorList);

    public VisitorAction visit(Predictor predictor);

    public VisitorAction visit(Categories categories);

    public VisitorAction visit(Category category);

    public VisitorAction visit(CovariateList covariateList);

    public VisitorAction visit(PPMatrix ppMatrix);

    public VisitorAction visit(PPCell ppCell);

    public VisitorAction visit(PCovCell pCovCell);

    public VisitorAction visit(ParamMatrix paramMatrix);

    public VisitorAction visit(PCell pCell);

    public VisitorAction visit(EventValues eventValues);

    public VisitorAction visit(BaseCumHazardTables baseCumHazardTables);

    public VisitorAction visit(BaselineStratum baselineStratum);

    public VisitorAction visit(BaselineCell baselineCell);

    public VisitorAction visit(NaiveBayesModel naiveBayesModel);

    public VisitorAction visit(BayesInputs bayesInputs);

    public VisitorAction visit(BayesInput bayesInput);

    public VisitorAction visit(TargetValueStats targetValueStats);

    public VisitorAction visit(TargetValueStat targetValueStat);

    public VisitorAction visit(PairCounts pairCounts);

    public VisitorAction visit(TargetValueCounts targetValueCounts);

    public VisitorAction visit(TargetValueCount targetValueCount);

    public VisitorAction visit(BayesOutput bayesOutput);

    public VisitorAction visit(NearestNeighborModel nearestNeighborModel);

    public VisitorAction visit(TrainingInstances trainingInstances);

    public VisitorAction visit(InstanceFields instanceFields);

    public VisitorAction visit(InstanceField instanceField);

    public VisitorAction visit(KNNInputs knnInputs);

    public VisitorAction visit(KNNInput knnInput);

    public VisitorAction visit(NeuralNetwork neuralNetwork);

    public VisitorAction visit(NeuralInputs neuralInputs);

    public VisitorAction visit(NeuralInput neuralInput);

    public VisitorAction visit(NeuralLayer neuralLayer);

    public VisitorAction visit(Neuron neuron);

    public VisitorAction visit(Connection connection);

    public VisitorAction visit(NeuralOutputs neuralOutputs);

    public VisitorAction visit(NeuralOutput neuralOutput);

    public VisitorAction visit(RuleSetModel ruleSetModel);

    public VisitorAction visit(RuleSet ruleSet);

    public VisitorAction visit(SimpleRule simpleRule);

    public VisitorAction visit(CompoundRule compoundRule);

    public VisitorAction visit(SequenceModel sequenceModel);

    public VisitorAction visit(Constraints constraints);

    public VisitorAction visit(SetPredicate setPredicate);

    public VisitorAction visit(Sequence sequence);

    public VisitorAction visit(SetReference setReference);

    public VisitorAction visit(Delimiter delimiter);

    public VisitorAction visit(Time time);

    public VisitorAction visit(SequenceRule sequenceRule);

    public VisitorAction visit(AntecedentSequence antecedentSequence);

    public VisitorAction visit(SequenceReference sequenceReference);

    public VisitorAction visit(ConsequentSequence consequentSequence);

    public VisitorAction visit(Characteristics characteristics);

    public VisitorAction visit(Characteristic characteristic);

    public VisitorAction visit(Attribute attribute);

    public VisitorAction visit(ComplexPartialScore complexPartialScore);

    public VisitorAction visit(SupportVectorMachineModel supportVectorMachineModel);

    public VisitorAction visit(LinearKernel linearKernel);

    public VisitorAction visit(PolynomialKernel polynomialKernel);

    public VisitorAction visit(RadialBasisKernel radialBasisKernel);

    public VisitorAction visit(SigmoidKernel sigmoidKernel);

    public VisitorAction visit(VectorDictionary vectorDictionary);

    public VisitorAction visit(VectorFields vectorFields);

    public VisitorAction visit(VectorInstance vectorInstance);

    public VisitorAction visit(RealSparseArray realSparseArray);

    public VisitorAction visit(SupportVectorMachine supportVectorMachine);

    public VisitorAction visit(SupportVectors supportVectors);

    public VisitorAction visit(SupportVector supportVector);

    public VisitorAction visit(Coefficients coefficients);

    public VisitorAction visit(Coefficient coefficient);

    public VisitorAction visit(TextModel textModel);

    public VisitorAction visit(TextDictionary textDictionary);

    public VisitorAction visit(Taxonomy taxonomy);

    public VisitorAction visit(TextCorpus textCorpus);

    public VisitorAction visit(TextDocument textDocument);

    public VisitorAction visit(DocumentTermMatrix documentTermMatrix);

    public VisitorAction visit(TimeSeriesModel timeSeriesModel);

    public VisitorAction visit(TimeSeries timeSeries);

    public VisitorAction visit(TimeAnchor timeAnchor);

    public VisitorAction visit(TimeCycle timeCycle);

    public VisitorAction visit(TimeException timeException);

    public VisitorAction visit(TimeValue timeValue);

    public VisitorAction visit(Timestamp timestamp);

    public VisitorAction visit(SpectralAnalysis spectralAnalysis);

    public VisitorAction visit(ARIMA arima);

    public VisitorAction visit(ExponentialSmoothing exponentialSmoothing);

    public VisitorAction visit(Level level);

    public VisitorAction visit(SeasonalityExpoSmooth seasonalityExpoSmooth);

    public VisitorAction visit(SeasonalTrendDecomposition seasonalTrendDecomposition);

    public VisitorAction visit(PMML pmml);

    public VisitorAction visit(Header header);

    public VisitorAction visit(Application application);

    public VisitorAction visit(Annotation annotation);

    public VisitorAction visit(MiningBuildTask miningBuildTask);

    public VisitorAction visit(DataDictionary dataDictionary);

    public VisitorAction visit(TransformationDictionary transformationDictionary);

    public VisitorAction visit(IntSparseArray intSparseArray);

    public VisitorAction visit(FieldValue fieldValue);

    public VisitorAction visit(FieldValueCount fieldValueCount);

}
