/*
 * Copyright (c) 2009 University of Tartu
 */
package org.dmg.pmml;

import javax.xml.bind.annotation.XmlTransient;

@XmlTransient
abstract
public class Model extends PMMLObject implements HasExtensions {

	abstract
	public String getModelName();

	abstract
	public Model setModelName(String modelName);

	abstract
	public MiningFunction getMiningFunction();

	abstract
	public Model setMiningFunction(MiningFunction miningFunction);

	public String getAlgorithmName(){
		return null;
	}

	/**
	 * @throws UnsupportedOperationException If the <code>algorithmName</code> attribute is not supported.
	 */
	public Model setAlgorithmName(String algorithmName){
		throw new UnsupportedOperationException();
	}

	abstract
	public boolean isScorable();

	abstract
	public Model setScorable(Boolean scorable);

	abstract
	public MiningSchema getMiningSchema();

	abstract
	public Model setMiningSchema(MiningSchema miningSchema);

	abstract
	public LocalTransformations getLocalTransformations();

	abstract
	public Model setLocalTransformations(LocalTransformations localTransformations);

	public Targets getTargets(){
		return null;
	}

	/**
	 * @throws UnsupportedOperationException If the {@link Targets} child element is not supported.
	 */
	public Model setTargets(Targets targets){
		throw new UnsupportedOperationException();
	}

	public Output getOutput(){
		return null;
	}

	/**
	 * @throws UnsupportedOperationException If the {@link Output} child element is not supported.
	 */
	public Model setOutput(Output output){
		throw new UnsupportedOperationException();
	}

	abstract
	public ModelStats getModelStats();

	abstract
	public Model setModelStats(ModelStats modelStats);

	public ModelExplanation getModelExplanation(){
		return null;
	}

	/**
	 * @throws UnsupportedOperationException If the {@link ModelExplanation} child element is not supported.
	 */
	public Model setModelExplanation(ModelExplanation modelExplanation){
		throw new UnsupportedOperationException();
	}

	public ModelVerification getModelVerification(){
		return null;
	}

	/**
	 * @throws UnsupportedOperationException If the {@link ModelVerification} child element is not supported.
	 */
	public Model setModelVerification(ModelVerification modelVerification){
		throw new UnsupportedOperationException();
	}
}