
package org.dmg.pmml.rule_set;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.ScoreDistribution;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}RuleSelectionMethod" maxOccurs="unbounded"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}ScoreDistribution" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;group ref="{http://www.dmg.org/PMML-4_3}Rule" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="recordCount" type="{http://www.dmg.org/PMML-4_3}NUMBER" />
 *       &lt;attribute name="nbCorrect" type="{http://www.dmg.org/PMML-4_3}NUMBER" />
 *       &lt;attribute name="defaultScore" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="defaultConfidence" type="{http://www.dmg.org/PMML-4_3}NUMBER" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "ruleSelectionMethods",
    "scoreDistributions",
    "rules"
})
@XmlRootElement(name = "RuleSet", namespace = "http://www.dmg.org/PMML-4_3")
public class RuleSet
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions
{

    @XmlAttribute(name = "recordCount")
    private Double recordCount;
    @XmlAttribute(name = "nbCorrect")
    private Double nbCorrect;
    @XmlAttribute(name = "defaultScore")
    private String defaultScore;
    @XmlAttribute(name = "defaultConfidence")
    private Double defaultConfidence;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "RuleSelectionMethod", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private List<RuleSelectionMethod> ruleSelectionMethods;
    @XmlElement(name = "ScoreDistribution", namespace = "http://www.dmg.org/PMML-4_3")
    private List<ScoreDistribution> scoreDistributions;
    @XmlElements({
        @XmlElement(name = "SimpleRule", namespace = "http://www.dmg.org/PMML-4_3", type = SimpleRule.class),
        @XmlElement(name = "CompoundRule", namespace = "http://www.dmg.org/PMML-4_3", type = CompoundRule.class)
    })
    private List<Rule> rules;

    public RuleSet() {
        super();
    }

    public RuleSet(final List<RuleSelectionMethod> ruleSelectionMethods) {
        super();
        this.ruleSelectionMethods = ruleSelectionMethods;
    }

    /**
     * Gets the value of the recordCount property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getRecordCount() {
        return recordCount;
    }

    /**
     * Sets the value of the recordCount property.
     * 
     * @param recordCount
     *     allowed object is
     *     {@link Double }
     *     
     */
    public RuleSet setRecordCount(Double recordCount) {
        this.recordCount = recordCount;
        return this;
    }

    /**
     * Gets the value of the nbCorrect property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getNbCorrect() {
        return nbCorrect;
    }

    /**
     * Sets the value of the nbCorrect property.
     * 
     * @param nbCorrect
     *     allowed object is
     *     {@link Double }
     *     
     */
    public RuleSet setNbCorrect(Double nbCorrect) {
        this.nbCorrect = nbCorrect;
        return this;
    }

    /**
     * Gets the value of the defaultScore property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDefaultScore() {
        return defaultScore;
    }

    /**
     * Sets the value of the defaultScore property.
     * 
     * @param defaultScore
     *     allowed object is
     *     {@link String }
     *     
     */
    public RuleSet setDefaultScore(String defaultScore) {
        this.defaultScore = defaultScore;
        return this;
    }

    /**
     * Gets the value of the defaultConfidence property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getDefaultConfidence() {
        return defaultConfidence;
    }

    /**
     * Sets the value of the defaultConfidence property.
     * 
     * @param defaultConfidence
     *     allowed object is
     *     {@link Double }
     *     
     */
    public RuleSet setDefaultConfidence(Double defaultConfidence) {
        this.defaultConfidence = defaultConfidence;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the ruleSelectionMethods property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the ruleSelectionMethods property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRuleSelectionMethods().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link RuleSelectionMethod }
     * 
     * 
     */
    public List<RuleSelectionMethod> getRuleSelectionMethods() {
        if (ruleSelectionMethods == null) {
            ruleSelectionMethods = new ArrayList<RuleSelectionMethod>();
        }
        return this.ruleSelectionMethods;
    }

    /**
     * Gets the value of the scoreDistributions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the scoreDistributions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getScoreDistributions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ScoreDistribution }
     * 
     * 
     */
    public List<ScoreDistribution> getScoreDistributions() {
        if (scoreDistributions == null) {
            scoreDistributions = new ArrayList<ScoreDistribution>();
        }
        return this.scoreDistributions;
    }

    /**
     * Gets the value of the rules property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the rules property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRules().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SimpleRule }
     * {@link CompoundRule }
     * 
     * 
     */
    public List<Rule> getRules() {
        if (rules == null) {
            rules = new ArrayList<Rule>();
        }
        return this.rules;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public RuleSet addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasRuleSelectionMethods() {
        return ((this.ruleSelectionMethods!= null)&&(this.ruleSelectionMethods.size()> 0));
    }

    public RuleSet addRuleSelectionMethods(RuleSelectionMethod... ruleSelectionMethods) {
        getRuleSelectionMethods().addAll(Arrays.asList(ruleSelectionMethods));
        return this;
    }

    public boolean hasScoreDistributions() {
        return ((this.scoreDistributions!= null)&&(this.scoreDistributions.size()> 0));
    }

    public RuleSet addScoreDistributions(ScoreDistribution... scoreDistributions) {
        getScoreDistributions().addAll(Arrays.asList(scoreDistributions));
        return this;
    }

    public boolean hasRules() {
        return ((this.rules!= null)&&(this.rules.size()> 0));
    }

    public RuleSet addRules(Rule... rules) {
        getRules().addAll(Arrays.asList(rules));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasRuleSelectionMethods()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getRuleSelectionMethods());
            }
            if ((status == VisitorAction.CONTINUE)&&hasScoreDistributions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getScoreDistributions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasRules()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getRules());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
