
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;choice>
 *           &lt;element ref="{http://www.dmg.org/PMML-4_3}euclidean"/>
 *           &lt;element ref="{http://www.dmg.org/PMML-4_3}squaredEuclidean"/>
 *           &lt;element ref="{http://www.dmg.org/PMML-4_3}chebychev"/>
 *           &lt;element ref="{http://www.dmg.org/PMML-4_3}cityBlock"/>
 *           &lt;element ref="{http://www.dmg.org/PMML-4_3}minkowski"/>
 *           &lt;element ref="{http://www.dmg.org/PMML-4_3}simpleMatching"/>
 *           &lt;element ref="{http://www.dmg.org/PMML-4_3}jaccard"/>
 *           &lt;element ref="{http://www.dmg.org/PMML-4_3}tanimoto"/>
 *           &lt;element ref="{http://www.dmg.org/PMML-4_3}binarySimilarity"/>
 *         &lt;/choice>
 *       &lt;/sequence>
 *       &lt;attribute name="kind" use="required">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="distance"/>
 *             &lt;enumeration value="similarity"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="compareFunction" type="{http://www.dmg.org/PMML-4_3}COMPARE-FUNCTION" default="absDiff" />
 *       &lt;attribute name="minimum" type="{http://www.dmg.org/PMML-4_3}NUMBER" />
 *       &lt;attribute name="maximum" type="{http://www.dmg.org/PMML-4_3}NUMBER" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "measure"
})
@XmlRootElement(name = "ComparisonMeasure", namespace = "http://www.dmg.org/PMML-4_3")
public class ComparisonMeasure
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions
{

    @XmlAttribute(name = "kind", required = true)
    private ComparisonMeasure.Kind kind;
    @XmlAttribute(name = "compareFunction")
    private CompareFunction compareFunction;
    @XmlAttribute(name = "minimum")
    private Double minimum;
    @XmlAttribute(name = "maximum")
    private Double maximum;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElements({
        @XmlElement(name = "euclidean", namespace = "http://www.dmg.org/PMML-4_3", type = Euclidean.class),
        @XmlElement(name = "squaredEuclidean", namespace = "http://www.dmg.org/PMML-4_3", type = SquaredEuclidean.class),
        @XmlElement(name = "chebychev", namespace = "http://www.dmg.org/PMML-4_3", type = Chebychev.class),
        @XmlElement(name = "cityBlock", namespace = "http://www.dmg.org/PMML-4_3", type = CityBlock.class),
        @XmlElement(name = "minkowski", namespace = "http://www.dmg.org/PMML-4_3", type = Minkowski.class),
        @XmlElement(name = "simpleMatching", namespace = "http://www.dmg.org/PMML-4_3", type = SimpleMatching.class),
        @XmlElement(name = "jaccard", namespace = "http://www.dmg.org/PMML-4_3", type = Jaccard.class),
        @XmlElement(name = "tanimoto", namespace = "http://www.dmg.org/PMML-4_3", type = Tanimoto.class),
        @XmlElement(name = "binarySimilarity", namespace = "http://www.dmg.org/PMML-4_3", type = BinarySimilarity.class)
    })
    private Measure measure;

    public ComparisonMeasure() {
        super();
    }

    public ComparisonMeasure(final ComparisonMeasure.Kind kind) {
        super();
        this.kind = kind;
    }

    /**
     * Gets the value of the kind property.
     * 
     * @return
     *     possible object is
     *     {@link ComparisonMeasure.Kind }
     *     
     */
    public ComparisonMeasure.Kind getKind() {
        return kind;
    }

    /**
     * Sets the value of the kind property.
     * 
     * @param kind
     *     allowed object is
     *     {@link ComparisonMeasure.Kind }
     *     
     */
    public ComparisonMeasure setKind(ComparisonMeasure.Kind kind) {
        this.kind = kind;
        return this;
    }

    /**
     * Gets the value of the compareFunction property.
     * 
     * @return
     *     possible object is
     *     {@link CompareFunction }
     *     
     */
    public CompareFunction getCompareFunction() {
        if (compareFunction == null) {
            return CompareFunction.ABS_DIFF;
        } else {
            return compareFunction;
        }
    }

    /**
     * Sets the value of the compareFunction property.
     * 
     * @param compareFunction
     *     allowed object is
     *     {@link CompareFunction }
     *     
     */
    public ComparisonMeasure setCompareFunction(CompareFunction compareFunction) {
        this.compareFunction = compareFunction;
        return this;
    }

    /**
     * Gets the value of the minimum property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getMinimum() {
        return minimum;
    }

    /**
     * Sets the value of the minimum property.
     * 
     * @param minimum
     *     allowed object is
     *     {@link Double }
     *     
     */
    public ComparisonMeasure setMinimum(Double minimum) {
        this.minimum = minimum;
        return this;
    }

    /**
     * Gets the value of the maximum property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getMaximum() {
        return maximum;
    }

    /**
     * Sets the value of the maximum property.
     * 
     * @param maximum
     *     allowed object is
     *     {@link Double }
     *     
     */
    public ComparisonMeasure setMaximum(Double maximum) {
        this.maximum = maximum;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the measure property.
     * 
     * @return
     *     possible object is
     *     {@link Euclidean }
     *     {@link SquaredEuclidean }
     *     {@link Chebychev }
     *     {@link CityBlock }
     *     {@link Minkowski }
     *     {@link SimpleMatching }
     *     {@link Jaccard }
     *     {@link Tanimoto }
     *     {@link BinarySimilarity }
     *     
     */
    public Measure getMeasure() {
        return measure;
    }

    /**
     * Sets the value of the measure property.
     * 
     * @param measure
     *     allowed object is
     *     {@link Euclidean }
     *     {@link SquaredEuclidean }
     *     {@link Chebychev }
     *     {@link CityBlock }
     *     {@link Minkowski }
     *     {@link SimpleMatching }
     *     {@link Jaccard }
     *     {@link Tanimoto }
     *     {@link BinarySimilarity }
     *     
     */
    public ComparisonMeasure setMeasure(Measure measure) {
        this.measure = measure;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public ComparisonMeasure addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getMeasure());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="distance"/>
     *     &lt;enumeration value="similarity"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum Kind {

        @XmlEnumValue("distance")
        DISTANCE("distance"),
        @XmlEnumValue("similarity")
        SIMILARITY("similarity");
        private final String value;

        Kind(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static ComparisonMeasure.Kind fromValue(String v) {
            for (ComparisonMeasure.Kind c: ComparisonMeasure.Kind.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
