
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Deprecated;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="name" use="required" type="{http://www.dmg.org/PMML-4_3}FIELD-NAME" />
 *       &lt;attribute name="usageType" default="active">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="active"/>
 *             &lt;enumeration value="predicted"/>
 *             &lt;enumeration value="target"/>
 *             &lt;enumeration value="supplementary"/>
 *             &lt;enumeration value="group"/>
 *             &lt;enumeration value="order"/>
 *             &lt;enumeration value="frequencyWeight"/>
 *             &lt;enumeration value="analysisWeight"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="optype" type="{http://www.dmg.org/PMML-4_3}OPTYPE" />
 *       &lt;attribute name="importance" type="{http://www.dmg.org/PMML-4_3}PROB-NUMBER" />
 *       &lt;attribute name="outliers" type="{http://www.dmg.org/PMML-4_3}OUTLIER-TREATMENT-METHOD" default="asIs" />
 *       &lt;attribute name="lowValue" type="{http://www.dmg.org/PMML-4_3}NUMBER" />
 *       &lt;attribute name="highValue" type="{http://www.dmg.org/PMML-4_3}NUMBER" />
 *       &lt;attribute name="missingValueReplacement" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="missingValueTreatment" type="{http://www.dmg.org/PMML-4_3}MISSING-VALUE-TREATMENT-METHOD" />
 *       &lt;attribute name="invalidValueTreatment" type="{http://www.dmg.org/PMML-4_3}INVALID-VALUE-TREATMENT-METHOD" default="returnInvalid" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "MiningField", namespace = "http://www.dmg.org/PMML-4_3")
public class MiningField
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<MiningField> , Indexable<org.dmg.pmml.FieldName>
{

    @XmlAttribute(name = "name", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private org.dmg.pmml.FieldName name;
    @XmlAttribute(name = "usageType")
    private MiningField.UsageType usageType;
    @XmlAttribute(name = "optype")
    private OpType opType;
    @XmlAttribute(name = "importance")
    private Double importance;
    @XmlAttribute(name = "outliers")
    private OutlierTreatmentMethod outlierTreatment;
    @XmlAttribute(name = "lowValue")
    private Double lowValue;
    @XmlAttribute(name = "highValue")
    private Double highValue;
    @XmlAttribute(name = "missingValueReplacement")
    private String missingValueReplacement;
    @XmlAttribute(name = "missingValueTreatment")
    private MissingValueTreatmentMethod missingValueTreatment;
    @XmlAttribute(name = "invalidValueTreatment")
    @Added(Version.PMML_3_1)
    private InvalidValueTreatmentMethod invalidValueTreatment;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;

    public MiningField() {
        super();
    }

    public MiningField(final org.dmg.pmml.FieldName name) {
        super();
        this.name = name;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public org.dmg.pmml.FieldName getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param name
     *     allowed object is
     *     {@link String }
     *     
     */
    public MiningField setName(org.dmg.pmml.FieldName name) {
        this.name = name;
        return this;
    }

    /**
     * Gets the value of the usageType property.
     * 
     * @return
     *     possible object is
     *     {@link MiningField.UsageType }
     *     
     */
    public MiningField.UsageType getUsageType() {
        if (usageType == null) {
            return MiningField.UsageType.ACTIVE;
        } else {
            return usageType;
        }
    }

    /**
     * Sets the value of the usageType property.
     * 
     * @param usageType
     *     allowed object is
     *     {@link MiningField.UsageType }
     *     
     */
    public MiningField setUsageType(MiningField.UsageType usageType) {
        this.usageType = usageType;
        return this;
    }

    /**
     * Gets the value of the opType property.
     * 
     * @return
     *     possible object is
     *     {@link OpType }
     *     
     */
    public OpType getOpType() {
        return opType;
    }

    /**
     * Sets the value of the opType property.
     * 
     * @param opType
     *     allowed object is
     *     {@link OpType }
     *     
     */
    public MiningField setOpType(OpType opType) {
        this.opType = opType;
        return this;
    }

    /**
     * Gets the value of the importance property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getImportance() {
        return importance;
    }

    /**
     * Sets the value of the importance property.
     * 
     * @param importance
     *     allowed object is
     *     {@link Double }
     *     
     */
    public MiningField setImportance(Double importance) {
        this.importance = importance;
        return this;
    }

    /**
     * Gets the value of the outlierTreatment property.
     * 
     * @return
     *     possible object is
     *     {@link OutlierTreatmentMethod }
     *     
     */
    public OutlierTreatmentMethod getOutlierTreatment() {
        if (outlierTreatment == null) {
            return OutlierTreatmentMethod.AS_IS;
        } else {
            return outlierTreatment;
        }
    }

    /**
     * Sets the value of the outlierTreatment property.
     * 
     * @param outlierTreatment
     *     allowed object is
     *     {@link OutlierTreatmentMethod }
     *     
     */
    public MiningField setOutlierTreatment(OutlierTreatmentMethod outlierTreatment) {
        this.outlierTreatment = outlierTreatment;
        return this;
    }

    /**
     * Gets the value of the lowValue property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getLowValue() {
        return lowValue;
    }

    /**
     * Sets the value of the lowValue property.
     * 
     * @param lowValue
     *     allowed object is
     *     {@link Double }
     *     
     */
    public MiningField setLowValue(Double lowValue) {
        this.lowValue = lowValue;
        return this;
    }

    /**
     * Gets the value of the highValue property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getHighValue() {
        return highValue;
    }

    /**
     * Sets the value of the highValue property.
     * 
     * @param highValue
     *     allowed object is
     *     {@link Double }
     *     
     */
    public MiningField setHighValue(Double highValue) {
        this.highValue = highValue;
        return this;
    }

    /**
     * Gets the value of the missingValueReplacement property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getMissingValueReplacement() {
        return missingValueReplacement;
    }

    /**
     * Sets the value of the missingValueReplacement property.
     * 
     * @param missingValueReplacement
     *     allowed object is
     *     {@link String }
     *     
     */
    public MiningField setMissingValueReplacement(String missingValueReplacement) {
        this.missingValueReplacement = missingValueReplacement;
        return this;
    }

    /**
     * Gets the value of the missingValueTreatment property.
     * 
     * @return
     *     possible object is
     *     {@link MissingValueTreatmentMethod }
     *     
     */
    public MissingValueTreatmentMethod getMissingValueTreatment() {
        return missingValueTreatment;
    }

    /**
     * Sets the value of the missingValueTreatment property.
     * 
     * @param missingValueTreatment
     *     allowed object is
     *     {@link MissingValueTreatmentMethod }
     *     
     */
    public MiningField setMissingValueTreatment(MissingValueTreatmentMethod missingValueTreatment) {
        this.missingValueTreatment = missingValueTreatment;
        return this;
    }

    /**
     * Gets the value of the invalidValueTreatment property.
     * 
     * @return
     *     possible object is
     *     {@link InvalidValueTreatmentMethod }
     *     
     */
    public InvalidValueTreatmentMethod getInvalidValueTreatment() {
        if (invalidValueTreatment == null) {
            return InvalidValueTreatmentMethod.RETURN_INVALID;
        } else {
            return invalidValueTreatment;
        }
    }

    /**
     * Sets the value of the invalidValueTreatment property.
     * 
     * @param invalidValueTreatment
     *     allowed object is
     *     {@link InvalidValueTreatmentMethod }
     *     
     */
    public MiningField setInvalidValueTreatment(InvalidValueTreatmentMethod invalidValueTreatment) {
        this.invalidValueTreatment = invalidValueTreatment;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public org.dmg.pmml.FieldName getKey() {
        return getName();
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public MiningField addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="active"/>
     *     &lt;enumeration value="predicted"/>
     *     &lt;enumeration value="target"/>
     *     &lt;enumeration value="supplementary"/>
     *     &lt;enumeration value="group"/>
     *     &lt;enumeration value="order"/>
     *     &lt;enumeration value="frequencyWeight"/>
     *     &lt;enumeration value="analysisWeight"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum UsageType {

        @XmlEnumValue("active")
        ACTIVE("active"),
        @XmlEnumValue("predicted")
        @Deprecated(Version.PMML_4_2)
        PREDICTED("predicted"),
        @XmlEnumValue("target")
        @Added(Version.PMML_4_2)
        TARGET("target"),
        @XmlEnumValue("supplementary")
        SUPPLEMENTARY("supplementary"),
        @XmlEnumValue("group")
        GROUP("group"),
        @XmlEnumValue("order")
        ORDER("order"),
        @XmlEnumValue("frequencyWeight")
        @Added(Version.PMML_4_0)
        FREQUENCY_WEIGHT("frequencyWeight"),
        @XmlEnumValue("analysisWeight")
        @Added(Version.PMML_4_0)
        ANALYSIS_WEIGHT("analysisWeight");
        private final String value;

        UsageType(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static MiningField.UsageType fromValue(String v) {
            for (MiningField.UsageType c: MiningField.UsageType.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
