
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="field" use="required" type="{http://www.dmg.org/PMML-4_3}FIELD-NAME" />
 *       &lt;attribute name="operator" use="required">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="equal"/>
 *             &lt;enumeration value="notEqual"/>
 *             &lt;enumeration value="lessThan"/>
 *             &lt;enumeration value="lessOrEqual"/>
 *             &lt;enumeration value="greaterThan"/>
 *             &lt;enumeration value="greaterOrEqual"/>
 *             &lt;enumeration value="isMissing"/>
 *             &lt;enumeration value="isNotMissing"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="value" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "SimplePredicate", namespace = "http://www.dmg.org/PMML-4_3")
public class SimplePredicate
    extends Predicate
    implements HasExtensions<SimplePredicate> , HasValue<SimplePredicate>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName field;
    @XmlAttribute(name = "operator", required = true)
    private SimplePredicate.Operator operator;
    @XmlAttribute(name = "value")
    private String value;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;

    public SimplePredicate() {
        super();
    }

    public SimplePredicate(final FieldName field, final SimplePredicate.Operator operator) {
        super();
        this.field = field;
        this.operator = operator;
    }

    /**
     * Gets the value of the field property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getField() {
        return field;
    }

    /**
     * Sets the value of the field property.
     * 
     * @param field
     *     allowed object is
     *     {@link String }
     *     
     */
    public SimplePredicate setField(FieldName field) {
        this.field = field;
        return this;
    }

    /**
     * Gets the value of the operator property.
     * 
     * @return
     *     possible object is
     *     {@link SimplePredicate.Operator }
     *     
     */
    public SimplePredicate.Operator getOperator() {
        return operator;
    }

    /**
     * Sets the value of the operator property.
     * 
     * @param operator
     *     allowed object is
     *     {@link SimplePredicate.Operator }
     *     
     */
    public SimplePredicate setOperator(SimplePredicate.Operator operator) {
        this.operator = operator;
        return this;
    }

    /**
     * Gets the value of the value property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public SimplePredicate setValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public SimplePredicate addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="equal"/>
     *     &lt;enumeration value="notEqual"/>
     *     &lt;enumeration value="lessThan"/>
     *     &lt;enumeration value="lessOrEqual"/>
     *     &lt;enumeration value="greaterThan"/>
     *     &lt;enumeration value="greaterOrEqual"/>
     *     &lt;enumeration value="isMissing"/>
     *     &lt;enumeration value="isNotMissing"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum Operator {

        @XmlEnumValue("equal")
        EQUAL("equal"),
        @XmlEnumValue("notEqual")
        NOT_EQUAL("notEqual"),
        @XmlEnumValue("lessThan")
        LESS_THAN("lessThan"),
        @XmlEnumValue("lessOrEqual")
        LESS_OR_EQUAL("lessOrEqual"),
        @XmlEnumValue("greaterThan")
        GREATER_THAN("greaterThan"),
        @XmlEnumValue("greaterOrEqual")
        GREATER_OR_EQUAL("greaterOrEqual"),
        @XmlEnumValue("isMissing")
        IS_MISSING("isMissing"),
        @XmlEnumValue("isNotMissing")
        IS_NOT_MISSING("isNotMissing");
        private final String value;

        Operator(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static SimplePredicate.Operator fromValue(String v) {
            for (SimplePredicate.Operator c: SimplePredicate.Operator.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
