
package org.dmg.pmml.baseline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Baseline"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Alternate" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="field" use="required" type="{http://www.dmg.org/PMML-4_3}FIELD-NAME" />
 *       &lt;attribute name="testStatistic" use="required">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="zValue"/>
 *             &lt;enumeration value="chiSquareIndependence"/>
 *             &lt;enumeration value="chiSquareDistribution"/>
 *             &lt;enumeration value="CUSUM"/>
 *             &lt;enumeration value="scalarProduct"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="resetValue" type="{http://www.dmg.org/PMML-4_3}REAL-NUMBER" default="0.0" />
 *       &lt;attribute name="windowSize" type="{http://www.dmg.org/PMML-4_3}INT-NUMBER" default="0" />
 *       &lt;attribute name="weightField" type="{http://www.dmg.org/PMML-4_3}FIELD-NAME" />
 *       &lt;attribute name="normalizationScheme" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "baseline",
    "alternate"
})
@XmlRootElement(name = "TestDistributions", namespace = "http://www.dmg.org/PMML-4_3")
@Added(Version.PMML_4_1)
public class TestDistributions
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<TestDistributions>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName field;
    @XmlAttribute(name = "testStatistic", required = true)
    private TestDistributions.TestStatistic testStatistic;
    @XmlAttribute(name = "resetValue")
    private Double resetValue;
    @XmlAttribute(name = "windowSize")
    private Integer windowSize;
    @XmlAttribute(name = "weightField")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName weightField;
    @XmlAttribute(name = "normalizationScheme")
    private String normalizationScheme;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "Baseline", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private Baseline baseline;
    @XmlElement(name = "Alternate", namespace = "http://www.dmg.org/PMML-4_3")
    private Alternate alternate;
    private final static Double DEFAULT_RESET_VALUE = 0.0D;
    private final static Integer DEFAULT_WINDOW_SIZE = 0;

    public TestDistributions() {
        super();
    }

    public TestDistributions(final FieldName field, final TestDistributions.TestStatistic testStatistic, final Baseline baseline) {
        super();
        this.field = field;
        this.testStatistic = testStatistic;
        this.baseline = baseline;
    }

    /**
     * Gets the value of the field property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getField() {
        return field;
    }

    /**
     * Sets the value of the field property.
     * 
     * @param field
     *     allowed object is
     *     {@link String }
     *     
     */
    public TestDistributions setField(FieldName field) {
        this.field = field;
        return this;
    }

    /**
     * Gets the value of the testStatistic property.
     * 
     * @return
     *     possible object is
     *     {@link TestDistributions.TestStatistic }
     *     
     */
    public TestDistributions.TestStatistic getTestStatistic() {
        return testStatistic;
    }

    /**
     * Sets the value of the testStatistic property.
     * 
     * @param testStatistic
     *     allowed object is
     *     {@link TestDistributions.TestStatistic }
     *     
     */
    public TestDistributions setTestStatistic(TestDistributions.TestStatistic testStatistic) {
        this.testStatistic = testStatistic;
        return this;
    }

    /**
     * Gets the value of the resetValue property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getResetValue() {
        if (resetValue == null) {
            return DEFAULT_RESET_VALUE;
        } else {
            return resetValue;
        }
    }

    /**
     * Sets the value of the resetValue property.
     * 
     * @param resetValue
     *     allowed object is
     *     {@link Double }
     *     
     */
    public TestDistributions setResetValue(Double resetValue) {
        this.resetValue = resetValue;
        return this;
    }

    /**
     * Gets the value of the windowSize property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public Integer getWindowSize() {
        if (windowSize == null) {
            return DEFAULT_WINDOW_SIZE;
        } else {
            return windowSize;
        }
    }

    /**
     * Sets the value of the windowSize property.
     * 
     * @param windowSize
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public TestDistributions setWindowSize(Integer windowSize) {
        this.windowSize = windowSize;
        return this;
    }

    /**
     * Gets the value of the weightField property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getWeightField() {
        return weightField;
    }

    /**
     * Sets the value of the weightField property.
     * 
     * @param weightField
     *     allowed object is
     *     {@link String }
     *     
     */
    public TestDistributions setWeightField(FieldName weightField) {
        this.weightField = weightField;
        return this;
    }

    /**
     * Gets the value of the normalizationScheme property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getNormalizationScheme() {
        return normalizationScheme;
    }

    /**
     * Sets the value of the normalizationScheme property.
     * 
     * @param normalizationScheme
     *     allowed object is
     *     {@link String }
     *     
     */
    public TestDistributions setNormalizationScheme(String normalizationScheme) {
        this.normalizationScheme = normalizationScheme;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the baseline property.
     * 
     * @return
     *     possible object is
     *     {@link Baseline }
     *     
     */
    public Baseline getBaseline() {
        return baseline;
    }

    /**
     * Sets the value of the baseline property.
     * 
     * @param baseline
     *     allowed object is
     *     {@link Baseline }
     *     
     */
    public TestDistributions setBaseline(Baseline baseline) {
        this.baseline = baseline;
        return this;
    }

    /**
     * Gets the value of the alternate property.
     * 
     * @return
     *     possible object is
     *     {@link Alternate }
     *     
     */
    public Alternate getAlternate() {
        return alternate;
    }

    /**
     * Sets the value of the alternate property.
     * 
     * @param alternate
     *     allowed object is
     *     {@link Alternate }
     *     
     */
    public TestDistributions setAlternate(Alternate alternate) {
        this.alternate = alternate;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public TestDistributions addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getBaseline(), getAlternate());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="zValue"/>
     *     &lt;enumeration value="chiSquareIndependence"/>
     *     &lt;enumeration value="chiSquareDistribution"/>
     *     &lt;enumeration value="CUSUM"/>
     *     &lt;enumeration value="scalarProduct"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    @Added(Version.PMML_4_1)
    public enum TestStatistic {

        @XmlEnumValue("zValue")
        Z_VALUE("zValue"),
        @XmlEnumValue("chiSquareIndependence")
        CHI_SQUARE_INDEPENDENCE("chiSquareIndependence"),
        @XmlEnumValue("chiSquareDistribution")
        CHI_SQUARE_DISTRIBUTION("chiSquareDistribution"),
        CUSUM("CUSUM"),
        @XmlEnumValue("scalarProduct")
        SCALAR_PRODUCT("scalarProduct");
        private final String value;

        TestStatistic(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static TestDistributions.TestStatistic fromValue(String v) {
            for (TestDistributions.TestStatistic c: TestDistributions.TestStatistic.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
