
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}ClassLabels"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Matrix"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "classLabels",
    "matrix"
})
@XmlRootElement(name = "ConfusionMatrix", namespace = "http://www.dmg.org/PMML-4_3")
@Added(Version.PMML_4_0)
public class ConfusionMatrix
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<ConfusionMatrix>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "ClassLabels", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private ClassLabels classLabels;
    @XmlElement(name = "Matrix", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private Matrix matrix;

    public ConfusionMatrix() {
        super();
    }

    public ConfusionMatrix(final ClassLabels classLabels, final Matrix matrix) {
        super();
        this.classLabels = classLabels;
        this.matrix = matrix;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the classLabels property.
     * 
     * @return
     *     possible object is
     *     {@link ClassLabels }
     *     
     */
    public ClassLabels getClassLabels() {
        return classLabels;
    }

    /**
     * Sets the value of the classLabels property.
     * 
     * @param classLabels
     *     allowed object is
     *     {@link ClassLabels }
     *     
     */
    public ConfusionMatrix setClassLabels(ClassLabels classLabels) {
        this.classLabels = classLabels;
        return this;
    }

    /**
     * Gets the value of the matrix property.
     * 
     * @return
     *     possible object is
     *     {@link Matrix }
     *     
     */
    public Matrix getMatrix() {
        return matrix;
    }

    /**
     * Sets the value of the matrix property.
     * 
     * @param matrix
     *     allowed object is
     *     {@link Matrix }
     *     
     */
    public ConfusionMatrix setMatrix(Matrix matrix) {
        this.matrix = matrix;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public ConfusionMatrix addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getClassLabels(), getMatrix());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
