
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="closure" use="required">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="openClosed"/>
 *             &lt;enumeration value="openOpen"/>
 *             &lt;enumeration value="closedOpen"/>
 *             &lt;enumeration value="closedClosed"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="leftMargin" type="{http://www.dmg.org/PMML-4_3}NUMBER" />
 *       &lt;attribute name="rightMargin" type="{http://www.dmg.org/PMML-4_3}NUMBER" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "Interval", namespace = "http://www.dmg.org/PMML-4_3")
public class Interval
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Interval>
{

    @XmlAttribute(name = "closure", required = true)
    private Interval.Closure closure;
    @XmlAttribute(name = "leftMargin")
    private Double leftMargin;
    @XmlAttribute(name = "rightMargin")
    private Double rightMargin;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;

    public Interval() {
        super();
    }

    public Interval(final Interval.Closure closure) {
        super();
        this.closure = closure;
    }

    /**
     * Gets the value of the closure property.
     * 
     * @return
     *     possible object is
     *     {@link Interval.Closure }
     *     
     */
    public Interval.Closure getClosure() {
        return closure;
    }

    /**
     * Sets the value of the closure property.
     * 
     * @param closure
     *     allowed object is
     *     {@link Interval.Closure }
     *     
     */
    public Interval setClosure(Interval.Closure closure) {
        this.closure = closure;
        return this;
    }

    /**
     * Gets the value of the leftMargin property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getLeftMargin() {
        return leftMargin;
    }

    /**
     * Sets the value of the leftMargin property.
     * 
     * @param leftMargin
     *     allowed object is
     *     {@link Double }
     *     
     */
    public Interval setLeftMargin(Double leftMargin) {
        this.leftMargin = leftMargin;
        return this;
    }

    /**
     * Gets the value of the rightMargin property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getRightMargin() {
        return rightMargin;
    }

    /**
     * Sets the value of the rightMargin property.
     * 
     * @param rightMargin
     *     allowed object is
     *     {@link Double }
     *     
     */
    public Interval setRightMargin(Double rightMargin) {
        this.rightMargin = rightMargin;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Interval addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="openClosed"/>
     *     &lt;enumeration value="openOpen"/>
     *     &lt;enumeration value="closedOpen"/>
     *     &lt;enumeration value="closedClosed"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum Closure {

        @XmlEnumValue("openClosed")
        OPEN_CLOSED("openClosed"),
        @XmlEnumValue("openOpen")
        OPEN_OPEN("openOpen"),
        @XmlEnumValue("closedOpen")
        CLOSED_OPEN("closedOpen"),
        @XmlEnumValue("closedClosed")
        CLOSED_CLOSED("closedClosed");
        private final String value;

        Closure(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static Interval.Closure fromValue(String v) {
            for (Interval.Closure c: Interval.Closure.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
