
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.schema.Added;
import org.jpmml.schema.Optional;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}FieldColumnPair" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;choice minOccurs="0">
 *           &lt;element ref="{http://www.dmg.org/PMML-4_3}TableLocator"/>
 *           &lt;element ref="{http://www.dmg.org/PMML-4_3}InlineTable"/>
 *         &lt;/choice>
 *       &lt;/sequence>
 *       &lt;attribute name="mapMissingTo" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="defaultValue" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="outputColumn" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="dataType" type="{http://www.dmg.org/PMML-4_3}DATATYPE" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "fieldColumnPairs",
    "tableLocator",
    "inlineTable"
})
@XmlRootElement(name = "MapValues", namespace = "http://www.dmg.org/PMML-4_3")
public class MapValues
    extends Expression
    implements HasDefaultValue<MapValues> , HasExtensions<MapValues> , HasMapMissingTo<MapValues, String> , HasTable<MapValues>
{

    @XmlAttribute(name = "mapMissingTo")
    private String mapMissingTo;
    @XmlAttribute(name = "defaultValue")
    private String defaultValue;
    @XmlAttribute(name = "outputColumn", required = true)
    private String outputColumn;
    @XmlAttribute(name = "dataType")
    @Added(Version.PMML_3_1)
    private DataType dataType;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "FieldColumnPair", namespace = "http://www.dmg.org/PMML-4_3")
    @Optional(Version.PMML_4_2)
    private List<FieldColumnPair> fieldColumnPairs;
    @XmlElement(name = "TableLocator", namespace = "http://www.dmg.org/PMML-4_3")
    private TableLocator tableLocator;
    @XmlElement(name = "InlineTable", namespace = "http://www.dmg.org/PMML-4_3")
    private InlineTable inlineTable;

    public MapValues() {
        super();
    }

    public MapValues(final String outputColumn) {
        super();
        this.outputColumn = outputColumn;
    }

    /**
     * Gets the value of the mapMissingTo property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getMapMissingTo() {
        return mapMissingTo;
    }

    /**
     * Sets the value of the mapMissingTo property.
     * 
     * @param mapMissingTo
     *     allowed object is
     *     {@link String }
     *     
     */
    public MapValues setMapMissingTo(String mapMissingTo) {
        this.mapMissingTo = mapMissingTo;
        return this;
    }

    /**
     * Gets the value of the defaultValue property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDefaultValue() {
        return defaultValue;
    }

    /**
     * Sets the value of the defaultValue property.
     * 
     * @param defaultValue
     *     allowed object is
     *     {@link String }
     *     
     */
    public MapValues setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    /**
     * Gets the value of the outputColumn property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getOutputColumn() {
        return outputColumn;
    }

    /**
     * Sets the value of the outputColumn property.
     * 
     * @param outputColumn
     *     allowed object is
     *     {@link String }
     *     
     */
    public MapValues setOutputColumn(String outputColumn) {
        this.outputColumn = outputColumn;
        return this;
    }

    /**
     * Gets the value of the dataType property.
     * 
     * @return
     *     possible object is
     *     {@link DataType }
     *     
     */
    public DataType getDataType() {
        return dataType;
    }

    /**
     * Sets the value of the dataType property.
     * 
     * @param dataType
     *     allowed object is
     *     {@link DataType }
     *     
     */
    public MapValues setDataType(DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the fieldColumnPairs property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the fieldColumnPairs property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getFieldColumnPairs().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FieldColumnPair }
     * 
     * 
     */
    public List<FieldColumnPair> getFieldColumnPairs() {
        if (fieldColumnPairs == null) {
            fieldColumnPairs = new ArrayList<FieldColumnPair>();
        }
        return this.fieldColumnPairs;
    }

    /**
     * Gets the value of the tableLocator property.
     * 
     * @return
     *     possible object is
     *     {@link TableLocator }
     *     
     */
    public TableLocator getTableLocator() {
        return tableLocator;
    }

    /**
     * Sets the value of the tableLocator property.
     * 
     * @param tableLocator
     *     allowed object is
     *     {@link TableLocator }
     *     
     */
    public MapValues setTableLocator(TableLocator tableLocator) {
        this.tableLocator = tableLocator;
        return this;
    }

    /**
     * Gets the value of the inlineTable property.
     * 
     * @return
     *     possible object is
     *     {@link InlineTable }
     *     
     */
    public InlineTable getInlineTable() {
        return inlineTable;
    }

    /**
     * Sets the value of the inlineTable property.
     * 
     * @param inlineTable
     *     allowed object is
     *     {@link InlineTable }
     *     
     */
    public MapValues setInlineTable(InlineTable inlineTable) {
        this.inlineTable = inlineTable;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public MapValues addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasFieldColumnPairs() {
        return ((this.fieldColumnPairs!= null)&&(this.fieldColumnPairs.size()> 0));
    }

    public MapValues addFieldColumnPairs(FieldColumnPair... fieldColumnPairs) {
        getFieldColumnPairs().addAll(Arrays.asList(fieldColumnPairs));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasFieldColumnPairs()) {
                status = PMMLObject.traverse(visitor, getFieldColumnPairs());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getTableLocator(), getInlineTable());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
