
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}LinearNorm" maxOccurs="unbounded" minOccurs="2"/>
 *       &lt;/sequence>
 *       &lt;attribute name="mapMissingTo" type="{http://www.dmg.org/PMML-4_3}NUMBER" />
 *       &lt;attribute name="field" use="required" type="{http://www.dmg.org/PMML-4_3}FIELD-NAME" />
 *       &lt;attribute name="outliers" type="{http://www.dmg.org/PMML-4_3}OUTLIER-TREATMENT-METHOD" default="asIs" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "linearNorms"
})
@XmlRootElement(name = "NormContinuous", namespace = "http://www.dmg.org/PMML-4_3")
public class NormContinuous
    extends Expression
    implements HasExtensions<NormContinuous> , HasMapMissingTo<NormContinuous, Double>
{

    @XmlAttribute(name = "mapMissingTo")
    @Added(Version.PMML_3_2)
    private Double mapMissingTo;
    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName field;
    @XmlAttribute(name = "outliers")
    @Added(Version.PMML_3_2)
    private OutlierTreatmentMethod outliers;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "LinearNorm", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private List<LinearNorm> linearNorms;

    public NormContinuous() {
        super();
    }

    public NormContinuous(final FieldName field, final List<LinearNorm> linearNorms) {
        super();
        this.field = field;
        this.linearNorms = linearNorms;
    }

    /**
     * Gets the value of the mapMissingTo property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getMapMissingTo() {
        return mapMissingTo;
    }

    /**
     * Sets the value of the mapMissingTo property.
     * 
     * @param mapMissingTo
     *     allowed object is
     *     {@link Double }
     *     
     */
    public NormContinuous setMapMissingTo(Double mapMissingTo) {
        this.mapMissingTo = mapMissingTo;
        return this;
    }

    /**
     * Gets the value of the field property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getField() {
        return field;
    }

    /**
     * Sets the value of the field property.
     * 
     * @param field
     *     allowed object is
     *     {@link String }
     *     
     */
    public NormContinuous setField(FieldName field) {
        this.field = field;
        return this;
    }

    /**
     * Gets the value of the outliers property.
     * 
     * @return
     *     possible object is
     *     {@link OutlierTreatmentMethod }
     *     
     */
    public OutlierTreatmentMethod getOutliers() {
        if (outliers == null) {
            return OutlierTreatmentMethod.AS_IS;
        } else {
            return outliers;
        }
    }

    /**
     * Sets the value of the outliers property.
     * 
     * @param outliers
     *     allowed object is
     *     {@link OutlierTreatmentMethod }
     *     
     */
    public NormContinuous setOutliers(OutlierTreatmentMethod outliers) {
        this.outliers = outliers;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the linearNorms property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the linearNorms property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getLinearNorms().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LinearNorm }
     * 
     * 
     */
    public List<LinearNorm> getLinearNorms() {
        if (linearNorms == null) {
            linearNorms = new ArrayList<LinearNorm>();
        }
        return this.linearNorms;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public NormContinuous addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasLinearNorms() {
        return ((this.linearNorms!= null)&&(this.linearNorms.size()> 0));
    }

    public NormContinuous addLinearNorms(LinearNorm... linearNorms) {
        getLinearNorms().addAll(Arrays.asList(linearNorms));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasLinearNorms()) {
                status = PMMLObject.traverse(visitor, getLinearNorms());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
