
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Optional;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}TargetValue" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="field" type="{http://www.dmg.org/PMML-4_3}FIELD-NAME" />
 *       &lt;attribute name="optype" type="{http://www.dmg.org/PMML-4_3}OPTYPE" />
 *       &lt;attribute name="castInteger">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="round"/>
 *             &lt;enumeration value="ceiling"/>
 *             &lt;enumeration value="floor"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="min" type="{http://www.dmg.org/PMML-4_3}NUMBER" />
 *       &lt;attribute name="max" type="{http://www.dmg.org/PMML-4_3}NUMBER" />
 *       &lt;attribute name="rescaleConstant" type="{http://www.dmg.org/PMML-4_3}NUMBER" default="0" />
 *       &lt;attribute name="rescaleFactor" type="{http://www.dmg.org/PMML-4_3}NUMBER" default="1" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "targetValues"
})
@XmlRootElement(name = "Target", namespace = "http://www.dmg.org/PMML-4_3")
public class Target
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Target> , Indexable<org.dmg.pmml.FieldName>
{

    @XmlAttribute(name = "field")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @Optional(Version.PMML_4_3)
    private org.dmg.pmml.FieldName field;
    @XmlAttribute(name = "optype")
    private OpType opType;
    @XmlAttribute(name = "castInteger")
    private Target.CastInteger castInteger;
    @XmlAttribute(name = "min")
    @Added(Version.PMML_3_1)
    private Double min;
    @XmlAttribute(name = "max")
    @Added(Version.PMML_3_1)
    private Double max;
    @XmlAttribute(name = "rescaleConstant")
    @Added(Version.PMML_3_1)
    private Double rescaleConstant;
    @XmlAttribute(name = "rescaleFactor")
    @Added(Version.PMML_3_1)
    private Double rescaleFactor;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "TargetValue", namespace = "http://www.dmg.org/PMML-4_3")
    @Optional(Version.PMML_3_1)
    private List<TargetValue> targetValues;
    private final static Double DEFAULT_RESCALE_CONSTANT = 0.0D;
    private final static Double DEFAULT_RESCALE_FACTOR = 1.0D;

    /**
     * Gets the value of the field property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public org.dmg.pmml.FieldName getField() {
        return field;
    }

    /**
     * Sets the value of the field property.
     * 
     * @param field
     *     allowed object is
     *     {@link String }
     *     
     */
    public Target setField(org.dmg.pmml.FieldName field) {
        this.field = field;
        return this;
    }

    /**
     * Gets the value of the opType property.
     * 
     * @return
     *     possible object is
     *     {@link OpType }
     *     
     */
    public OpType getOpType() {
        return opType;
    }

    /**
     * Sets the value of the opType property.
     * 
     * @param opType
     *     allowed object is
     *     {@link OpType }
     *     
     */
    public Target setOpType(OpType opType) {
        this.opType = opType;
        return this;
    }

    /**
     * Gets the value of the castInteger property.
     * 
     * @return
     *     possible object is
     *     {@link Target.CastInteger }
     *     
     */
    public Target.CastInteger getCastInteger() {
        return castInteger;
    }

    /**
     * Sets the value of the castInteger property.
     * 
     * @param castInteger
     *     allowed object is
     *     {@link Target.CastInteger }
     *     
     */
    public Target setCastInteger(Target.CastInteger castInteger) {
        this.castInteger = castInteger;
        return this;
    }

    /**
     * Gets the value of the min property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getMin() {
        return min;
    }

    /**
     * Sets the value of the min property.
     * 
     * @param min
     *     allowed object is
     *     {@link Double }
     *     
     */
    public Target setMin(Double min) {
        this.min = min;
        return this;
    }

    /**
     * Gets the value of the max property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getMax() {
        return max;
    }

    /**
     * Sets the value of the max property.
     * 
     * @param max
     *     allowed object is
     *     {@link Double }
     *     
     */
    public Target setMax(Double max) {
        this.max = max;
        return this;
    }

    /**
     * Gets the value of the rescaleConstant property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getRescaleConstant() {
        if (rescaleConstant == null) {
            return DEFAULT_RESCALE_CONSTANT;
        } else {
            return rescaleConstant;
        }
    }

    /**
     * Sets the value of the rescaleConstant property.
     * 
     * @param rescaleConstant
     *     allowed object is
     *     {@link Double }
     *     
     */
    public Target setRescaleConstant(Double rescaleConstant) {
        this.rescaleConstant = rescaleConstant;
        return this;
    }

    /**
     * Gets the value of the rescaleFactor property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getRescaleFactor() {
        if (rescaleFactor == null) {
            return DEFAULT_RESCALE_FACTOR;
        } else {
            return rescaleFactor;
        }
    }

    /**
     * Sets the value of the rescaleFactor property.
     * 
     * @param rescaleFactor
     *     allowed object is
     *     {@link Double }
     *     
     */
    public Target setRescaleFactor(Double rescaleFactor) {
        this.rescaleFactor = rescaleFactor;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the targetValues property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the targetValues property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTargetValues().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TargetValue }
     * 
     * 
     */
    public List<TargetValue> getTargetValues() {
        if (targetValues == null) {
            targetValues = new ArrayList<TargetValue>();
        }
        return this.targetValues;
    }

    @Override
    public org.dmg.pmml.FieldName getKey() {
        return getField();
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Target addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasTargetValues() {
        return ((this.targetValues!= null)&&(this.targetValues.size()> 0));
    }

    public Target addTargetValues(TargetValue... targetValues) {
        getTargetValues().addAll(Arrays.asList(targetValues));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasTargetValues()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTargetValues());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="round"/>
     *     &lt;enumeration value="ceiling"/>
     *     &lt;enumeration value="floor"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum CastInteger {

        @XmlEnumValue("round")
        ROUND("round"),
        @XmlEnumValue("ceiling")
        CEILING("ceiling"),
        @XmlEnumValue("floor")
        FLOOR("floor");
        private final String value;

        CastInteger(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static Target.CastInteger fromValue(String v) {
            for (Target.CastInteger c: Target.CastInteger.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
