
package org.dmg.pmml.bayesian_network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}ParentValue" maxOccurs="unbounded"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}ValueProbability" maxOccurs="unbounded"/>
 *       &lt;/sequence>
 *       &lt;attribute name="count" type="{http://www.dmg.org/PMML-4_3}REAL-NUMBER" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "parentValues",
    "valueProbabilities"
})
@XmlRootElement(name = "DiscreteConditionalProbability", namespace = "http://www.dmg.org/PMML-4_3")
@Added(Version.PMML_4_3)
public class DiscreteConditionalProbability
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<DiscreteConditionalProbability>
{

    @XmlAttribute(name = "count")
    private Double count;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "ParentValue", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private List<ParentValue> parentValues;
    @XmlElement(name = "ValueProbability", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private List<ValueProbability> valueProbabilities;

    public DiscreteConditionalProbability() {
        super();
    }

    public DiscreteConditionalProbability(final List<ParentValue> parentValues, final List<ValueProbability> valueProbabilities) {
        super();
        this.parentValues = parentValues;
        this.valueProbabilities = valueProbabilities;
    }

    /**
     * Gets the value of the count property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getCount() {
        return count;
    }

    /**
     * Sets the value of the count property.
     * 
     * @param count
     *     allowed object is
     *     {@link Double }
     *     
     */
    public DiscreteConditionalProbability setCount(Double count) {
        this.count = count;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the parentValues property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the parentValues property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getParentValues().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ParentValue }
     * 
     * 
     */
    public List<ParentValue> getParentValues() {
        if (parentValues == null) {
            parentValues = new ArrayList<ParentValue>();
        }
        return this.parentValues;
    }

    /**
     * Gets the value of the valueProbabilities property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the valueProbabilities property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getValueProbabilities().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ValueProbability }
     * 
     * 
     */
    public List<ValueProbability> getValueProbabilities() {
        if (valueProbabilities == null) {
            valueProbabilities = new ArrayList<ValueProbability>();
        }
        return this.valueProbabilities;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public DiscreteConditionalProbability addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasParentValues() {
        return ((this.parentValues!= null)&&(this.parentValues.size()> 0));
    }

    public DiscreteConditionalProbability addParentValues(ParentValue... parentValues) {
        getParentValues().addAll(Arrays.asList(parentValues));
        return this;
    }

    public boolean hasValueProbabilities() {
        return ((this.valueProbabilities!= null)&&(this.valueProbabilities.size()> 0));
    }

    public DiscreteConditionalProbability addValueProbabilities(ValueProbability... valueProbabilities) {
        getValueProbabilities().addAll(Arrays.asList(valueProbabilities));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasParentValues()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getParentValues());
            }
            if ((status == VisitorAction.CONTINUE)&&hasValueProbabilities()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getValueProbabilities());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
