
package org.dmg.pmml.naive_bayes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;choice>
 *           &lt;element ref="{http://www.dmg.org/PMML-4_3}TargetValueStats"/>
 *           &lt;sequence>
 *             &lt;element ref="{http://www.dmg.org/PMML-4_3}DerivedField" minOccurs="0"/>
 *             &lt;element ref="{http://www.dmg.org/PMML-4_3}PairCounts" maxOccurs="unbounded"/>
 *           &lt;/sequence>
 *         &lt;/choice>
 *       &lt;/sequence>
 *       &lt;attribute name="fieldName" use="required" type="{http://www.dmg.org/PMML-4_3}FIELD-NAME" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "targetValueStats",
    "derivedField",
    "pairCounts"
})
@XmlRootElement(name = "BayesInput", namespace = "http://www.dmg.org/PMML-4_3")
public class BayesInput
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<BayesInput>
{

    @XmlAttribute(name = "fieldName", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName fieldName;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "TargetValueStats", namespace = "http://www.dmg.org/PMML-4_3")
    @Added(Version.PMML_4_2)
    private TargetValueStats targetValueStats;
    @XmlElement(name = "DerivedField", namespace = "http://www.dmg.org/PMML-4_3")
    private DerivedField derivedField;
    @XmlElement(name = "PairCounts", namespace = "http://www.dmg.org/PMML-4_3")
    private List<PairCounts> pairCounts;

    public BayesInput() {
        super();
    }

    public BayesInput(final FieldName fieldName) {
        super();
        this.fieldName = fieldName;
    }

    /**
     * Gets the value of the fieldName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getFieldName() {
        return fieldName;
    }

    /**
     * Sets the value of the fieldName property.
     * 
     * @param fieldName
     *     allowed object is
     *     {@link String }
     *     
     */
    public BayesInput setFieldName(FieldName fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the targetValueStats property.
     * 
     * @return
     *     possible object is
     *     {@link TargetValueStats }
     *     
     */
    public TargetValueStats getTargetValueStats() {
        return targetValueStats;
    }

    /**
     * Sets the value of the targetValueStats property.
     * 
     * @param targetValueStats
     *     allowed object is
     *     {@link TargetValueStats }
     *     
     */
    public BayesInput setTargetValueStats(TargetValueStats targetValueStats) {
        this.targetValueStats = targetValueStats;
        return this;
    }

    /**
     * Gets the value of the derivedField property.
     * 
     * @return
     *     possible object is
     *     {@link DerivedField }
     *     
     */
    public DerivedField getDerivedField() {
        return derivedField;
    }

    /**
     * Sets the value of the derivedField property.
     * 
     * @param derivedField
     *     allowed object is
     *     {@link DerivedField }
     *     
     */
    public BayesInput setDerivedField(DerivedField derivedField) {
        this.derivedField = derivedField;
        return this;
    }

    /**
     * Gets the value of the pairCounts property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the pairCounts property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPairCounts().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PairCounts }
     * 
     * 
     */
    public List<PairCounts> getPairCounts() {
        if (pairCounts == null) {
            pairCounts = new ArrayList<PairCounts>();
        }
        return this.pairCounts;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public BayesInput addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasPairCounts() {
        return ((this.pairCounts!= null)&&(this.pairCounts.size()> 0));
    }

    public BayesInput addPairCounts(PairCounts... pairCounts) {
        getPairCounts().addAll(Arrays.asList(pairCounts));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTargetValueStats(), getDerivedField());
            }
            if ((status == VisitorAction.CONTINUE)&&hasPairCounts()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getPairCounts());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
