
package org.dmg.pmml.sequence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasId;
import org.dmg.pmml.Indexable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}SetReference"/>
 *         &lt;sequence maxOccurs="unbounded" minOccurs="0">
 *           &lt;group ref="{http://www.dmg.org/PMML-4_3}FOLLOW-SET"/>
 *         &lt;/sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Time" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="id" use="required" type="{http://www.dmg.org/PMML-4_3}ELEMENT-ID" />
 *       &lt;attribute name="numberOfSets" type="{http://www.dmg.org/PMML-4_3}INT-NUMBER" />
 *       &lt;attribute name="occurrence" type="{http://www.dmg.org/PMML-4_3}INT-NUMBER" />
 *       &lt;attribute name="support" type="{http://www.dmg.org/PMML-4_3}REAL-NUMBER" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "setReference",
    "content",
    "time"
})
@XmlRootElement(name = "Sequence", namespace = "http://www.dmg.org/PMML-4_3")
public class Sequence
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Sequence> , HasId<Sequence> , Indexable<String>
{

    @XmlAttribute(name = "id", required = true)
    private String id;
    @XmlAttribute(name = "numberOfSets")
    private Integer numberOfSets;
    @XmlAttribute(name = "occurrence")
    private Integer occurrence;
    @XmlAttribute(name = "support")
    private Double support;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "SetReference", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private SetReference setReference;
    @XmlElements({
        @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3", type = Extension.class),
        @XmlElement(name = "Delimiter", namespace = "http://www.dmg.org/PMML-4_3", type = Delimiter.class),
        @XmlElement(name = "Time", namespace = "http://www.dmg.org/PMML-4_3", type = Time.class),
        @XmlElement(name = "SetReference", namespace = "http://www.dmg.org/PMML-4_3", type = SetReference.class)
    })
    private List<org.dmg.pmml.PMMLObject> content;
    @XmlElement(name = "Time", namespace = "http://www.dmg.org/PMML-4_3")
    @Added(Version.PMML_3_1)
    private Time time;
    private final static long serialVersionUID = 67305473L;

    public Sequence() {
    }

    public Sequence(
        @org.jpmml.model.Property("id")
        String id,
        @org.jpmml.model.Property("setReference")
        SetReference setReference) {
        this.id = id;
        this.setReference = setReference;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param id
     *     allowed object is
     *     {@link String }
     *     
     */
    public Sequence setId(
        @org.jpmml.model.Property("id")
        String id) {
        this.id = id;
        return this;
    }

    /**
     * Gets the value of the numberOfSets property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public Integer getNumberOfSets() {
        return numberOfSets;
    }

    /**
     * Sets the value of the numberOfSets property.
     * 
     * @param numberOfSets
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public Sequence setNumberOfSets(
        @org.jpmml.model.Property("numberOfSets")
        Integer numberOfSets) {
        this.numberOfSets = numberOfSets;
        return this;
    }

    /**
     * Gets the value of the occurrence property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public Integer getOccurrence() {
        return occurrence;
    }

    /**
     * Sets the value of the occurrence property.
     * 
     * @param occurrence
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public Sequence setOccurrence(
        @org.jpmml.model.Property("occurrence")
        Integer occurrence) {
        this.occurrence = occurrence;
        return this;
    }

    /**
     * Gets the value of the support property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getSupport() {
        return support;
    }

    /**
     * Sets the value of the support property.
     * 
     * @param support
     *     allowed object is
     *     {@link Double }
     *     
     */
    public Sequence setSupport(
        @org.jpmml.model.Property("support")
        Double support) {
        this.support = support;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the setReference property.
     * 
     * @return
     *     possible object is
     *     {@link SetReference }
     *     
     */
    public SetReference getSetReference() {
        return setReference;
    }

    /**
     * Sets the value of the setReference property.
     * 
     * @param setReference
     *     allowed object is
     *     {@link SetReference }
     *     
     */
    public Sequence setSetReference(
        @org.jpmml.model.Property("setReference")
        SetReference setReference) {
        this.setReference = setReference;
        return this;
    }

    /**
     * Gets the value of the content property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the content property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getContent().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * {@link Delimiter }
     * {@link Time }
     * {@link SetReference }
     * 
     * 
     */
    public List<org.dmg.pmml.PMMLObject> getContent() {
        if (content == null) {
            content = new ArrayList<org.dmg.pmml.PMMLObject>();
        }
        return this.content;
    }

    /**
     * Gets the value of the time property.
     * 
     * @return
     *     possible object is
     *     {@link Time }
     *     
     */
    public Time getTime() {
        return time;
    }

    /**
     * Sets the value of the time property.
     * 
     * @param time
     *     allowed object is
     *     {@link Time }
     *     
     */
    public Sequence setTime(
        @org.jpmml.model.Property("time")
        Time time) {
        this.time = time;
        return this;
    }

    @Override
    public String getKey() {
        return getId();
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Sequence addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasContent() {
        return ((this.content!= null)&&(this.content.size()> 0));
    }

    public Sequence addContent(org.dmg.pmml.PMMLObject... content) {
        getContent().addAll(Arrays.asList(content));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getSetReference());
            }
            if ((status == VisitorAction.CONTINUE)&&hasContent()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getContent());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTime());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
