
package org.dmg.pmml.gaussian_process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.nearest_neighbor.TrainingInstances;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}MiningSchema"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Output" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}ModelStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}ModelExplanation" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Targets" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}LocalTransformations" minOccurs="0"/>
 *         &lt;sequence>
 *           &lt;choice>
 *             &lt;element ref="{http://www.dmg.org/PMML-4_3}RadialBasisKernel"/>
 *             &lt;element ref="{http://www.dmg.org/PMML-4_3}ARDSquaredExponentialKernel"/>
 *             &lt;element ref="{http://www.dmg.org/PMML-4_3}AbsoluteExponentialKernel"/>
 *             &lt;element ref="{http://www.dmg.org/PMML-4_3}GeneralizedExponentialKernel"/>
 *           &lt;/choice>
 *         &lt;/sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}TrainingInstances"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}ModelVerification" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="modelName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="functionName" use="required" type="{http://www.dmg.org/PMML-4_3}MINING-FUNCTION" />
 *       &lt;attribute name="algorithmName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="optimizer" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="isScorable" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       &lt;attribute name="x-mathContext" type="{http://www.dmg.org/PMML-4_3}MATH-CONTEXT" default="double" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "radialBasisKernel",
    "ardSquaredExponentialKernel",
    "absoluteExponentialKernel",
    "generalizedExponentialKernel",
    "trainingInstances",
    "modelVerification"
})
@XmlRootElement(name = "GaussianProcessModel", namespace = "http://www.dmg.org/PMML-4_3")
@Added(Version.PMML_4_3)
public class GaussianProcessModel
    extends Model
    implements HasExtensions<GaussianProcessModel>
{

    @XmlAttribute(name = "modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "optimizer")
    private String optimizer;
    @XmlAttribute(name = "isScorable")
    private Boolean scorable;
    @XmlAttribute(name = "x-mathContext")
    private MathContext mathContext;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_3")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_3")
    private ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_3")
    private ModelExplanation modelExplanation;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_3")
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_3")
    private LocalTransformations localTransformations;
    @XmlElement(name = "RadialBasisKernel", namespace = "http://www.dmg.org/PMML-4_3")
    private RadialBasisKernel radialBasisKernel;
    @XmlElement(name = "ARDSquaredExponentialKernel", namespace = "http://www.dmg.org/PMML-4_3")
    private ARDSquaredExponentialKernel ardSquaredExponentialKernel;
    @XmlElement(name = "AbsoluteExponentialKernel", namespace = "http://www.dmg.org/PMML-4_3")
    private AbsoluteExponentialKernel absoluteExponentialKernel;
    @XmlElement(name = "GeneralizedExponentialKernel", namespace = "http://www.dmg.org/PMML-4_3")
    private GeneralizedExponentialKernel generalizedExponentialKernel;
    @XmlElement(name = "TrainingInstances", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private TrainingInstances trainingInstances;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_3")
    private ModelVerification modelVerification;
    private final static Boolean DEFAULT_SCORABLE = true;
    private final static long serialVersionUID = 67305475L;

    public GaussianProcessModel() {
    }

    public GaussianProcessModel(
        @org.jpmml.model.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.Property("miningSchema")
        MiningSchema miningSchema,
        @org.jpmml.model.Property("trainingInstances")
        TrainingInstances trainingInstances) {
        this.miningFunction = miningFunction;
        this.miningSchema = miningSchema;
        this.trainingInstances = trainingInstances;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Sets the value of the modelName property.
     * 
     * @param modelName
     *     allowed object is
     *     {@link String }
     *     
     */
    public GaussianProcessModel setModelName(
        @org.jpmml.model.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    /**
     * Gets the value of the miningFunction property.
     * 
     * @return
     *     possible object is
     *     {@link MiningFunction }
     *     
     */
    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    /**
     * Sets the value of the miningFunction property.
     * 
     * @param miningFunction
     *     allowed object is
     *     {@link MiningFunction }
     *     
     */
    public GaussianProcessModel setMiningFunction(
        @org.jpmml.model.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    /**
     * Gets the value of the algorithmName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithmName() {
        return algorithmName;
    }

    /**
     * Sets the value of the algorithmName property.
     * 
     * @param algorithmName
     *     allowed object is
     *     {@link String }
     *     
     */
    public GaussianProcessModel setAlgorithmName(
        @org.jpmml.model.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    /**
     * Gets the value of the optimizer property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getOptimizer() {
        return optimizer;
    }

    /**
     * Sets the value of the optimizer property.
     * 
     * @param optimizer
     *     allowed object is
     *     {@link String }
     *     
     */
    public GaussianProcessModel setOptimizer(
        @org.jpmml.model.Property("optimizer")
        String optimizer) {
        this.optimizer = optimizer;
        return this;
    }

    /**
     * Gets the value of the scorable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    /**
     * Sets the value of the scorable property.
     * 
     * @param scorable
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public GaussianProcessModel setScorable(
        @org.jpmml.model.Property("scorable")
        Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    /**
     * Gets the value of the mathContext property.
     * 
     * @return
     *     possible object is
     *     {@link MathContext }
     *     
     */
    public MathContext getMathContext() {
        if (mathContext == null) {
            return MathContext.DOUBLE;
        } else {
            return mathContext;
        }
    }

    /**
     * Sets the value of the mathContext property.
     * 
     * @param mathContext
     *     allowed object is
     *     {@link MathContext }
     *     
     */
    public GaussianProcessModel setMathContext(
        @org.jpmml.model.Property("mathContext")
        MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the miningSchema property.
     * 
     * @return
     *     possible object is
     *     {@link MiningSchema }
     *     
     */
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    /**
     * Sets the value of the miningSchema property.
     * 
     * @param miningSchema
     *     allowed object is
     *     {@link MiningSchema }
     *     
     */
    public GaussianProcessModel setMiningSchema(
        @org.jpmml.model.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    /**
     * Gets the value of the output property.
     * 
     * @return
     *     possible object is
     *     {@link Output }
     *     
     */
    public Output getOutput() {
        return output;
    }

    /**
     * Sets the value of the output property.
     * 
     * @param output
     *     allowed object is
     *     {@link Output }
     *     
     */
    public GaussianProcessModel setOutput(
        @org.jpmml.model.Property("output")
        Output output) {
        this.output = output;
        return this;
    }

    /**
     * Gets the value of the modelStats property.
     * 
     * @return
     *     possible object is
     *     {@link ModelStats }
     *     
     */
    public ModelStats getModelStats() {
        return modelStats;
    }

    /**
     * Sets the value of the modelStats property.
     * 
     * @param modelStats
     *     allowed object is
     *     {@link ModelStats }
     *     
     */
    public GaussianProcessModel setModelStats(
        @org.jpmml.model.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    /**
     * Gets the value of the modelExplanation property.
     * 
     * @return
     *     possible object is
     *     {@link ModelExplanation }
     *     
     */
    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    /**
     * Sets the value of the modelExplanation property.
     * 
     * @param modelExplanation
     *     allowed object is
     *     {@link ModelExplanation }
     *     
     */
    public GaussianProcessModel setModelExplanation(
        @org.jpmml.model.Property("modelExplanation")
        ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    /**
     * Gets the value of the targets property.
     * 
     * @return
     *     possible object is
     *     {@link Targets }
     *     
     */
    public Targets getTargets() {
        return targets;
    }

    /**
     * Sets the value of the targets property.
     * 
     * @param targets
     *     allowed object is
     *     {@link Targets }
     *     
     */
    public GaussianProcessModel setTargets(
        @org.jpmml.model.Property("targets")
        Targets targets) {
        this.targets = targets;
        return this;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param localTransformations
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public GaussianProcessModel setLocalTransformations(
        @org.jpmml.model.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    /**
     * Gets the value of the radialBasisKernel property.
     * 
     * @return
     *     possible object is
     *     {@link RadialBasisKernel }
     *     
     */
    public RadialBasisKernel getRadialBasisKernel() {
        return radialBasisKernel;
    }

    /**
     * Sets the value of the radialBasisKernel property.
     * 
     * @param radialBasisKernel
     *     allowed object is
     *     {@link RadialBasisKernel }
     *     
     */
    public GaussianProcessModel setRadialBasisKernel(
        @org.jpmml.model.Property("radialBasisKernel")
        RadialBasisKernel radialBasisKernel) {
        this.radialBasisKernel = radialBasisKernel;
        return this;
    }

    /**
     * Gets the value of the ardSquaredExponentialKernel property.
     * 
     * @return
     *     possible object is
     *     {@link ARDSquaredExponentialKernel }
     *     
     */
    public ARDSquaredExponentialKernel getARDSquaredExponentialKernel() {
        return ardSquaredExponentialKernel;
    }

    /**
     * Sets the value of the ardSquaredExponentialKernel property.
     * 
     * @param ardSquaredExponentialKernel
     *     allowed object is
     *     {@link ARDSquaredExponentialKernel }
     *     
     */
    public GaussianProcessModel setARDSquaredExponentialKernel(
        @org.jpmml.model.Property("ardSquaredExponentialKernel")
        ARDSquaredExponentialKernel ardSquaredExponentialKernel) {
        this.ardSquaredExponentialKernel = ardSquaredExponentialKernel;
        return this;
    }

    /**
     * Gets the value of the absoluteExponentialKernel property.
     * 
     * @return
     *     possible object is
     *     {@link AbsoluteExponentialKernel }
     *     
     */
    public AbsoluteExponentialKernel getAbsoluteExponentialKernel() {
        return absoluteExponentialKernel;
    }

    /**
     * Sets the value of the absoluteExponentialKernel property.
     * 
     * @param absoluteExponentialKernel
     *     allowed object is
     *     {@link AbsoluteExponentialKernel }
     *     
     */
    public GaussianProcessModel setAbsoluteExponentialKernel(
        @org.jpmml.model.Property("absoluteExponentialKernel")
        AbsoluteExponentialKernel absoluteExponentialKernel) {
        this.absoluteExponentialKernel = absoluteExponentialKernel;
        return this;
    }

    /**
     * Gets the value of the generalizedExponentialKernel property.
     * 
     * @return
     *     possible object is
     *     {@link GeneralizedExponentialKernel }
     *     
     */
    public GeneralizedExponentialKernel getGeneralizedExponentialKernel() {
        return generalizedExponentialKernel;
    }

    /**
     * Sets the value of the generalizedExponentialKernel property.
     * 
     * @param generalizedExponentialKernel
     *     allowed object is
     *     {@link GeneralizedExponentialKernel }
     *     
     */
    public GaussianProcessModel setGeneralizedExponentialKernel(
        @org.jpmml.model.Property("generalizedExponentialKernel")
        GeneralizedExponentialKernel generalizedExponentialKernel) {
        this.generalizedExponentialKernel = generalizedExponentialKernel;
        return this;
    }

    /**
     * Gets the value of the trainingInstances property.
     * 
     * @return
     *     possible object is
     *     {@link TrainingInstances }
     *     
     */
    public TrainingInstances getTrainingInstances() {
        return trainingInstances;
    }

    /**
     * Sets the value of the trainingInstances property.
     * 
     * @param trainingInstances
     *     allowed object is
     *     {@link TrainingInstances }
     *     
     */
    public GaussianProcessModel setTrainingInstances(
        @org.jpmml.model.Property("trainingInstances")
        TrainingInstances trainingInstances) {
        this.trainingInstances = trainingInstances;
        return this;
    }

    /**
     * Gets the value of the modelVerification property.
     * 
     * @return
     *     possible object is
     *     {@link ModelVerification }
     *     
     */
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    /**
     * Sets the value of the modelVerification property.
     * 
     * @param modelVerification
     *     allowed object is
     *     {@link ModelVerification }
     *     
     */
    public GaussianProcessModel setModelVerification(
        @org.jpmml.model.Property("modelVerification")
        ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public GaussianProcessModel addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getModelExplanation(), getTargets(), getLocalTransformations(), getRadialBasisKernel(), getARDSquaredExponentialKernel(), getAbsoluteExponentialKernel(), getGeneralizedExponentialKernel(), getTrainingInstances(), getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
