
package org.dmg.pmml.time_series;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.Property;
import org.jpmml.schema.Added;
import org.jpmml.schema.Removed;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}TimeAnchor" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}TimeException" maxOccurs="2" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}TimeValue" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="usage" default="original">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="original"/>
 *             &lt;enumeration value="logical"/>
 *             &lt;enumeration value="prediction"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="startTime" type="{http://www.dmg.org/PMML-4_3}REAL-NUMBER" />
 *       &lt;attribute name="endTime" type="{http://www.dmg.org/PMML-4_3}REAL-NUMBER" />
 *       &lt;attribute name="interpolationMethod" default="none">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="none"/>
 *             &lt;enumeration value="linear"/>
 *             &lt;enumeration value="exponentialSpline"/>
 *             &lt;enumeration value="cubicSpline"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "timeAnchor",
    "timeExceptions",
    "timeValues"
})
@XmlRootElement(name = "TimeSeries", namespace = "http://www.dmg.org/PMML-4_3")
@Added(Version.PMML_4_0)
public class TimeSeries
    extends org.dmg.pmml.PMMLObject
{

    @XmlAttribute(name = "usage")
    private TimeSeries.Usage usage;
    @XmlAttribute(name = "startTime")
    private Double startTime;
    @XmlAttribute(name = "endTime")
    private Double endTime;
    @XmlAttribute(name = "interpolationMethod")
    private TimeSeries.InterpolationMethod interpolationMethod;
    @XmlElement(name = "TimeAnchor", namespace = "http://www.dmg.org/PMML-4_3")
    private TimeAnchor timeAnchor;
    @XmlElement(name = "TimeException", namespace = "http://www.dmg.org/PMML-4_3")
    @Removed(Version.PMML_4_1)
    private List<TimeException> timeExceptions;
    @XmlElement(name = "TimeValue", namespace = "http://www.dmg.org/PMML-4_3")
    private List<TimeValue> timeValues;
    private final static long serialVersionUID = 67305475L;

    /**
     * Gets the value of the usage property.
     * 
     * @return
     *     possible object is
     *     {@link TimeSeries.Usage }
     *     
     */
    public TimeSeries.Usage getUsage() {
        if (usage == null) {
            return TimeSeries.Usage.ORIGINAL;
        } else {
            return usage;
        }
    }

    /**
     * Sets the value of the usage property.
     * 
     * @param usage
     *     allowed object is
     *     {@link TimeSeries.Usage }
     *     
     */
    public TimeSeries setUsage(
        @Property("usage")
        TimeSeries.Usage usage) {
        this.usage = usage;
        return this;
    }

    /**
     * Gets the value of the startTime property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getStartTime() {
        return startTime;
    }

    /**
     * Sets the value of the startTime property.
     * 
     * @param startTime
     *     allowed object is
     *     {@link Double }
     *     
     */
    public TimeSeries setStartTime(
        @Property("startTime")
        Double startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Gets the value of the endTime property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getEndTime() {
        return endTime;
    }

    /**
     * Sets the value of the endTime property.
     * 
     * @param endTime
     *     allowed object is
     *     {@link Double }
     *     
     */
    public TimeSeries setEndTime(
        @Property("endTime")
        Double endTime) {
        this.endTime = endTime;
        return this;
    }

    /**
     * Gets the value of the interpolationMethod property.
     * 
     * @return
     *     possible object is
     *     {@link TimeSeries.InterpolationMethod }
     *     
     */
    public TimeSeries.InterpolationMethod getInterpolationMethod() {
        if (interpolationMethod == null) {
            return TimeSeries.InterpolationMethod.NONE;
        } else {
            return interpolationMethod;
        }
    }

    /**
     * Sets the value of the interpolationMethod property.
     * 
     * @param interpolationMethod
     *     allowed object is
     *     {@link TimeSeries.InterpolationMethod }
     *     
     */
    public TimeSeries setInterpolationMethod(
        @Property("interpolationMethod")
        TimeSeries.InterpolationMethod interpolationMethod) {
        this.interpolationMethod = interpolationMethod;
        return this;
    }

    /**
     * Gets the value of the timeAnchor property.
     * 
     * @return
     *     possible object is
     *     {@link TimeAnchor }
     *     
     */
    public TimeAnchor getTimeAnchor() {
        return timeAnchor;
    }

    /**
     * Sets the value of the timeAnchor property.
     * 
     * @param timeAnchor
     *     allowed object is
     *     {@link TimeAnchor }
     *     
     */
    public TimeSeries setTimeAnchor(
        @Property("timeAnchor")
        TimeAnchor timeAnchor) {
        this.timeAnchor = timeAnchor;
        return this;
    }

    /**
     * Gets the value of the timeExceptions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the timeExceptions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTimeExceptions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TimeException }
     * 
     * 
     */
    public List<TimeException> getTimeExceptions() {
        if (timeExceptions == null) {
            timeExceptions = new ArrayList<TimeException>();
        }
        return this.timeExceptions;
    }

    /**
     * Gets the value of the timeValues property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the timeValues property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTimeValues().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TimeValue }
     * 
     * 
     */
    public List<TimeValue> getTimeValues() {
        if (timeValues == null) {
            timeValues = new ArrayList<TimeValue>();
        }
        return this.timeValues;
    }

    public boolean hasTimeExceptions() {
        return ((this.timeExceptions!= null)&&(this.timeExceptions.size()> 0));
    }

    public TimeSeries addTimeExceptions(TimeException... timeExceptions) {
        getTimeExceptions().addAll(Arrays.asList(timeExceptions));
        return this;
    }

    public boolean hasTimeValues() {
        return ((this.timeValues!= null)&&(this.timeValues.size()> 0));
    }

    public TimeSeries addTimeValues(TimeValue... timeValues) {
        getTimeValues().addAll(Arrays.asList(timeValues));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTimeAnchor());
            }
            if ((status == VisitorAction.CONTINUE)&&hasTimeExceptions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTimeExceptions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasTimeValues()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTimeValues());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="none"/>
     *     &lt;enumeration value="linear"/>
     *     &lt;enumeration value="exponentialSpline"/>
     *     &lt;enumeration value="cubicSpline"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    @Added(Version.PMML_4_0)
    public enum InterpolationMethod {

        @XmlEnumValue("none")
        NONE("none"),
        @XmlEnumValue("linear")
        LINEAR("linear"),
        @XmlEnumValue("exponentialSpline")
        EXPONENTIAL_SPLINE("exponentialSpline"),
        @XmlEnumValue("cubicSpline")
        CUBIC_SPLINE("cubicSpline");
        private final String value;

        InterpolationMethod(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static TimeSeries.InterpolationMethod fromValue(String v) {
            for (TimeSeries.InterpolationMethod c: TimeSeries.InterpolationMethod.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="original"/>
     *     &lt;enumeration value="logical"/>
     *     &lt;enumeration value="prediction"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    @Added(Version.PMML_4_0)
    public enum Usage {

        @XmlEnumValue("original")
        ORIGINAL("original"),
        @XmlEnumValue("logical")
        LOGICAL("logical"),
        @XmlEnumValue("prediction")
        PREDICTION("prediction");
        private final String value;

        Usage(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static TimeSeries.Usage fromValue(String v) {
            for (TimeSeries.Usage c: TimeSeries.Usage.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
