
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}FieldColumnPair" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;choice>
 *           &lt;element ref="{http://www.dmg.org/PMML-4_3}TableLocator"/>
 *           &lt;element ref="{http://www.dmg.org/PMML-4_3}InlineTable"/>
 *         &lt;/choice>
 *       &lt;/sequence>
 *       &lt;attribute name="childField" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="parentField" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="parentLevelField" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="isRecursive" default="no">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="no"/>
 *             &lt;enumeration value="yes"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "fieldColumnPairs",
    "tableLocator",
    "inlineTable"
})
@XmlRootElement(name = "ChildParent", namespace = "http://www.dmg.org/PMML-4_3")
public class ChildParent
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<ChildParent> , HasTable<ChildParent>
{

    @XmlAttribute(name = "childField", required = true)
    private String childField;
    @XmlAttribute(name = "parentField", required = true)
    private String parentField;
    @XmlAttribute(name = "parentLevelField")
    private String parentLevelField;
    @XmlAttribute(name = "isRecursive")
    private ChildParent.Recursive recursive;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "FieldColumnPair", namespace = "http://www.dmg.org/PMML-4_3")
    @Added(Version.PMML_4_2)
    private List<FieldColumnPair> fieldColumnPairs;
    @XmlElement(name = "TableLocator", namespace = "http://www.dmg.org/PMML-4_3")
    private TableLocator tableLocator;
    @XmlElement(name = "InlineTable", namespace = "http://www.dmg.org/PMML-4_3")
    private InlineTable inlineTable;
    private final static long serialVersionUID = 67305475L;

    public ChildParent() {
    }

    public ChildParent(
        @org.jpmml.model.Property("childField")
        String childField,
        @org.jpmml.model.Property("parentField")
        String parentField) {
        this.childField = childField;
        this.parentField = parentField;
    }

    /**
     * Gets the value of the childField property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getChildField() {
        return childField;
    }

    /**
     * Sets the value of the childField property.
     * 
     * @param childField
     *     allowed object is
     *     {@link String }
     *     
     */
    public ChildParent setChildField(
        @org.jpmml.model.Property("childField")
        String childField) {
        this.childField = childField;
        return this;
    }

    /**
     * Gets the value of the parentField property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getParentField() {
        return parentField;
    }

    /**
     * Sets the value of the parentField property.
     * 
     * @param parentField
     *     allowed object is
     *     {@link String }
     *     
     */
    public ChildParent setParentField(
        @org.jpmml.model.Property("parentField")
        String parentField) {
        this.parentField = parentField;
        return this;
    }

    /**
     * Gets the value of the parentLevelField property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getParentLevelField() {
        return parentLevelField;
    }

    /**
     * Sets the value of the parentLevelField property.
     * 
     * @param parentLevelField
     *     allowed object is
     *     {@link String }
     *     
     */
    public ChildParent setParentLevelField(
        @org.jpmml.model.Property("parentLevelField")
        String parentLevelField) {
        this.parentLevelField = parentLevelField;
        return this;
    }

    /**
     * Gets the value of the recursive property.
     * 
     * @return
     *     possible object is
     *     {@link ChildParent.Recursive }
     *     
     */
    public ChildParent.Recursive getRecursive() {
        if (recursive == null) {
            return ChildParent.Recursive.NO;
        } else {
            return recursive;
        }
    }

    /**
     * Sets the value of the recursive property.
     * 
     * @param recursive
     *     allowed object is
     *     {@link ChildParent.Recursive }
     *     
     */
    public ChildParent setRecursive(
        @org.jpmml.model.Property("recursive")
        ChildParent.Recursive recursive) {
        this.recursive = recursive;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the fieldColumnPairs property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the fieldColumnPairs property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getFieldColumnPairs().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FieldColumnPair }
     * 
     * 
     */
    public List<FieldColumnPair> getFieldColumnPairs() {
        if (fieldColumnPairs == null) {
            fieldColumnPairs = new ArrayList<FieldColumnPair>();
        }
        return this.fieldColumnPairs;
    }

    /**
     * Gets the value of the tableLocator property.
     * 
     * @return
     *     possible object is
     *     {@link TableLocator }
     *     
     */
    public TableLocator getTableLocator() {
        return tableLocator;
    }

    /**
     * Sets the value of the tableLocator property.
     * 
     * @param tableLocator
     *     allowed object is
     *     {@link TableLocator }
     *     
     */
    public ChildParent setTableLocator(
        @org.jpmml.model.Property("tableLocator")
        TableLocator tableLocator) {
        this.tableLocator = tableLocator;
        return this;
    }

    /**
     * Gets the value of the inlineTable property.
     * 
     * @return
     *     possible object is
     *     {@link InlineTable }
     *     
     */
    public InlineTable getInlineTable() {
        return inlineTable;
    }

    /**
     * Sets the value of the inlineTable property.
     * 
     * @param inlineTable
     *     allowed object is
     *     {@link InlineTable }
     *     
     */
    public ChildParent setInlineTable(
        @org.jpmml.model.Property("inlineTable")
        InlineTable inlineTable) {
        this.inlineTable = inlineTable;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public ChildParent addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasFieldColumnPairs() {
        return ((this.fieldColumnPairs!= null)&&(this.fieldColumnPairs.size()> 0));
    }

    public ChildParent addFieldColumnPairs(FieldColumnPair... fieldColumnPairs) {
        getFieldColumnPairs().addAll(Arrays.asList(fieldColumnPairs));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasFieldColumnPairs()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getFieldColumnPairs());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTableLocator(), getInlineTable());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="no"/>
     *     &lt;enumeration value="yes"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum Recursive {

        @XmlEnumValue("no")
        NO("no"),
        @XmlEnumValue("yes")
        YES("yes");
        private final String value;

        Recursive(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static ChildParent.Recursive fromValue(String v) {
            for (ChildParent.Recursive c: ChildParent.Recursive.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
