
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Optional;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}DiscretizeBin" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="field" use="required" type="{http://www.dmg.org/PMML-4_3}FIELD-NAME" />
 *       &lt;attribute name="mapMissingTo" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="defaultValue" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="dataType" type="{http://www.dmg.org/PMML-4_3}DATATYPE" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "discretizeBins"
})
@XmlRootElement(name = "Discretize", namespace = "http://www.dmg.org/PMML-4_3")
public class Discretize
    extends Expression
    implements HasDefaultValue<Discretize> , HasExtensions<Discretize> , HasMapMissingTo<Discretize, String>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName field;
    @XmlAttribute(name = "mapMissingTo")
    private String mapMissingTo;
    @XmlAttribute(name = "defaultValue")
    private String defaultValue;
    @XmlAttribute(name = "dataType")
    @Added(Version.PMML_3_1)
    private DataType dataType;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "DiscretizeBin", namespace = "http://www.dmg.org/PMML-4_3")
    @Optional(Version.PMML_3_2)
    private List<DiscretizeBin> discretizeBins;
    private final static long serialVersionUID = 67305475L;

    public Discretize() {
    }

    public Discretize(
        @org.jpmml.model.Property("field")
        FieldName field) {
        this.field = field;
    }

    /**
     * Gets the value of the field property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getField() {
        return field;
    }

    /**
     * Sets the value of the field property.
     * 
     * @param field
     *     allowed object is
     *     {@link String }
     *     
     */
    public Discretize setField(
        @org.jpmml.model.Property("field")
        FieldName field) {
        this.field = field;
        return this;
    }

    /**
     * Gets the value of the mapMissingTo property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getMapMissingTo() {
        return mapMissingTo;
    }

    /**
     * Sets the value of the mapMissingTo property.
     * 
     * @param mapMissingTo
     *     allowed object is
     *     {@link String }
     *     
     */
    public Discretize setMapMissingTo(
        @org.jpmml.model.Property("mapMissingTo")
        String mapMissingTo) {
        this.mapMissingTo = mapMissingTo;
        return this;
    }

    /**
     * Gets the value of the defaultValue property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDefaultValue() {
        return defaultValue;
    }

    /**
     * Sets the value of the defaultValue property.
     * 
     * @param defaultValue
     *     allowed object is
     *     {@link String }
     *     
     */
    public Discretize setDefaultValue(
        @org.jpmml.model.Property("defaultValue")
        String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    /**
     * Gets the value of the dataType property.
     * 
     * @return
     *     possible object is
     *     {@link DataType }
     *     
     */
    public DataType getDataType() {
        return dataType;
    }

    /**
     * Sets the value of the dataType property.
     * 
     * @param dataType
     *     allowed object is
     *     {@link DataType }
     *     
     */
    public Discretize setDataType(
        @org.jpmml.model.Property("dataType")
        DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the discretizeBins property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the discretizeBins property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDiscretizeBins().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DiscretizeBin }
     * 
     * 
     */
    public List<DiscretizeBin> getDiscretizeBins() {
        if (discretizeBins == null) {
            discretizeBins = new ArrayList<DiscretizeBin>();
        }
        return this.discretizeBins;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Discretize addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasDiscretizeBins() {
        return ((this.discretizeBins!= null)&&(this.discretizeBins.size()> 0));
    }

    public Discretize addDiscretizeBins(DiscretizeBin... discretizeBins) {
        getDiscretizeBins().addAll(Arrays.asList(discretizeBins));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasDiscretizeBins()) {
                status = PMMLObject.traverse(visitor, getDiscretizeBins());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
