
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}XCoordinates"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}YCoordinates"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}BoundaryValues" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}BoundaryValueMeans" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "xCoordinates",
    "yCoordinates",
    "boundaryValues",
    "boundaryValueMeans"
})
@XmlRootElement(name = "LiftGraph", namespace = "http://www.dmg.org/PMML-4_3")
@Added(Version.PMML_4_0)
public class LiftGraph
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<LiftGraph>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "XCoordinates", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private XCoordinates xCoordinates;
    @XmlElement(name = "YCoordinates", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private YCoordinates yCoordinates;
    @XmlElement(name = "BoundaryValues", namespace = "http://www.dmg.org/PMML-4_3")
    private BoundaryValues boundaryValues;
    @XmlElement(name = "BoundaryValueMeans", namespace = "http://www.dmg.org/PMML-4_3")
    private BoundaryValueMeans boundaryValueMeans;
    private final static long serialVersionUID = 67305475L;

    public LiftGraph() {
    }

    public LiftGraph(
        @org.jpmml.model.Property("xCoordinates")
        XCoordinates xCoordinates,
        @org.jpmml.model.Property("yCoordinates")
        YCoordinates yCoordinates) {
        this.xCoordinates = xCoordinates;
        this.yCoordinates = yCoordinates;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the xCoordinates property.
     * 
     * @return
     *     possible object is
     *     {@link XCoordinates }
     *     
     */
    public XCoordinates getXCoordinates() {
        return xCoordinates;
    }

    /**
     * Sets the value of the xCoordinates property.
     * 
     * @param xCoordinates
     *     allowed object is
     *     {@link XCoordinates }
     *     
     */
    public LiftGraph setXCoordinates(
        @org.jpmml.model.Property("xCoordinates")
        XCoordinates xCoordinates) {
        this.xCoordinates = xCoordinates;
        return this;
    }

    /**
     * Gets the value of the yCoordinates property.
     * 
     * @return
     *     possible object is
     *     {@link YCoordinates }
     *     
     */
    public YCoordinates getYCoordinates() {
        return yCoordinates;
    }

    /**
     * Sets the value of the yCoordinates property.
     * 
     * @param yCoordinates
     *     allowed object is
     *     {@link YCoordinates }
     *     
     */
    public LiftGraph setYCoordinates(
        @org.jpmml.model.Property("yCoordinates")
        YCoordinates yCoordinates) {
        this.yCoordinates = yCoordinates;
        return this;
    }

    /**
     * Gets the value of the boundaryValues property.
     * 
     * @return
     *     possible object is
     *     {@link BoundaryValues }
     *     
     */
    public BoundaryValues getBoundaryValues() {
        return boundaryValues;
    }

    /**
     * Sets the value of the boundaryValues property.
     * 
     * @param boundaryValues
     *     allowed object is
     *     {@link BoundaryValues }
     *     
     */
    public LiftGraph setBoundaryValues(
        @org.jpmml.model.Property("boundaryValues")
        BoundaryValues boundaryValues) {
        this.boundaryValues = boundaryValues;
        return this;
    }

    /**
     * Gets the value of the boundaryValueMeans property.
     * 
     * @return
     *     possible object is
     *     {@link BoundaryValueMeans }
     *     
     */
    public BoundaryValueMeans getBoundaryValueMeans() {
        return boundaryValueMeans;
    }

    /**
     * Sets the value of the boundaryValueMeans property.
     * 
     * @param boundaryValueMeans
     *     allowed object is
     *     {@link BoundaryValueMeans }
     *     
     */
    public LiftGraph setBoundaryValueMeans(
        @org.jpmml.model.Property("boundaryValueMeans")
        BoundaryValueMeans boundaryValueMeans) {
        this.boundaryValueMeans = boundaryValueMeans;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public LiftGraph addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getXCoordinates(), getYCoordinates(), getBoundaryValues(), getBoundaryValueMeans());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
