
package org.dmg.pmml.association;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasId;
import org.dmg.pmml.Indexable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="id" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="value" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="field" type="{http://www.dmg.org/PMML-4_3}FIELD-NAME" />
 *       &lt;attribute name="category" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="mappedValue" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="weight" type="{http://www.dmg.org/PMML-4_3}REAL-NUMBER" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "Item", namespace = "http://www.dmg.org/PMML-4_3")
public class Item
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Item> , HasId<Item> , Indexable<String>
{

    @XmlAttribute(name = "id", required = true)
    private String id;
    @XmlAttribute(name = "value", required = true)
    private String value;
    @XmlAttribute(name = "field")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @Added(Version.PMML_4_3)
    private FieldName field;
    @XmlAttribute(name = "category")
    @Added(Version.PMML_4_3)
    private String category;
    @XmlAttribute(name = "mappedValue")
    private String mappedValue;
    @XmlAttribute(name = "weight")
    private Double weight;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67305475L;

    public Item() {
    }

    public Item(
        @org.jpmml.model.Property("id")
        String id,
        @org.jpmml.model.Property("value")
        String value) {
        this.id = id;
        this.value = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param id
     *     allowed object is
     *     {@link String }
     *     
     */
    public Item setId(
        @org.jpmml.model.Property("id")
        String id) {
        this.id = id;
        return this;
    }

    /**
     * Gets the value of the value property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public Item setValue(
        @org.jpmml.model.Property("value")
        String value) {
        this.value = value;
        return this;
    }

    /**
     * Gets the value of the field property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getField() {
        return field;
    }

    /**
     * Sets the value of the field property.
     * 
     * @param field
     *     allowed object is
     *     {@link String }
     *     
     */
    public Item setField(
        @org.jpmml.model.Property("field")
        FieldName field) {
        this.field = field;
        return this;
    }

    /**
     * Gets the value of the category property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCategory() {
        return category;
    }

    /**
     * Sets the value of the category property.
     * 
     * @param category
     *     allowed object is
     *     {@link String }
     *     
     */
    public Item setCategory(
        @org.jpmml.model.Property("category")
        String category) {
        this.category = category;
        return this;
    }

    /**
     * Gets the value of the mappedValue property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getMappedValue() {
        return mappedValue;
    }

    /**
     * Sets the value of the mappedValue property.
     * 
     * @param mappedValue
     *     allowed object is
     *     {@link String }
     *     
     */
    public Item setMappedValue(
        @org.jpmml.model.Property("mappedValue")
        String mappedValue) {
        this.mappedValue = mappedValue;
        return this;
    }

    /**
     * Gets the value of the weight property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getWeight() {
        return weight;
    }

    /**
     * Sets the value of the weight property.
     * 
     * @param weight
     *     allowed object is
     *     {@link Double }
     *     
     */
    public Item setWeight(
        @org.jpmml.model.Property("weight")
        Double weight) {
        this.weight = weight;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public String getKey() {
        return getId();
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Item addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
