
package org.dmg.pmml.time_series;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}MiningSchema"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Output" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}ModelStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}ModelExplanation" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}LocalTransformations" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}TimeSeries" maxOccurs="3" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}SpectralAnalysis" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}ARIMA" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}ExponentialSmoothing" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}SeasonalTrendDecomposition" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}ModelVerification" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="modelName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="functionName" use="required" type="{http://www.dmg.org/PMML-4_3}MINING-FUNCTION" />
 *       &lt;attribute name="algorithmName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="bestFit" use="required">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="ARIMA"/>
 *             &lt;enumeration value="ExponentialSmoothing"/>
 *             &lt;enumeration value="SeasonalTrendDecomposition"/>
 *             &lt;enumeration value="SpectralAnalysis"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="isScorable" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       &lt;attribute name="x-mathContext" type="{http://www.dmg.org/PMML-4_3}MATH-CONTEXT" default="double" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "localTransformations",
    "timeSeries",
    "spectralAnalysis",
    "arima",
    "exponentialSmoothing",
    "seasonalTrendDecomposition",
    "modelVerification"
})
@XmlRootElement(name = "TimeSeriesModel", namespace = "http://www.dmg.org/PMML-4_3")
@Added(Version.PMML_4_0)
public class TimeSeriesModel
    extends Model
    implements HasExtensions<TimeSeriesModel>
{

    @XmlAttribute(name = "modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "bestFit", required = true)
    private TimeSeriesModel.Algorithm bestFit;
    @XmlAttribute(name = "isScorable")
    @Added(Version.PMML_4_1)
    private Boolean scorable;
    @XmlAttribute(name = "x-mathContext")
    @org.jpmml.schema.Extension
    private MathContext mathContext;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<org.dmg.pmml.Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_3")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_3")
    private ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_3")
    @Added(Version.PMML_4_1)
    private ModelExplanation modelExplanation;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_3")
    private LocalTransformations localTransformations;
    @XmlElement(name = "TimeSeries", namespace = "http://www.dmg.org/PMML-4_3")
    private List<TimeSeries> timeSeries;
    @XmlElement(name = "SpectralAnalysis", namespace = "http://www.dmg.org/PMML-4_3")
    private SpectralAnalysis spectralAnalysis;
    @XmlElement(name = "ARIMA", namespace = "http://www.dmg.org/PMML-4_3")
    private org.dmg.pmml.time_series.ARIMA arima;
    @XmlElement(name = "ExponentialSmoothing", namespace = "http://www.dmg.org/PMML-4_3")
    private ExponentialSmoothing exponentialSmoothing;
    @XmlElement(name = "SeasonalTrendDecomposition", namespace = "http://www.dmg.org/PMML-4_3")
    private SeasonalTrendDecomposition seasonalTrendDecomposition;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_3")
    private ModelVerification modelVerification;
    private final static Boolean DEFAULT_SCORABLE = true;
    private final static long serialVersionUID = 67305475L;

    public TimeSeriesModel() {
    }

    public TimeSeriesModel(
        @org.jpmml.model.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.Property("bestFit")
        TimeSeriesModel.Algorithm bestFit,
        @org.jpmml.model.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningFunction = miningFunction;
        this.bestFit = bestFit;
        this.miningSchema = miningSchema;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Sets the value of the modelName property.
     * 
     * @param modelName
     *     allowed object is
     *     {@link String }
     *     
     */
    public TimeSeriesModel setModelName(
        @org.jpmml.model.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    /**
     * Gets the value of the miningFunction property.
     * 
     * @return
     *     possible object is
     *     {@link MiningFunction }
     *     
     */
    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    /**
     * Sets the value of the miningFunction property.
     * 
     * @param miningFunction
     *     allowed object is
     *     {@link MiningFunction }
     *     
     */
    public TimeSeriesModel setMiningFunction(
        @org.jpmml.model.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    /**
     * Gets the value of the algorithmName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithmName() {
        return algorithmName;
    }

    /**
     * Sets the value of the algorithmName property.
     * 
     * @param algorithmName
     *     allowed object is
     *     {@link String }
     *     
     */
    public TimeSeriesModel setAlgorithmName(
        @org.jpmml.model.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    /**
     * Gets the value of the bestFit property.
     * 
     * @return
     *     possible object is
     *     {@link TimeSeriesModel.Algorithm }
     *     
     */
    public TimeSeriesModel.Algorithm getBestFit() {
        return bestFit;
    }

    /**
     * Sets the value of the bestFit property.
     * 
     * @param bestFit
     *     allowed object is
     *     {@link TimeSeriesModel.Algorithm }
     *     
     */
    public TimeSeriesModel setBestFit(
        @org.jpmml.model.Property("bestFit")
        TimeSeriesModel.Algorithm bestFit) {
        this.bestFit = bestFit;
        return this;
    }

    /**
     * Gets the value of the scorable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    /**
     * Sets the value of the scorable property.
     * 
     * @param scorable
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public TimeSeriesModel setScorable(
        @org.jpmml.model.Property("scorable")
        Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    /**
     * Gets the value of the mathContext property.
     * 
     * @return
     *     possible object is
     *     {@link MathContext }
     *     
     */
    public MathContext getMathContext() {
        if (mathContext == null) {
            return MathContext.DOUBLE;
        } else {
            return mathContext;
        }
    }

    /**
     * Sets the value of the mathContext property.
     * 
     * @param mathContext
     *     allowed object is
     *     {@link MathContext }
     *     
     */
    public TimeSeriesModel setMathContext(
        @org.jpmml.model.Property("mathContext")
        MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link org.dmg.pmml.Extension }
     * 
     * 
     */
    public List<org.dmg.pmml.Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<org.dmg.pmml.Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the miningSchema property.
     * 
     * @return
     *     possible object is
     *     {@link MiningSchema }
     *     
     */
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    /**
     * Sets the value of the miningSchema property.
     * 
     * @param miningSchema
     *     allowed object is
     *     {@link MiningSchema }
     *     
     */
    public TimeSeriesModel setMiningSchema(
        @org.jpmml.model.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    /**
     * Gets the value of the output property.
     * 
     * @return
     *     possible object is
     *     {@link Output }
     *     
     */
    public Output getOutput() {
        return output;
    }

    /**
     * Sets the value of the output property.
     * 
     * @param output
     *     allowed object is
     *     {@link Output }
     *     
     */
    public TimeSeriesModel setOutput(
        @org.jpmml.model.Property("output")
        Output output) {
        this.output = output;
        return this;
    }

    /**
     * Gets the value of the modelStats property.
     * 
     * @return
     *     possible object is
     *     {@link ModelStats }
     *     
     */
    public ModelStats getModelStats() {
        return modelStats;
    }

    /**
     * Sets the value of the modelStats property.
     * 
     * @param modelStats
     *     allowed object is
     *     {@link ModelStats }
     *     
     */
    public TimeSeriesModel setModelStats(
        @org.jpmml.model.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    /**
     * Gets the value of the modelExplanation property.
     * 
     * @return
     *     possible object is
     *     {@link ModelExplanation }
     *     
     */
    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    /**
     * Sets the value of the modelExplanation property.
     * 
     * @param modelExplanation
     *     allowed object is
     *     {@link ModelExplanation }
     *     
     */
    public TimeSeriesModel setModelExplanation(
        @org.jpmml.model.Property("modelExplanation")
        ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param localTransformations
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public TimeSeriesModel setLocalTransformations(
        @org.jpmml.model.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    /**
     * Gets the value of the timeSeries property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the timeSeries property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTimeSeries().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TimeSeries }
     * 
     * 
     */
    public List<TimeSeries> getTimeSeries() {
        if (timeSeries == null) {
            timeSeries = new ArrayList<TimeSeries>();
        }
        return this.timeSeries;
    }

    /**
     * Gets the value of the spectralAnalysis property.
     * 
     * @return
     *     possible object is
     *     {@link SpectralAnalysis }
     *     
     */
    public SpectralAnalysis getSpectralAnalysis() {
        return spectralAnalysis;
    }

    /**
     * Sets the value of the spectralAnalysis property.
     * 
     * @param spectralAnalysis
     *     allowed object is
     *     {@link SpectralAnalysis }
     *     
     */
    public TimeSeriesModel setSpectralAnalysis(
        @org.jpmml.model.Property("spectralAnalysis")
        SpectralAnalysis spectralAnalysis) {
        this.spectralAnalysis = spectralAnalysis;
        return this;
    }

    /**
     * Gets the value of the arima property.
     * 
     * @return
     *     possible object is
     *     {@link org.dmg.pmml.time_series.ARIMA }
     *     
     */
    public org.dmg.pmml.time_series.ARIMA getARIMA() {
        return arima;
    }

    /**
     * Sets the value of the arima property.
     * 
     * @param arima
     *     allowed object is
     *     {@link org.dmg.pmml.time_series.ARIMA }
     *     
     */
    public TimeSeriesModel setARIMA(
        @org.jpmml.model.Property("arima")
        org.dmg.pmml.time_series.ARIMA arima) {
        this.arima = arima;
        return this;
    }

    /**
     * Gets the value of the exponentialSmoothing property.
     * 
     * @return
     *     possible object is
     *     {@link ExponentialSmoothing }
     *     
     */
    public ExponentialSmoothing getExponentialSmoothing() {
        return exponentialSmoothing;
    }

    /**
     * Sets the value of the exponentialSmoothing property.
     * 
     * @param exponentialSmoothing
     *     allowed object is
     *     {@link ExponentialSmoothing }
     *     
     */
    public TimeSeriesModel setExponentialSmoothing(
        @org.jpmml.model.Property("exponentialSmoothing")
        ExponentialSmoothing exponentialSmoothing) {
        this.exponentialSmoothing = exponentialSmoothing;
        return this;
    }

    /**
     * Gets the value of the seasonalTrendDecomposition property.
     * 
     * @return
     *     possible object is
     *     {@link SeasonalTrendDecomposition }
     *     
     */
    public SeasonalTrendDecomposition getSeasonalTrendDecomposition() {
        return seasonalTrendDecomposition;
    }

    /**
     * Sets the value of the seasonalTrendDecomposition property.
     * 
     * @param seasonalTrendDecomposition
     *     allowed object is
     *     {@link SeasonalTrendDecomposition }
     *     
     */
    public TimeSeriesModel setSeasonalTrendDecomposition(
        @org.jpmml.model.Property("seasonalTrendDecomposition")
        SeasonalTrendDecomposition seasonalTrendDecomposition) {
        this.seasonalTrendDecomposition = seasonalTrendDecomposition;
        return this;
    }

    /**
     * Gets the value of the modelVerification property.
     * 
     * @return
     *     possible object is
     *     {@link ModelVerification }
     *     
     */
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    /**
     * Sets the value of the modelVerification property.
     * 
     * @param modelVerification
     *     allowed object is
     *     {@link ModelVerification }
     *     
     */
    public TimeSeriesModel setModelVerification(
        @org.jpmml.model.Property("modelVerification")
        ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public TimeSeriesModel addExtensions(org.dmg.pmml.Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasTimeSeries() {
        return ((this.timeSeries!= null)&&(this.timeSeries.size()> 0));
    }

    public TimeSeriesModel addTimeSeries(TimeSeries... timeSeries) {
        getTimeSeries().addAll(Arrays.asList(timeSeries));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getModelExplanation(), getLocalTransformations());
            }
            if ((status == VisitorAction.CONTINUE)&&hasTimeSeries()) {
                status = PMMLObject.traverse(visitor, getTimeSeries());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getSpectralAnalysis(), getARIMA(), getExponentialSmoothing(), getSeasonalTrendDecomposition(), getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="ARIMA"/>
     *     &lt;enumeration value="ExponentialSmoothing"/>
     *     &lt;enumeration value="SeasonalTrendDecomposition"/>
     *     &lt;enumeration value="SpectralAnalysis"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    @Added(Version.PMML_4_0)
    public enum Algorithm {

        ARIMA("ARIMA"),
        @XmlEnumValue("ExponentialSmoothing")
        EXPONENTIAL_SMOOTHING("ExponentialSmoothing"),
        @XmlEnumValue("SeasonalTrendDecomposition")
        SEASONAL_TREND_DECOMPOSITION("SeasonalTrendDecomposition"),
        @XmlEnumValue("SpectralAnalysis")
        SPECTRAL_ANALYSIS("SpectralAnalysis");
        private final String value;

        Algorithm(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static TimeSeriesModel.Algorithm fromValue(String v) {
            for (TimeSeriesModel.Algorithm c: TimeSeriesModel.Algorithm.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
