
package org.dmg.pmml.nearest_neighbor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}MiningSchema"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Output" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}ModelStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}ModelExplanation" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Targets" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}LocalTransformations" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}TrainingInstances"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}ComparisonMeasure"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}KNNInputs"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}ModelVerification" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="modelName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="functionName" use="required" type="{http://www.dmg.org/PMML-4_3}MINING-FUNCTION" />
 *       &lt;attribute name="algorithmName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="numberOfNeighbors" use="required" type="{http://www.dmg.org/PMML-4_3}INT-NUMBER" />
 *       &lt;attribute name="continuousScoringMethod" default="average">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="median"/>
 *             &lt;enumeration value="average"/>
 *             &lt;enumeration value="weightedAverage"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="categoricalScoringMethod" default="majorityVote">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="majorityVote"/>
 *             &lt;enumeration value="weightedMajorityVote"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="instanceIdVariable" type="{http://www.dmg.org/PMML-4_3}FIELD-NAME" />
 *       &lt;attribute name="threshold" type="{http://www.dmg.org/PMML-4_3}REAL-NUMBER" default="0.001" />
 *       &lt;attribute name="isScorable" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       &lt;attribute name="x-mathContext" type="{http://www.dmg.org/PMML-4_3}MATH-CONTEXT" default="double" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "trainingInstances",
    "comparisonMeasure",
    "knnInputs",
    "modelVerification"
})
@XmlRootElement(name = "NearestNeighborModel", namespace = "http://www.dmg.org/PMML-4_3")
@Added(Version.PMML_4_1)
public class NearestNeighborModel
    extends Model
    implements HasExtensions<NearestNeighborModel>
{

    @XmlAttribute(name = "modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "numberOfNeighbors", required = true)
    private int numberOfNeighbors;
    @XmlAttribute(name = "continuousScoringMethod")
    private NearestNeighborModel.ContinuousScoringMethod continuousScoringMethod;
    @XmlAttribute(name = "categoricalScoringMethod")
    private NearestNeighborModel.CategoricalScoringMethod categoricalScoringMethod;
    @XmlAttribute(name = "instanceIdVariable")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName instanceIdVariable;
    @XmlAttribute(name = "threshold")
    private Double threshold;
    @XmlAttribute(name = "isScorable")
    @Added(Version.PMML_4_1)
    private Boolean scorable;
    @XmlAttribute(name = "x-mathContext")
    @org.jpmml.schema.Extension
    private MathContext mathContext;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<org.dmg.pmml.Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_3")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_3")
    private ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_3")
    private ModelExplanation modelExplanation;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_3")
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_3")
    private LocalTransformations localTransformations;
    @XmlElement(name = "TrainingInstances", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private TrainingInstances trainingInstances;
    @XmlElement(name = "ComparisonMeasure", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private ComparisonMeasure comparisonMeasure;
    @XmlElement(name = "KNNInputs", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private KNNInputs knnInputs;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_3")
    private ModelVerification modelVerification;
    private final static Double DEFAULT_THRESHOLD = 0.001D;
    private final static Boolean DEFAULT_SCORABLE = true;
    private final static long serialVersionUID = 67305478L;

    public NearestNeighborModel() {
    }

    public NearestNeighborModel(
        @org.jpmml.model.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.Property("numberOfNeighbors")
        int numberOfNeighbors,
        @org.jpmml.model.Property("miningSchema")
        MiningSchema miningSchema,
        @org.jpmml.model.Property("trainingInstances")
        TrainingInstances trainingInstances,
        @org.jpmml.model.Property("comparisonMeasure")
        ComparisonMeasure comparisonMeasure,
        @org.jpmml.model.Property("knnInputs")
        KNNInputs knnInputs) {
        this.miningFunction = miningFunction;
        this.numberOfNeighbors = numberOfNeighbors;
        this.miningSchema = miningSchema;
        this.trainingInstances = trainingInstances;
        this.comparisonMeasure = comparisonMeasure;
        this.knnInputs = knnInputs;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Sets the value of the modelName property.
     * 
     * @param modelName
     *     allowed object is
     *     {@link String }
     *     
     */
    public NearestNeighborModel setModelName(
        @org.jpmml.model.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    /**
     * Gets the value of the miningFunction property.
     * 
     * @return
     *     possible object is
     *     {@link MiningFunction }
     *     
     */
    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    /**
     * Sets the value of the miningFunction property.
     * 
     * @param miningFunction
     *     allowed object is
     *     {@link MiningFunction }
     *     
     */
    public NearestNeighborModel setMiningFunction(
        @org.jpmml.model.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    /**
     * Gets the value of the algorithmName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithmName() {
        return algorithmName;
    }

    /**
     * Sets the value of the algorithmName property.
     * 
     * @param algorithmName
     *     allowed object is
     *     {@link String }
     *     
     */
    public NearestNeighborModel setAlgorithmName(
        @org.jpmml.model.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    /**
     * Gets the value of the numberOfNeighbors property.
     * 
     */
    public int getNumberOfNeighbors() {
        return numberOfNeighbors;
    }

    /**
     * Sets the value of the numberOfNeighbors property.
     * 
     */
    public NearestNeighborModel setNumberOfNeighbors(
        @org.jpmml.model.Property("numberOfNeighbors")
        int numberOfNeighbors) {
        this.numberOfNeighbors = numberOfNeighbors;
        return this;
    }

    /**
     * Gets the value of the continuousScoringMethod property.
     * 
     * @return
     *     possible object is
     *     {@link NearestNeighborModel.ContinuousScoringMethod }
     *     
     */
    public NearestNeighborModel.ContinuousScoringMethod getContinuousScoringMethod() {
        if (continuousScoringMethod == null) {
            return NearestNeighborModel.ContinuousScoringMethod.AVERAGE;
        } else {
            return continuousScoringMethod;
        }
    }

    /**
     * Sets the value of the continuousScoringMethod property.
     * 
     * @param continuousScoringMethod
     *     allowed object is
     *     {@link NearestNeighborModel.ContinuousScoringMethod }
     *     
     */
    public NearestNeighborModel setContinuousScoringMethod(
        @org.jpmml.model.Property("continuousScoringMethod")
        NearestNeighborModel.ContinuousScoringMethod continuousScoringMethod) {
        this.continuousScoringMethod = continuousScoringMethod;
        return this;
    }

    /**
     * Gets the value of the categoricalScoringMethod property.
     * 
     * @return
     *     possible object is
     *     {@link NearestNeighborModel.CategoricalScoringMethod }
     *     
     */
    public NearestNeighborModel.CategoricalScoringMethod getCategoricalScoringMethod() {
        if (categoricalScoringMethod == null) {
            return NearestNeighborModel.CategoricalScoringMethod.MAJORITY_VOTE;
        } else {
            return categoricalScoringMethod;
        }
    }

    /**
     * Sets the value of the categoricalScoringMethod property.
     * 
     * @param categoricalScoringMethod
     *     allowed object is
     *     {@link NearestNeighborModel.CategoricalScoringMethod }
     *     
     */
    public NearestNeighborModel setCategoricalScoringMethod(
        @org.jpmml.model.Property("categoricalScoringMethod")
        NearestNeighborModel.CategoricalScoringMethod categoricalScoringMethod) {
        this.categoricalScoringMethod = categoricalScoringMethod;
        return this;
    }

    /**
     * Gets the value of the instanceIdVariable property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getInstanceIdVariable() {
        return instanceIdVariable;
    }

    /**
     * Sets the value of the instanceIdVariable property.
     * 
     * @param instanceIdVariable
     *     allowed object is
     *     {@link String }
     *     
     */
    public NearestNeighborModel setInstanceIdVariable(
        @org.jpmml.model.Property("instanceIdVariable")
        FieldName instanceIdVariable) {
        this.instanceIdVariable = instanceIdVariable;
        return this;
    }

    /**
     * Gets the value of the threshold property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getThreshold() {
        if (threshold == null) {
            return DEFAULT_THRESHOLD;
        } else {
            return threshold;
        }
    }

    /**
     * Sets the value of the threshold property.
     * 
     * @param threshold
     *     allowed object is
     *     {@link Double }
     *     
     */
    public NearestNeighborModel setThreshold(
        @org.jpmml.model.Property("threshold")
        Double threshold) {
        this.threshold = threshold;
        return this;
    }

    /**
     * Gets the value of the scorable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    /**
     * Sets the value of the scorable property.
     * 
     * @param scorable
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public NearestNeighborModel setScorable(
        @org.jpmml.model.Property("scorable")
        Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    /**
     * Gets the value of the mathContext property.
     * 
     * @return
     *     possible object is
     *     {@link MathContext }
     *     
     */
    public MathContext getMathContext() {
        if (mathContext == null) {
            return MathContext.DOUBLE;
        } else {
            return mathContext;
        }
    }

    /**
     * Sets the value of the mathContext property.
     * 
     * @param mathContext
     *     allowed object is
     *     {@link MathContext }
     *     
     */
    public NearestNeighborModel setMathContext(
        @org.jpmml.model.Property("mathContext")
        MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link org.dmg.pmml.Extension }
     * 
     * 
     */
    public List<org.dmg.pmml.Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<org.dmg.pmml.Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the miningSchema property.
     * 
     * @return
     *     possible object is
     *     {@link MiningSchema }
     *     
     */
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    /**
     * Sets the value of the miningSchema property.
     * 
     * @param miningSchema
     *     allowed object is
     *     {@link MiningSchema }
     *     
     */
    public NearestNeighborModel setMiningSchema(
        @org.jpmml.model.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    /**
     * Gets the value of the output property.
     * 
     * @return
     *     possible object is
     *     {@link Output }
     *     
     */
    public Output getOutput() {
        return output;
    }

    /**
     * Sets the value of the output property.
     * 
     * @param output
     *     allowed object is
     *     {@link Output }
     *     
     */
    public NearestNeighborModel setOutput(
        @org.jpmml.model.Property("output")
        Output output) {
        this.output = output;
        return this;
    }

    /**
     * Gets the value of the modelStats property.
     * 
     * @return
     *     possible object is
     *     {@link ModelStats }
     *     
     */
    public ModelStats getModelStats() {
        return modelStats;
    }

    /**
     * Sets the value of the modelStats property.
     * 
     * @param modelStats
     *     allowed object is
     *     {@link ModelStats }
     *     
     */
    public NearestNeighborModel setModelStats(
        @org.jpmml.model.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    /**
     * Gets the value of the modelExplanation property.
     * 
     * @return
     *     possible object is
     *     {@link ModelExplanation }
     *     
     */
    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    /**
     * Sets the value of the modelExplanation property.
     * 
     * @param modelExplanation
     *     allowed object is
     *     {@link ModelExplanation }
     *     
     */
    public NearestNeighborModel setModelExplanation(
        @org.jpmml.model.Property("modelExplanation")
        ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    /**
     * Gets the value of the targets property.
     * 
     * @return
     *     possible object is
     *     {@link Targets }
     *     
     */
    public Targets getTargets() {
        return targets;
    }

    /**
     * Sets the value of the targets property.
     * 
     * @param targets
     *     allowed object is
     *     {@link Targets }
     *     
     */
    public NearestNeighborModel setTargets(
        @org.jpmml.model.Property("targets")
        Targets targets) {
        this.targets = targets;
        return this;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param localTransformations
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public NearestNeighborModel setLocalTransformations(
        @org.jpmml.model.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    /**
     * Gets the value of the trainingInstances property.
     * 
     * @return
     *     possible object is
     *     {@link TrainingInstances }
     *     
     */
    public TrainingInstances getTrainingInstances() {
        return trainingInstances;
    }

    /**
     * Sets the value of the trainingInstances property.
     * 
     * @param trainingInstances
     *     allowed object is
     *     {@link TrainingInstances }
     *     
     */
    public NearestNeighborModel setTrainingInstances(
        @org.jpmml.model.Property("trainingInstances")
        TrainingInstances trainingInstances) {
        this.trainingInstances = trainingInstances;
        return this;
    }

    /**
     * Gets the value of the comparisonMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link ComparisonMeasure }
     *     
     */
    public ComparisonMeasure getComparisonMeasure() {
        return comparisonMeasure;
    }

    /**
     * Sets the value of the comparisonMeasure property.
     * 
     * @param comparisonMeasure
     *     allowed object is
     *     {@link ComparisonMeasure }
     *     
     */
    public NearestNeighborModel setComparisonMeasure(
        @org.jpmml.model.Property("comparisonMeasure")
        ComparisonMeasure comparisonMeasure) {
        this.comparisonMeasure = comparisonMeasure;
        return this;
    }

    /**
     * Gets the value of the knnInputs property.
     * 
     * @return
     *     possible object is
     *     {@link KNNInputs }
     *     
     */
    public KNNInputs getKNNInputs() {
        return knnInputs;
    }

    /**
     * Sets the value of the knnInputs property.
     * 
     * @param knnInputs
     *     allowed object is
     *     {@link KNNInputs }
     *     
     */
    public NearestNeighborModel setKNNInputs(
        @org.jpmml.model.Property("knnInputs")
        KNNInputs knnInputs) {
        this.knnInputs = knnInputs;
        return this;
    }

    /**
     * Gets the value of the modelVerification property.
     * 
     * @return
     *     possible object is
     *     {@link ModelVerification }
     *     
     */
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    /**
     * Sets the value of the modelVerification property.
     * 
     * @param modelVerification
     *     allowed object is
     *     {@link ModelVerification }
     *     
     */
    public NearestNeighborModel setModelVerification(
        @org.jpmml.model.Property("modelVerification")
        ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public NearestNeighborModel addExtensions(org.dmg.pmml.Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getModelExplanation(), getTargets(), getLocalTransformations(), getTrainingInstances(), getComparisonMeasure(), getKNNInputs(), getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="majorityVote"/>
     *     &lt;enumeration value="weightedMajorityVote"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    @Added(Version.PMML_4_1)
    public enum CategoricalScoringMethod {

        @XmlEnumValue("majorityVote")
        MAJORITY_VOTE("majorityVote"),
        @XmlEnumValue("weightedMajorityVote")
        WEIGHTED_MAJORITY_VOTE("weightedMajorityVote");
        private final String value;

        CategoricalScoringMethod(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static NearestNeighborModel.CategoricalScoringMethod fromValue(String v) {
            for (NearestNeighborModel.CategoricalScoringMethod c: NearestNeighborModel.CategoricalScoringMethod.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="median"/>
     *     &lt;enumeration value="average"/>
     *     &lt;enumeration value="weightedAverage"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    @Added(Version.PMML_4_1)
    public enum ContinuousScoringMethod {

        @XmlEnumValue("median")
        MEDIAN("median"),
        @XmlEnumValue("average")
        AVERAGE("average"),
        @XmlEnumValue("weightedAverage")
        WEIGHTED_AVERAGE("weightedAverage");
        private final String value;

        ContinuousScoringMethod(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static NearestNeighborModel.ContinuousScoringMethod fromValue(String v) {
            for (NearestNeighborModel.ContinuousScoringMethod c: NearestNeighborModel.ContinuousScoringMethod.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
