
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.model.Property;


/**
 * <p>Java class for REAL-SparseArray element declaration.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;element name="REAL-SparseArray">
 *   &lt;complexType>
 *     &lt;complexContent>
 *       &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *         &lt;sequence>
 *           &lt;element ref="{http://www.dmg.org/PMML-4_3}Indices" minOccurs="0"/>
 *           &lt;element ref="{http://www.dmg.org/PMML-4_3}REAL-Entries" minOccurs="0"/>
 *         &lt;/sequence>
 *         &lt;attribute name="n" type="{http://www.dmg.org/PMML-4_3}INT-NUMBER" />
 *         &lt;attribute name="defaultValue" type="{http://www.dmg.org/PMML-4_3}REAL-NUMBER" default="0" />
 *       &lt;/restriction>
 *     &lt;/complexContent>
 *   &lt;/complexType>
 * &lt;/element>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "indices",
    "entries"
})
@XmlRootElement(name = "REAL-SparseArray", namespace = "http://www.dmg.org/PMML-4_3")
public class RealSparseArray
    extends SparseArray<Double>
{

    @XmlAttribute(name = "n")
    private Integer n;
    @XmlAttribute(name = "defaultValue")
    private Double defaultValue;
    @XmlList
    @XmlElement(name = "Indices", namespace = "http://www.dmg.org/PMML-4_3", type = Integer.class)
    private List<Integer> indices;
    @XmlList
    @XmlElement(name = "REAL-Entries", namespace = "http://www.dmg.org/PMML-4_3", type = Double.class)
    private List<Double> entries;
    private final static Double DEFAULT_DEFAULT_VALUE = 0.0D;
    private final static long serialVersionUID = 67305478L;

    /**
     * Gets the value of the n property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public Integer getN() {
        return n;
    }

    /**
     * Sets the value of the n property.
     * 
     * @param n
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public RealSparseArray setN(
        @Property("n")
        Integer n) {
        this.n = n;
        return this;
    }

    /**
     * Gets the value of the defaultValue property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getDefaultValue() {
        if (defaultValue == null) {
            return DEFAULT_DEFAULT_VALUE;
        } else {
            return defaultValue;
        }
    }

    /**
     * Sets the value of the defaultValue property.
     * 
     * @param defaultValue
     *     allowed object is
     *     {@link Double }
     *     
     */
    public RealSparseArray setDefaultValue(
        @Property("defaultValue")
        Double defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    /**
     * Gets the value of the indices property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the indices property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIndices().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Integer }
     * 
     * 
     */
    public List<Integer> getIndices() {
        if (indices == null) {
            indices = new ArrayList<Integer>();
        }
        return this.indices;
    }

    /**
     * Gets the value of the entries property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the entries property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getEntries().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Double }
     * 
     * 
     */
    public List<Double> getEntries() {
        if (entries == null) {
            entries = new ArrayList<Double>();
        }
        return this.entries;
    }

    public boolean hasIndices() {
        return ((this.indices!= null)&&(this.indices.size()> 0));
    }

    public RealSparseArray addIndices(Integer... indices) {
        getIndices().addAll(Arrays.asList(indices));
        return this;
    }

    public boolean hasEntries() {
        return ((this.entries!= null)&&(this.entries.size()> 0));
    }

    public RealSparseArray addEntries(Double... entries) {
        getEntries().addAll(Arrays.asList(entries));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
