
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.Property;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Counts" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}NumericInfo" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}DiscrStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}ContStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Anova" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="field" type="{http://www.dmg.org/PMML-4_3}FIELD-NAME" />
 *       &lt;attribute name="weighted" default="0">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="0"/>
 *             &lt;enumeration value="1"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "counts",
    "numericInfo",
    "discrStats",
    "contStats",
    "anova"
})
@XmlRootElement(name = "UnivariateStats", namespace = "http://www.dmg.org/PMML-4_3")
public class UnivariateStats
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<UnivariateStats>
{

    @XmlAttribute(name = "field")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName field;
    @XmlAttribute(name = "weighted")
    @Added(Version.PMML_4_0)
    private UnivariateStats.Weighted weighted;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "Counts", namespace = "http://www.dmg.org/PMML-4_3")
    private Counts counts;
    @XmlElement(name = "NumericInfo", namespace = "http://www.dmg.org/PMML-4_3")
    private NumericInfo numericInfo;
    @XmlElement(name = "DiscrStats", namespace = "http://www.dmg.org/PMML-4_3")
    private DiscrStats discrStats;
    @XmlElement(name = "ContStats", namespace = "http://www.dmg.org/PMML-4_3")
    private ContStats contStats;
    @XmlElement(name = "Anova", namespace = "http://www.dmg.org/PMML-4_3")
    @Added(Version.PMML_4_0)
    private Anova anova;
    private final static long serialVersionUID = 67305478L;

    /**
     * Gets the value of the field property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getField() {
        return field;
    }

    /**
     * Sets the value of the field property.
     * 
     * @param field
     *     allowed object is
     *     {@link String }
     *     
     */
    public UnivariateStats setField(
        @Property("field")
        FieldName field) {
        this.field = field;
        return this;
    }

    /**
     * Gets the value of the weighted property.
     * 
     * @return
     *     possible object is
     *     {@link UnivariateStats.Weighted }
     *     
     */
    public UnivariateStats.Weighted getWeighted() {
        if (weighted == null) {
            return UnivariateStats.Weighted.ZERO;
        } else {
            return weighted;
        }
    }

    /**
     * Sets the value of the weighted property.
     * 
     * @param weighted
     *     allowed object is
     *     {@link UnivariateStats.Weighted }
     *     
     */
    public UnivariateStats setWeighted(
        @Property("weighted")
        UnivariateStats.Weighted weighted) {
        this.weighted = weighted;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the counts property.
     * 
     * @return
     *     possible object is
     *     {@link Counts }
     *     
     */
    public Counts getCounts() {
        return counts;
    }

    /**
     * Sets the value of the counts property.
     * 
     * @param counts
     *     allowed object is
     *     {@link Counts }
     *     
     */
    public UnivariateStats setCounts(
        @Property("counts")
        Counts counts) {
        this.counts = counts;
        return this;
    }

    /**
     * Gets the value of the numericInfo property.
     * 
     * @return
     *     possible object is
     *     {@link NumericInfo }
     *     
     */
    public NumericInfo getNumericInfo() {
        return numericInfo;
    }

    /**
     * Sets the value of the numericInfo property.
     * 
     * @param numericInfo
     *     allowed object is
     *     {@link NumericInfo }
     *     
     */
    public UnivariateStats setNumericInfo(
        @Property("numericInfo")
        NumericInfo numericInfo) {
        this.numericInfo = numericInfo;
        return this;
    }

    /**
     * Gets the value of the discrStats property.
     * 
     * @return
     *     possible object is
     *     {@link DiscrStats }
     *     
     */
    public DiscrStats getDiscrStats() {
        return discrStats;
    }

    /**
     * Sets the value of the discrStats property.
     * 
     * @param discrStats
     *     allowed object is
     *     {@link DiscrStats }
     *     
     */
    public UnivariateStats setDiscrStats(
        @Property("discrStats")
        DiscrStats discrStats) {
        this.discrStats = discrStats;
        return this;
    }

    /**
     * Gets the value of the contStats property.
     * 
     * @return
     *     possible object is
     *     {@link ContStats }
     *     
     */
    public ContStats getContStats() {
        return contStats;
    }

    /**
     * Sets the value of the contStats property.
     * 
     * @param contStats
     *     allowed object is
     *     {@link ContStats }
     *     
     */
    public UnivariateStats setContStats(
        @Property("contStats")
        ContStats contStats) {
        this.contStats = contStats;
        return this;
    }

    /**
     * Gets the value of the anova property.
     * 
     * @return
     *     possible object is
     *     {@link Anova }
     *     
     */
    public Anova getAnova() {
        return anova;
    }

    /**
     * Sets the value of the anova property.
     * 
     * @param anova
     *     allowed object is
     *     {@link Anova }
     *     
     */
    public UnivariateStats setAnova(
        @Property("anova")
        Anova anova) {
        this.anova = anova;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public UnivariateStats addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getCounts(), getNumericInfo(), getDiscrStats(), getContStats(), getAnova());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="0"/>
     *     &lt;enumeration value="1"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    @Added(Version.PMML_4_0)
    public enum Weighted {

        @XmlEnumValue("0")
        ZERO("0"),
        @XmlEnumValue("1")
        ONE("1");
        private final String value;

        Weighted(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static UnivariateStats.Weighted fromValue(String v) {
            for (UnivariateStats.Weighted c: UnivariateStats.Weighted.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
