
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.association.AssociationModel;
import org.dmg.pmml.baseline.BaselineModel;
import org.dmg.pmml.bayesian_network.BayesianNetworkModel;
import org.dmg.pmml.clustering.ClusteringModel;
import org.dmg.pmml.gaussian_process.GaussianProcessModel;
import org.dmg.pmml.general_regression.GeneralRegressionModel;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.naive_bayes.NaiveBayesModel;
import org.dmg.pmml.nearest_neighbor.NearestNeighborModel;
import org.dmg.pmml.neural_network.NeuralNetwork;
import org.dmg.pmml.regression.RegressionModel;
import org.dmg.pmml.rule_set.RuleSetModel;
import org.dmg.pmml.scorecard.Scorecard;
import org.dmg.pmml.sequence.SequenceModel;
import org.dmg.pmml.support_vector_machine.SupportVectorMachineModel;
import org.dmg.pmml.text.TextModel;
import org.dmg.pmml.time_series.TimeSeriesModel;
import org.dmg.pmml.tree.TreeModel;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Header"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}MiningBuildTask" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}DataDictionary"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}TransformationDictionary" minOccurs="0"/>
 *         &lt;sequence maxOccurs="unbounded" minOccurs="0">
 *           &lt;group ref="{http://www.dmg.org/PMML-4_3}MODEL-ELEMENT"/>
 *         &lt;/sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="version" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="x-baseVersion" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "header",
    "miningBuildTask",
    "dataDictionary",
    "transformationDictionary",
    "models",
    "extensions"
})
@XmlRootElement(name = "PMML", namespace = "http://www.dmg.org/PMML-4_3")
public class PMML
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<PMML>
{

    @XmlAttribute(name = "version", required = true)
    private String version;
    @XmlAttribute(name = "x-baseVersion")
    @org.jpmml.schema.Extension
    private String baseVersion;
    @XmlElement(name = "Header", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private Header header;
    @XmlElement(name = "MiningBuildTask", namespace = "http://www.dmg.org/PMML-4_3")
    private MiningBuildTask miningBuildTask;
    @XmlElement(name = "DataDictionary", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private DataDictionary dataDictionary;
    @XmlElement(name = "TransformationDictionary", namespace = "http://www.dmg.org/PMML-4_3")
    private TransformationDictionary transformationDictionary;
    @XmlElements({
        @XmlElement(name = "AssociationModel", namespace = "http://www.dmg.org/PMML-4_3", type = AssociationModel.class),
        @XmlElement(name = "BayesianNetworkModel", namespace = "http://www.dmg.org/PMML-4_3", type = BayesianNetworkModel.class),
        @XmlElement(name = "BaselineModel", namespace = "http://www.dmg.org/PMML-4_3", type = BaselineModel.class),
        @XmlElement(name = "ClusteringModel", namespace = "http://www.dmg.org/PMML-4_3", type = ClusteringModel.class),
        @XmlElement(name = "GaussianProcessModel", namespace = "http://www.dmg.org/PMML-4_3", type = GaussianProcessModel.class),
        @XmlElement(name = "GeneralRegressionModel", namespace = "http://www.dmg.org/PMML-4_3", type = GeneralRegressionModel.class),
        @XmlElement(name = "MiningModel", namespace = "http://www.dmg.org/PMML-4_3", type = MiningModel.class),
        @XmlElement(name = "NaiveBayesModel", namespace = "http://www.dmg.org/PMML-4_3", type = NaiveBayesModel.class),
        @XmlElement(name = "NearestNeighborModel", namespace = "http://www.dmg.org/PMML-4_3", type = NearestNeighborModel.class),
        @XmlElement(name = "NeuralNetwork", namespace = "http://www.dmg.org/PMML-4_3", type = NeuralNetwork.class),
        @XmlElement(name = "RegressionModel", namespace = "http://www.dmg.org/PMML-4_3", type = RegressionModel.class),
        @XmlElement(name = "RuleSetModel", namespace = "http://www.dmg.org/PMML-4_3", type = RuleSetModel.class),
        @XmlElement(name = "SequenceModel", namespace = "http://www.dmg.org/PMML-4_3", type = SequenceModel.class),
        @XmlElement(name = "Scorecard", namespace = "http://www.dmg.org/PMML-4_3", type = Scorecard.class),
        @XmlElement(name = "SupportVectorMachineModel", namespace = "http://www.dmg.org/PMML-4_3", type = SupportVectorMachineModel.class),
        @XmlElement(name = "TextModel", namespace = "http://www.dmg.org/PMML-4_3", type = TextModel.class),
        @XmlElement(name = "TimeSeriesModel", namespace = "http://www.dmg.org/PMML-4_3", type = TimeSeriesModel.class),
        @XmlElement(name = "TreeModel", namespace = "http://www.dmg.org/PMML-4_3", type = TreeModel.class)
    })
    private List<Model> models;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<org.dmg.pmml.Extension> extensions;
    private final static long serialVersionUID = 67305479L;

    public PMML() {
    }

    public PMML(
        @org.jpmml.model.Property("version")
        String version,
        @org.jpmml.model.Property("header")
        Header header,
        @org.jpmml.model.Property("dataDictionary")
        DataDictionary dataDictionary) {
        this.version = version;
        this.header = header;
        this.dataDictionary = dataDictionary;
    }

    /**
     * Gets the value of the version property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getVersion() {
        return version;
    }

    /**
     * Sets the value of the version property.
     * 
     * @param version
     *     allowed object is
     *     {@link String }
     *     
     */
    public PMML setVersion(
        @org.jpmml.model.Property("version")
        String version) {
        this.version = version;
        return this;
    }

    /**
     * Gets the value of the baseVersion property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBaseVersion() {
        return baseVersion;
    }

    /**
     * Sets the value of the baseVersion property.
     * 
     * @param baseVersion
     *     allowed object is
     *     {@link String }
     *     
     */
    public PMML setBaseVersion(
        @org.jpmml.model.Property("baseVersion")
        String baseVersion) {
        this.baseVersion = baseVersion;
        return this;
    }

    /**
     * Gets the value of the header property.
     * 
     * @return
     *     possible object is
     *     {@link Header }
     *     
     */
    public Header getHeader() {
        return header;
    }

    /**
     * Sets the value of the header property.
     * 
     * @param header
     *     allowed object is
     *     {@link Header }
     *     
     */
    public PMML setHeader(
        @org.jpmml.model.Property("header")
        Header header) {
        this.header = header;
        return this;
    }

    /**
     * Gets the value of the miningBuildTask property.
     * 
     * @return
     *     possible object is
     *     {@link MiningBuildTask }
     *     
     */
    public MiningBuildTask getMiningBuildTask() {
        return miningBuildTask;
    }

    /**
     * Sets the value of the miningBuildTask property.
     * 
     * @param miningBuildTask
     *     allowed object is
     *     {@link MiningBuildTask }
     *     
     */
    public PMML setMiningBuildTask(
        @org.jpmml.model.Property("miningBuildTask")
        MiningBuildTask miningBuildTask) {
        this.miningBuildTask = miningBuildTask;
        return this;
    }

    /**
     * Gets the value of the dataDictionary property.
     * 
     * @return
     *     possible object is
     *     {@link DataDictionary }
     *     
     */
    public DataDictionary getDataDictionary() {
        return dataDictionary;
    }

    /**
     * Sets the value of the dataDictionary property.
     * 
     * @param dataDictionary
     *     allowed object is
     *     {@link DataDictionary }
     *     
     */
    public PMML setDataDictionary(
        @org.jpmml.model.Property("dataDictionary")
        DataDictionary dataDictionary) {
        this.dataDictionary = dataDictionary;
        return this;
    }

    /**
     * Gets the value of the transformationDictionary property.
     * 
     * @return
     *     possible object is
     *     {@link TransformationDictionary }
     *     
     */
    public TransformationDictionary getTransformationDictionary() {
        return transformationDictionary;
    }

    /**
     * Sets the value of the transformationDictionary property.
     * 
     * @param transformationDictionary
     *     allowed object is
     *     {@link TransformationDictionary }
     *     
     */
    public PMML setTransformationDictionary(
        @org.jpmml.model.Property("transformationDictionary")
        TransformationDictionary transformationDictionary) {
        this.transformationDictionary = transformationDictionary;
        return this;
    }

    /**
     * Gets the value of the models property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the models property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getModels().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AssociationModel }
     * {@link BayesianNetworkModel }
     * {@link BaselineModel }
     * {@link ClusteringModel }
     * {@link GaussianProcessModel }
     * {@link GeneralRegressionModel }
     * {@link MiningModel }
     * {@link NaiveBayesModel }
     * {@link NearestNeighborModel }
     * {@link NeuralNetwork }
     * {@link RegressionModel }
     * {@link RuleSetModel }
     * {@link SequenceModel }
     * {@link Scorecard }
     * {@link SupportVectorMachineModel }
     * {@link TextModel }
     * {@link TimeSeriesModel }
     * {@link TreeModel }
     * 
     * 
     */
    public List<Model> getModels() {
        if (models == null) {
            models = new ArrayList<Model>();
        }
        return this.models;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link org.dmg.pmml.Extension }
     * 
     * 
     */
    public List<org.dmg.pmml.Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<org.dmg.pmml.Extension>();
        }
        return this.extensions;
    }

    public boolean hasModels() {
        return ((this.models!= null)&&(this.models.size()> 0));
    }

    public PMML addModels(Model... models) {
        getModels().addAll(Arrays.asList(models));
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public PMML addExtensions(org.dmg.pmml.Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getHeader(), getMiningBuildTask(), getDataDictionary(), getTransformationDictionary());
            }
            if ((status == VisitorAction.CONTINUE)&&hasModels()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getModels());
            }
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
