
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Counts" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}NumericInfo" minOccurs="0"/>
 *         &lt;group ref="{http://www.dmg.org/PMML-4_3}FrequenciesType" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="field" use="required" type="{http://www.dmg.org/PMML-4_3}FIELD-NAME" />
 *       &lt;attribute name="weighted" default="0">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="0"/>
 *             &lt;enumeration value="1"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "counts",
    "numericInfo",
    "arrays"
})
@XmlRootElement(name = "PartitionFieldStats", namespace = "http://www.dmg.org/PMML-4_3")
public class PartitionFieldStats
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<PartitionFieldStats>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName field;
    @XmlAttribute(name = "weighted")
    @Added(Version.PMML_4_0)
    private PartitionFieldStats.Weighted weighted;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "Counts", namespace = "http://www.dmg.org/PMML-4_3")
    private Counts counts;
    @XmlElement(name = "NumericInfo", namespace = "http://www.dmg.org/PMML-4_3")
    private NumericInfo numericInfo;
    @XmlElement(name = "Array", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Array> arrays;
    private final static long serialVersionUID = 67305479L;

    public PartitionFieldStats() {
    }

    public PartitionFieldStats(
        @org.jpmml.model.Property("field")
        FieldName field) {
        this.field = field;
    }

    /**
     * Gets the value of the field property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FieldName getField() {
        return field;
    }

    /**
     * Sets the value of the field property.
     * 
     * @param field
     *     allowed object is
     *     {@link String }
     *     
     */
    public PartitionFieldStats setField(
        @org.jpmml.model.Property("field")
        FieldName field) {
        this.field = field;
        return this;
    }

    /**
     * Gets the value of the weighted property.
     * 
     * @return
     *     possible object is
     *     {@link PartitionFieldStats.Weighted }
     *     
     */
    public PartitionFieldStats.Weighted getWeighted() {
        if (weighted == null) {
            return PartitionFieldStats.Weighted.ZERO;
        } else {
            return weighted;
        }
    }

    /**
     * Sets the value of the weighted property.
     * 
     * @param weighted
     *     allowed object is
     *     {@link PartitionFieldStats.Weighted }
     *     
     */
    public PartitionFieldStats setWeighted(
        @org.jpmml.model.Property("weighted")
        PartitionFieldStats.Weighted weighted) {
        this.weighted = weighted;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the counts property.
     * 
     * @return
     *     possible object is
     *     {@link Counts }
     *     
     */
    public Counts getCounts() {
        return counts;
    }

    /**
     * Sets the value of the counts property.
     * 
     * @param counts
     *     allowed object is
     *     {@link Counts }
     *     
     */
    public PartitionFieldStats setCounts(
        @org.jpmml.model.Property("counts")
        Counts counts) {
        this.counts = counts;
        return this;
    }

    /**
     * Gets the value of the numericInfo property.
     * 
     * @return
     *     possible object is
     *     {@link NumericInfo }
     *     
     */
    public NumericInfo getNumericInfo() {
        return numericInfo;
    }

    /**
     * Sets the value of the numericInfo property.
     * 
     * @param numericInfo
     *     allowed object is
     *     {@link NumericInfo }
     *     
     */
    public PartitionFieldStats setNumericInfo(
        @org.jpmml.model.Property("numericInfo")
        NumericInfo numericInfo) {
        this.numericInfo = numericInfo;
        return this;
    }

    /**
     * Gets the value of the arrays property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the arrays property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getArrays().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Array }
     * 
     * 
     */
    public List<Array> getArrays() {
        if (arrays == null) {
            arrays = new ArrayList<Array>();
        }
        return this.arrays;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public PartitionFieldStats addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasArrays() {
        return ((this.arrays!= null)&&(this.arrays.size()> 0));
    }

    public PartitionFieldStats addArrays(Array... arrays) {
        getArrays().addAll(Arrays.asList(arrays));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getCounts(), getNumericInfo());
            }
            if ((status == VisitorAction.CONTINUE)&&hasArrays()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getArrays());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="0"/>
     *     &lt;enumeration value="1"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    @Added(Version.PMML_4_0)
    public enum Weighted {

        @XmlEnumValue("0")
        ZERO("0"),
        @XmlEnumValue("1")
        ONE("1");
        private final String value;

        Weighted(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static PartitionFieldStats.Weighted fromValue(String v) {
            for (PartitionFieldStats.Weighted c: PartitionFieldStats.Weighted.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
