
package org.dmg.pmml.sequence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;group ref="{http://www.dmg.org/PMML-4_3}SEQUENCE"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "sequenceReference",
    "time"
})
@XmlRootElement(name = "AntecedentSequence", namespace = "http://www.dmg.org/PMML-4_3")
public class AntecedentSequence
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<AntecedentSequence>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "SequenceReference", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private SequenceReference sequenceReference;
    @XmlElement(name = "Time", namespace = "http://www.dmg.org/PMML-4_3")
    private Time time;
    private final static long serialVersionUID = 67305479L;

    public AntecedentSequence() {
    }

    public AntecedentSequence(
        @org.jpmml.model.Property("sequenceReference")
        SequenceReference sequenceReference) {
        this.sequenceReference = sequenceReference;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the sequenceReference property.
     * 
     * @return
     *     possible object is
     *     {@link SequenceReference }
     *     
     */
    public SequenceReference getSequenceReference() {
        return sequenceReference;
    }

    /**
     * Sets the value of the sequenceReference property.
     * 
     * @param sequenceReference
     *     allowed object is
     *     {@link SequenceReference }
     *     
     */
    public AntecedentSequence setSequenceReference(
        @org.jpmml.model.Property("sequenceReference")
        SequenceReference sequenceReference) {
        this.sequenceReference = sequenceReference;
        return this;
    }

    /**
     * Gets the value of the time property.
     * 
     * @return
     *     possible object is
     *     {@link Time }
     *     
     */
    public Time getTime() {
        return time;
    }

    /**
     * Sets the value of the time property.
     * 
     * @param time
     *     allowed object is
     *     {@link Time }
     *     
     */
    public AntecedentSequence setTime(
        @org.jpmml.model.Property("time")
        Time time) {
        this.time = time;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public AntecedentSequence addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getSequenceReference(), getTime());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
