
package org.dmg.pmml.support_vector_machine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.schema.Added;
import org.jpmml.schema.Removed;
import org.jpmml.schema.Required;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}MiningSchema"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Output" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}ModelStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}ModelExplanation" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Targets" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}LocalTransformations" minOccurs="0"/>
 *         &lt;sequence>
 *           &lt;choice>
 *             &lt;element ref="{http://www.dmg.org/PMML-4_3}LinearKernelType"/>
 *             &lt;element ref="{http://www.dmg.org/PMML-4_3}PolynomialKernelType"/>
 *             &lt;element ref="{http://www.dmg.org/PMML-4_3}RadialBasisKernelType"/>
 *             &lt;element ref="{http://www.dmg.org/PMML-4_3}SigmoidKernelType"/>
 *           &lt;/choice>
 *         &lt;/sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}VectorDictionary"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}SupportVectorMachine" maxOccurs="unbounded"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}ModelVerification" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="modelName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="functionName" use="required" type="{http://www.dmg.org/PMML-4_3}MINING-FUNCTION" />
 *       &lt;attribute name="algorithmName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="threshold" type="{http://www.dmg.org/PMML-4_3}REAL-NUMBER" default="0" />
 *       &lt;attribute name="svmRepresentation" default="SupportVectors">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="SupportVectors"/>
 *             &lt;enumeration value="Coefficients"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="alternateBinaryTargetCategory" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="classificationMethod" default="OneAgainstAll">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="OneAgainstAll"/>
 *             &lt;enumeration value="OneAgainstOne"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="maxWins" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       &lt;attribute name="isScorable" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       &lt;attribute name="x-mathContext" type="{http://www.dmg.org/PMML-4_3}MATH-CONTEXT" default="double" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "kernel",
    "vectorDictionary",
    "supportVectorMachines",
    "modelVerification"
})
@XmlRootElement(name = "SupportVectorMachineModel", namespace = "http://www.dmg.org/PMML-4_3")
public class SupportVectorMachineModel
    extends Model
    implements HasExtensions<SupportVectorMachineModel>
{

    @XmlAttribute(name = "modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "threshold")
    @Added(Version.PMML_4_0)
    private Double threshold;
    @XmlAttribute(name = "svmRepresentation")
    private SupportVectorMachineModel.Representation representation;
    @XmlAttribute(name = "alternateBinaryTargetCategory")
    @Added(Version.PMML_3_1)
    @Removed(Version.PMML_4_0)
    private String alternateBinaryTargetCategory;
    @XmlAttribute(name = "classificationMethod")
    @Added(Version.PMML_4_0)
    private SupportVectorMachineModel.ClassificationMethod classificationMethod;
    @XmlAttribute(name = "maxWins")
    @Added(Version.PMML_4_3)
    private Boolean maxWins;
    @XmlAttribute(name = "isScorable")
    @Added(Version.PMML_4_1)
    private Boolean scorable;
    @XmlAttribute(name = "x-mathContext")
    @org.jpmml.schema.Extension
    private MathContext mathContext;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<org.dmg.pmml.Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_3")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_3")
    private ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_3")
    @Added(Version.PMML_4_0)
    private ModelExplanation modelExplanation;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_3")
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_3")
    private LocalTransformations localTransformations;
    @XmlElements({
        @XmlElement(name = "LinearKernelType", namespace = "http://www.dmg.org/PMML-4_3", type = LinearKernel.class),
        @XmlElement(name = "PolynomialKernelType", namespace = "http://www.dmg.org/PMML-4_3", type = PolynomialKernel.class),
        @XmlElement(name = "RadialBasisKernelType", namespace = "http://www.dmg.org/PMML-4_3", type = RadialBasisKernel.class),
        @XmlElement(name = "SigmoidKernelType", namespace = "http://www.dmg.org/PMML-4_3", type = SigmoidKernel.class)
    })
    private Kernel kernel;
    @XmlElement(name = "VectorDictionary", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    @Required(Version.PMML_3_1)
    private VectorDictionary vectorDictionary;
    @XmlElement(name = "SupportVectorMachine", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private List<SupportVectorMachine> supportVectorMachines;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_3")
    private ModelVerification modelVerification;
    private final static Double DEFAULT_THRESHOLD = 0.0D;
    private final static Boolean DEFAULT_MAX_WINS = false;
    private final static Boolean DEFAULT_SCORABLE = true;
    private final static long serialVersionUID = 67305479L;

    public SupportVectorMachineModel() {
    }

    public SupportVectorMachineModel(
        @org.jpmml.model.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.Property("miningSchema")
        MiningSchema miningSchema,
        @org.jpmml.model.Property("vectorDictionary")
        VectorDictionary vectorDictionary,
        @org.jpmml.model.Property("supportVectorMachines")
        List<SupportVectorMachine> supportVectorMachines) {
        this.miningFunction = miningFunction;
        this.miningSchema = miningSchema;
        this.vectorDictionary = vectorDictionary;
        this.supportVectorMachines = supportVectorMachines;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Sets the value of the modelName property.
     * 
     * @param modelName
     *     allowed object is
     *     {@link String }
     *     
     */
    public SupportVectorMachineModel setModelName(
        @org.jpmml.model.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    /**
     * Gets the value of the miningFunction property.
     * 
     * @return
     *     possible object is
     *     {@link MiningFunction }
     *     
     */
    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    /**
     * Sets the value of the miningFunction property.
     * 
     * @param miningFunction
     *     allowed object is
     *     {@link MiningFunction }
     *     
     */
    public SupportVectorMachineModel setMiningFunction(
        @org.jpmml.model.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    /**
     * Gets the value of the algorithmName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithmName() {
        return algorithmName;
    }

    /**
     * Sets the value of the algorithmName property.
     * 
     * @param algorithmName
     *     allowed object is
     *     {@link String }
     *     
     */
    public SupportVectorMachineModel setAlgorithmName(
        @org.jpmml.model.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    /**
     * Gets the value of the threshold property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getThreshold() {
        if (threshold == null) {
            return DEFAULT_THRESHOLD;
        } else {
            return threshold;
        }
    }

    /**
     * Sets the value of the threshold property.
     * 
     * @param threshold
     *     allowed object is
     *     {@link Double }
     *     
     */
    public SupportVectorMachineModel setThreshold(
        @org.jpmml.model.Property("threshold")
        Double threshold) {
        this.threshold = threshold;
        return this;
    }

    /**
     * Gets the value of the representation property.
     * 
     * @return
     *     possible object is
     *     {@link SupportVectorMachineModel.Representation }
     *     
     */
    public SupportVectorMachineModel.Representation getRepresentation() {
        if (representation == null) {
            return SupportVectorMachineModel.Representation.SUPPORT_VECTORS;
        } else {
            return representation;
        }
    }

    /**
     * Sets the value of the representation property.
     * 
     * @param representation
     *     allowed object is
     *     {@link SupportVectorMachineModel.Representation }
     *     
     */
    public SupportVectorMachineModel setRepresentation(
        @org.jpmml.model.Property("representation")
        SupportVectorMachineModel.Representation representation) {
        this.representation = representation;
        return this;
    }

    /**
     * Gets the value of the alternateBinaryTargetCategory property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlternateBinaryTargetCategory() {
        return alternateBinaryTargetCategory;
    }

    /**
     * Sets the value of the alternateBinaryTargetCategory property.
     * 
     * @param alternateBinaryTargetCategory
     *     allowed object is
     *     {@link String }
     *     
     */
    public SupportVectorMachineModel setAlternateBinaryTargetCategory(
        @org.jpmml.model.Property("alternateBinaryTargetCategory")
        String alternateBinaryTargetCategory) {
        this.alternateBinaryTargetCategory = alternateBinaryTargetCategory;
        return this;
    }

    /**
     * Gets the value of the classificationMethod property.
     * 
     * @return
     *     possible object is
     *     {@link SupportVectorMachineModel.ClassificationMethod }
     *     
     */
    public SupportVectorMachineModel.ClassificationMethod getClassificationMethod() {
        if (classificationMethod == null) {
            return SupportVectorMachineModel.ClassificationMethod.ONE_AGAINST_ALL;
        } else {
            return classificationMethod;
        }
    }

    /**
     * Sets the value of the classificationMethod property.
     * 
     * @param classificationMethod
     *     allowed object is
     *     {@link SupportVectorMachineModel.ClassificationMethod }
     *     
     */
    public SupportVectorMachineModel setClassificationMethod(
        @org.jpmml.model.Property("classificationMethod")
        SupportVectorMachineModel.ClassificationMethod classificationMethod) {
        this.classificationMethod = classificationMethod;
        return this;
    }

    /**
     * Gets the value of the maxWins property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isMaxWins() {
        if (maxWins == null) {
            return DEFAULT_MAX_WINS;
        } else {
            return maxWins;
        }
    }

    /**
     * Sets the value of the maxWins property.
     * 
     * @param maxWins
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public SupportVectorMachineModel setMaxWins(
        @org.jpmml.model.Property("maxWins")
        Boolean maxWins) {
        this.maxWins = maxWins;
        return this;
    }

    /**
     * Gets the value of the scorable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    /**
     * Sets the value of the scorable property.
     * 
     * @param scorable
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public SupportVectorMachineModel setScorable(
        @org.jpmml.model.Property("scorable")
        Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    /**
     * Gets the value of the mathContext property.
     * 
     * @return
     *     possible object is
     *     {@link MathContext }
     *     
     */
    public MathContext getMathContext() {
        if (mathContext == null) {
            return MathContext.DOUBLE;
        } else {
            return mathContext;
        }
    }

    /**
     * Sets the value of the mathContext property.
     * 
     * @param mathContext
     *     allowed object is
     *     {@link MathContext }
     *     
     */
    public SupportVectorMachineModel setMathContext(
        @org.jpmml.model.Property("mathContext")
        MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link org.dmg.pmml.Extension }
     * 
     * 
     */
    public List<org.dmg.pmml.Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<org.dmg.pmml.Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the miningSchema property.
     * 
     * @return
     *     possible object is
     *     {@link MiningSchema }
     *     
     */
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    /**
     * Sets the value of the miningSchema property.
     * 
     * @param miningSchema
     *     allowed object is
     *     {@link MiningSchema }
     *     
     */
    public SupportVectorMachineModel setMiningSchema(
        @org.jpmml.model.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    /**
     * Gets the value of the output property.
     * 
     * @return
     *     possible object is
     *     {@link Output }
     *     
     */
    public Output getOutput() {
        return output;
    }

    /**
     * Sets the value of the output property.
     * 
     * @param output
     *     allowed object is
     *     {@link Output }
     *     
     */
    public SupportVectorMachineModel setOutput(
        @org.jpmml.model.Property("output")
        Output output) {
        this.output = output;
        return this;
    }

    /**
     * Gets the value of the modelStats property.
     * 
     * @return
     *     possible object is
     *     {@link ModelStats }
     *     
     */
    public ModelStats getModelStats() {
        return modelStats;
    }

    /**
     * Sets the value of the modelStats property.
     * 
     * @param modelStats
     *     allowed object is
     *     {@link ModelStats }
     *     
     */
    public SupportVectorMachineModel setModelStats(
        @org.jpmml.model.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    /**
     * Gets the value of the modelExplanation property.
     * 
     * @return
     *     possible object is
     *     {@link ModelExplanation }
     *     
     */
    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    /**
     * Sets the value of the modelExplanation property.
     * 
     * @param modelExplanation
     *     allowed object is
     *     {@link ModelExplanation }
     *     
     */
    public SupportVectorMachineModel setModelExplanation(
        @org.jpmml.model.Property("modelExplanation")
        ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    /**
     * Gets the value of the targets property.
     * 
     * @return
     *     possible object is
     *     {@link Targets }
     *     
     */
    public Targets getTargets() {
        return targets;
    }

    /**
     * Sets the value of the targets property.
     * 
     * @param targets
     *     allowed object is
     *     {@link Targets }
     *     
     */
    public SupportVectorMachineModel setTargets(
        @org.jpmml.model.Property("targets")
        Targets targets) {
        this.targets = targets;
        return this;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param localTransformations
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public SupportVectorMachineModel setLocalTransformations(
        @org.jpmml.model.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    /**
     * Gets the value of the kernel property.
     * 
     * @return
     *     possible object is
     *     {@link LinearKernel }
     *     {@link PolynomialKernel }
     *     {@link RadialBasisKernel }
     *     {@link SigmoidKernel }
     *     
     */
    public Kernel getKernel() {
        return kernel;
    }

    /**
     * Sets the value of the kernel property.
     * 
     * @param kernel
     *     allowed object is
     *     {@link LinearKernel }
     *     {@link PolynomialKernel }
     *     {@link RadialBasisKernel }
     *     {@link SigmoidKernel }
     *     
     */
    public SupportVectorMachineModel setKernel(
        @org.jpmml.model.Property("kernel")
        Kernel kernel) {
        this.kernel = kernel;
        return this;
    }

    /**
     * Gets the value of the vectorDictionary property.
     * 
     * @return
     *     possible object is
     *     {@link VectorDictionary }
     *     
     */
    public VectorDictionary getVectorDictionary() {
        return vectorDictionary;
    }

    /**
     * Sets the value of the vectorDictionary property.
     * 
     * @param vectorDictionary
     *     allowed object is
     *     {@link VectorDictionary }
     *     
     */
    public SupportVectorMachineModel setVectorDictionary(
        @org.jpmml.model.Property("vectorDictionary")
        VectorDictionary vectorDictionary) {
        this.vectorDictionary = vectorDictionary;
        return this;
    }

    /**
     * Gets the value of the supportVectorMachines property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the supportVectorMachines property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSupportVectorMachines().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SupportVectorMachine }
     * 
     * 
     */
    public List<SupportVectorMachine> getSupportVectorMachines() {
        if (supportVectorMachines == null) {
            supportVectorMachines = new ArrayList<SupportVectorMachine>();
        }
        return this.supportVectorMachines;
    }

    /**
     * Gets the value of the modelVerification property.
     * 
     * @return
     *     possible object is
     *     {@link ModelVerification }
     *     
     */
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    /**
     * Sets the value of the modelVerification property.
     * 
     * @param modelVerification
     *     allowed object is
     *     {@link ModelVerification }
     *     
     */
    public SupportVectorMachineModel setModelVerification(
        @org.jpmml.model.Property("modelVerification")
        ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public SupportVectorMachineModel addExtensions(org.dmg.pmml.Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasSupportVectorMachines() {
        return ((this.supportVectorMachines!= null)&&(this.supportVectorMachines.size()> 0));
    }

    public SupportVectorMachineModel addSupportVectorMachines(SupportVectorMachine... supportVectorMachines) {
        getSupportVectorMachines().addAll(Arrays.asList(supportVectorMachines));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getModelExplanation(), getTargets(), getLocalTransformations(), getKernel(), getVectorDictionary());
            }
            if ((status == VisitorAction.CONTINUE)&&hasSupportVectorMachines()) {
                status = PMMLObject.traverse(visitor, getSupportVectorMachines());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="OneAgainstAll"/>
     *     &lt;enumeration value="OneAgainstOne"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    @Added(Version.PMML_4_0)
    public enum ClassificationMethod {

        @XmlEnumValue("OneAgainstAll")
        ONE_AGAINST_ALL("OneAgainstAll"),
        @XmlEnumValue("OneAgainstOne")
        ONE_AGAINST_ONE("OneAgainstOne");
        private final String value;

        ClassificationMethod(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static SupportVectorMachineModel.ClassificationMethod fromValue(String v) {
            for (SupportVectorMachineModel.ClassificationMethod c: SupportVectorMachineModel.ClassificationMethod.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="SupportVectors"/>
     *     &lt;enumeration value="Coefficients"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum Representation {

        @XmlEnumValue("SupportVectors")
        SUPPORT_VECTORS("SupportVectors"),
        @XmlEnumValue("Coefficients")
        COEFFICIENTS("Coefficients");
        private final String value;

        Representation(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static SupportVectorMachineModel.Representation fromValue(String v) {
            for (SupportVectorMachineModel.Representation c: SupportVectorMachineModel.Representation.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
