
package org.dmg.pmml.association;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}MiningSchema"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Output" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}ModelStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}LocalTransformations" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Item" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Itemset" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}AssociationRule" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}ModelVerification" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="modelName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="functionName" use="required" type="{http://www.dmg.org/PMML-4_3}MINING-FUNCTION" />
 *       &lt;attribute name="algorithmName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="numberOfTransactions" use="required" type="{http://www.dmg.org/PMML-4_3}INT-NUMBER" />
 *       &lt;attribute name="maxNumberOfItemsPerTA" type="{http://www.dmg.org/PMML-4_3}INT-NUMBER" />
 *       &lt;attribute name="avgNumberOfItemsPerTA" type="{http://www.dmg.org/PMML-4_3}REAL-NUMBER" />
 *       &lt;attribute name="minimumSupport" use="required" type="{http://www.dmg.org/PMML-4_3}PROB-NUMBER" />
 *       &lt;attribute name="minimumConfidence" use="required" type="{http://www.dmg.org/PMML-4_3}PROB-NUMBER" />
 *       &lt;attribute name="lengthLimit" type="{http://www.dmg.org/PMML-4_3}INT-NUMBER" />
 *       &lt;attribute name="numberOfItems" use="required" type="{http://www.dmg.org/PMML-4_3}INT-NUMBER" />
 *       &lt;attribute name="numberOfItemsets" use="required" type="{http://www.dmg.org/PMML-4_3}INT-NUMBER" />
 *       &lt;attribute name="numberOfRules" use="required" type="{http://www.dmg.org/PMML-4_3}INT-NUMBER" />
 *       &lt;attribute name="isScorable" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       &lt;attribute name="x-mathContext" type="{http://www.dmg.org/PMML-4_3}MATH-CONTEXT" default="double" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "localTransformations",
    "items",
    "itemsets",
    "associationRules",
    "modelVerification"
})
@XmlRootElement(name = "AssociationModel", namespace = "http://www.dmg.org/PMML-4_3")
public class AssociationModel
    extends Model
    implements HasExtensions<AssociationModel>
{

    @XmlAttribute(name = "modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "numberOfTransactions", required = true)
    private int numberOfTransactions;
    @XmlAttribute(name = "maxNumberOfItemsPerTA")
    private Integer maxNumberOfItemsPerTA;
    @XmlAttribute(name = "avgNumberOfItemsPerTA")
    private Double avgNumberOfItemsPerTA;
    @XmlAttribute(name = "minimumSupport", required = true)
    private double minimumSupport;
    @XmlAttribute(name = "minimumConfidence", required = true)
    private double minimumConfidence;
    @XmlAttribute(name = "lengthLimit")
    private Integer lengthLimit;
    @XmlAttribute(name = "numberOfItems", required = true)
    private int numberOfItems;
    @XmlAttribute(name = "numberOfItemsets", required = true)
    private int numberOfItemsets;
    @XmlAttribute(name = "numberOfRules", required = true)
    private int numberOfRules;
    @XmlAttribute(name = "isScorable")
    @Added(Version.PMML_4_1)
    private Boolean scorable;
    @XmlAttribute(name = "x-mathContext")
    @org.jpmml.schema.Extension
    private MathContext mathContext;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<org.dmg.pmml.Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_3")
    @Added(Version.PMML_4_0)
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_3")
    private ModelStats modelStats;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_3")
    private LocalTransformations localTransformations;
    @XmlElement(name = "Item", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Item> items;
    @XmlElement(name = "Itemset", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Itemset> itemsets;
    @XmlElement(name = "AssociationRule", namespace = "http://www.dmg.org/PMML-4_3")
    private List<AssociationRule> associationRules;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_3")
    @Added(Version.PMML_4_1)
    private ModelVerification modelVerification;
    private final static Boolean DEFAULT_SCORABLE = true;
    private final static long serialVersionUID = 67305479L;

    public AssociationModel() {
    }

    public AssociationModel(
        @org.jpmml.model.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.Property("numberOfTransactions")
        int numberOfTransactions,
        @org.jpmml.model.Property("minimumSupport")
        double minimumSupport,
        @org.jpmml.model.Property("minimumConfidence")
        double minimumConfidence,
        @org.jpmml.model.Property("numberOfItems")
        int numberOfItems,
        @org.jpmml.model.Property("numberOfItemsets")
        int numberOfItemsets,
        @org.jpmml.model.Property("numberOfRules")
        int numberOfRules,
        @org.jpmml.model.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningFunction = miningFunction;
        this.numberOfTransactions = numberOfTransactions;
        this.minimumSupport = minimumSupport;
        this.minimumConfidence = minimumConfidence;
        this.numberOfItems = numberOfItems;
        this.numberOfItemsets = numberOfItemsets;
        this.numberOfRules = numberOfRules;
        this.miningSchema = miningSchema;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Sets the value of the modelName property.
     * 
     * @param modelName
     *     allowed object is
     *     {@link String }
     *     
     */
    public AssociationModel setModelName(
        @org.jpmml.model.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    /**
     * Gets the value of the miningFunction property.
     * 
     * @return
     *     possible object is
     *     {@link MiningFunction }
     *     
     */
    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    /**
     * Sets the value of the miningFunction property.
     * 
     * @param miningFunction
     *     allowed object is
     *     {@link MiningFunction }
     *     
     */
    public AssociationModel setMiningFunction(
        @org.jpmml.model.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    /**
     * Gets the value of the algorithmName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithmName() {
        return algorithmName;
    }

    /**
     * Sets the value of the algorithmName property.
     * 
     * @param algorithmName
     *     allowed object is
     *     {@link String }
     *     
     */
    public AssociationModel setAlgorithmName(
        @org.jpmml.model.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    /**
     * Gets the value of the numberOfTransactions property.
     * 
     */
    public int getNumberOfTransactions() {
        return numberOfTransactions;
    }

    /**
     * Sets the value of the numberOfTransactions property.
     * 
     */
    public AssociationModel setNumberOfTransactions(
        @org.jpmml.model.Property("numberOfTransactions")
        int numberOfTransactions) {
        this.numberOfTransactions = numberOfTransactions;
        return this;
    }

    /**
     * Gets the value of the maxNumberOfItemsPerTA property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public Integer getMaxNumberOfItemsPerTA() {
        return maxNumberOfItemsPerTA;
    }

    /**
     * Sets the value of the maxNumberOfItemsPerTA property.
     * 
     * @param maxNumberOfItemsPerTA
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public AssociationModel setMaxNumberOfItemsPerTA(
        @org.jpmml.model.Property("maxNumberOfItemsPerTA")
        Integer maxNumberOfItemsPerTA) {
        this.maxNumberOfItemsPerTA = maxNumberOfItemsPerTA;
        return this;
    }

    /**
     * Gets the value of the avgNumberOfItemsPerTA property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getAvgNumberOfItemsPerTA() {
        return avgNumberOfItemsPerTA;
    }

    /**
     * Sets the value of the avgNumberOfItemsPerTA property.
     * 
     * @param avgNumberOfItemsPerTA
     *     allowed object is
     *     {@link Double }
     *     
     */
    public AssociationModel setAvgNumberOfItemsPerTA(
        @org.jpmml.model.Property("avgNumberOfItemsPerTA")
        Double avgNumberOfItemsPerTA) {
        this.avgNumberOfItemsPerTA = avgNumberOfItemsPerTA;
        return this;
    }

    /**
     * Gets the value of the minimumSupport property.
     * 
     */
    public double getMinimumSupport() {
        return minimumSupport;
    }

    /**
     * Sets the value of the minimumSupport property.
     * 
     */
    public AssociationModel setMinimumSupport(
        @org.jpmml.model.Property("minimumSupport")
        double minimumSupport) {
        this.minimumSupport = minimumSupport;
        return this;
    }

    /**
     * Gets the value of the minimumConfidence property.
     * 
     */
    public double getMinimumConfidence() {
        return minimumConfidence;
    }

    /**
     * Sets the value of the minimumConfidence property.
     * 
     */
    public AssociationModel setMinimumConfidence(
        @org.jpmml.model.Property("minimumConfidence")
        double minimumConfidence) {
        this.minimumConfidence = minimumConfidence;
        return this;
    }

    /**
     * Gets the value of the lengthLimit property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public Integer getLengthLimit() {
        return lengthLimit;
    }

    /**
     * Sets the value of the lengthLimit property.
     * 
     * @param lengthLimit
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public AssociationModel setLengthLimit(
        @org.jpmml.model.Property("lengthLimit")
        Integer lengthLimit) {
        this.lengthLimit = lengthLimit;
        return this;
    }

    /**
     * Gets the value of the numberOfItems property.
     * 
     */
    public int getNumberOfItems() {
        return numberOfItems;
    }

    /**
     * Sets the value of the numberOfItems property.
     * 
     */
    public AssociationModel setNumberOfItems(
        @org.jpmml.model.Property("numberOfItems")
        int numberOfItems) {
        this.numberOfItems = numberOfItems;
        return this;
    }

    /**
     * Gets the value of the numberOfItemsets property.
     * 
     */
    public int getNumberOfItemsets() {
        return numberOfItemsets;
    }

    /**
     * Sets the value of the numberOfItemsets property.
     * 
     */
    public AssociationModel setNumberOfItemsets(
        @org.jpmml.model.Property("numberOfItemsets")
        int numberOfItemsets) {
        this.numberOfItemsets = numberOfItemsets;
        return this;
    }

    /**
     * Gets the value of the numberOfRules property.
     * 
     */
    public int getNumberOfRules() {
        return numberOfRules;
    }

    /**
     * Sets the value of the numberOfRules property.
     * 
     */
    public AssociationModel setNumberOfRules(
        @org.jpmml.model.Property("numberOfRules")
        int numberOfRules) {
        this.numberOfRules = numberOfRules;
        return this;
    }

    /**
     * Gets the value of the scorable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    /**
     * Sets the value of the scorable property.
     * 
     * @param scorable
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public AssociationModel setScorable(
        @org.jpmml.model.Property("scorable")
        Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    /**
     * Gets the value of the mathContext property.
     * 
     * @return
     *     possible object is
     *     {@link MathContext }
     *     
     */
    public MathContext getMathContext() {
        if (mathContext == null) {
            return MathContext.DOUBLE;
        } else {
            return mathContext;
        }
    }

    /**
     * Sets the value of the mathContext property.
     * 
     * @param mathContext
     *     allowed object is
     *     {@link MathContext }
     *     
     */
    public AssociationModel setMathContext(
        @org.jpmml.model.Property("mathContext")
        MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link org.dmg.pmml.Extension }
     * 
     * 
     */
    public List<org.dmg.pmml.Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<org.dmg.pmml.Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the miningSchema property.
     * 
     * @return
     *     possible object is
     *     {@link MiningSchema }
     *     
     */
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    /**
     * Sets the value of the miningSchema property.
     * 
     * @param miningSchema
     *     allowed object is
     *     {@link MiningSchema }
     *     
     */
    public AssociationModel setMiningSchema(
        @org.jpmml.model.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    /**
     * Gets the value of the output property.
     * 
     * @return
     *     possible object is
     *     {@link Output }
     *     
     */
    public Output getOutput() {
        return output;
    }

    /**
     * Sets the value of the output property.
     * 
     * @param output
     *     allowed object is
     *     {@link Output }
     *     
     */
    public AssociationModel setOutput(
        @org.jpmml.model.Property("output")
        Output output) {
        this.output = output;
        return this;
    }

    /**
     * Gets the value of the modelStats property.
     * 
     * @return
     *     possible object is
     *     {@link ModelStats }
     *     
     */
    public ModelStats getModelStats() {
        return modelStats;
    }

    /**
     * Sets the value of the modelStats property.
     * 
     * @param modelStats
     *     allowed object is
     *     {@link ModelStats }
     *     
     */
    public AssociationModel setModelStats(
        @org.jpmml.model.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param localTransformations
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public AssociationModel setLocalTransformations(
        @org.jpmml.model.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    /**
     * Gets the value of the items property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the items property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getItems().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Item }
     * 
     * 
     */
    public List<Item> getItems() {
        if (items == null) {
            items = new ArrayList<Item>();
        }
        return this.items;
    }

    /**
     * Gets the value of the itemsets property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the itemsets property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getItemsets().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Itemset }
     * 
     * 
     */
    public List<Itemset> getItemsets() {
        if (itemsets == null) {
            itemsets = new ArrayList<Itemset>();
        }
        return this.itemsets;
    }

    /**
     * Gets the value of the associationRules property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the associationRules property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAssociationRules().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AssociationRule }
     * 
     * 
     */
    public List<AssociationRule> getAssociationRules() {
        if (associationRules == null) {
            associationRules = new ArrayList<AssociationRule>();
        }
        return this.associationRules;
    }

    /**
     * Gets the value of the modelVerification property.
     * 
     * @return
     *     possible object is
     *     {@link ModelVerification }
     *     
     */
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    /**
     * Sets the value of the modelVerification property.
     * 
     * @param modelVerification
     *     allowed object is
     *     {@link ModelVerification }
     *     
     */
    public AssociationModel setModelVerification(
        @org.jpmml.model.Property("modelVerification")
        ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public AssociationModel addExtensions(org.dmg.pmml.Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasItems() {
        return ((this.items!= null)&&(this.items.size()> 0));
    }

    public AssociationModel addItems(Item... items) {
        getItems().addAll(Arrays.asList(items));
        return this;
    }

    public boolean hasItemsets() {
        return ((this.itemsets!= null)&&(this.itemsets.size()> 0));
    }

    public AssociationModel addItemsets(Itemset... itemsets) {
        getItemsets().addAll(Arrays.asList(itemsets));
        return this;
    }

    public boolean hasAssociationRules() {
        return ((this.associationRules!= null)&&(this.associationRules.size()> 0));
    }

    public AssociationModel addAssociationRules(AssociationRule... associationRules) {
        getAssociationRules().addAll(Arrays.asList(associationRules));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getLocalTransformations());
            }
            if ((status == VisitorAction.CONTINUE)&&hasItems()) {
                status = PMMLObject.traverse(visitor, getItems());
            }
            if ((status == VisitorAction.CONTINUE)&&hasItemsets()) {
                status = PMMLObject.traverse(visitor, getItemsets());
            }
            if ((status == VisitorAction.CONTINUE)&&hasAssociationRules()) {
                status = PMMLObject.traverse(visitor, getAssociationRules());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
