
package org.dmg.pmml.gaussian_process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.Property;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="description" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="gamma" type="{http://www.dmg.org/PMML-4_3}REAL-NUMBER" default="1" />
 *       &lt;attribute name="noiseVariance" type="{http://www.dmg.org/PMML-4_3}REAL-NUMBER" default="1" />
 *       &lt;attribute name="lambda" type="{http://www.dmg.org/PMML-4_3}REAL-NUMBER" default="1" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "RadialBasisKernel", namespace = "http://www.dmg.org/PMML-4_3")
@Added(Version.PMML_4_3)
public class RadialBasisKernel
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<RadialBasisKernel>
{

    @XmlAttribute(name = "description")
    private String description;
    @XmlAttribute(name = "gamma")
    private Double gamma;
    @XmlAttribute(name = "noiseVariance")
    private Double noiseVariance;
    @XmlAttribute(name = "lambda")
    private Double lambda;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    private final static Double DEFAULT_GAMMA = 1.0D;
    private final static Double DEFAULT_NOISE_VARIANCE = 1.0D;
    private final static Double DEFAULT_LAMBDA = 1.0D;
    private final static long serialVersionUID = 67305479L;

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param description
     *     allowed object is
     *     {@link String }
     *     
     */
    public RadialBasisKernel setDescription(
        @Property("description")
        String description) {
        this.description = description;
        return this;
    }

    /**
     * Gets the value of the gamma property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getGamma() {
        if (gamma == null) {
            return DEFAULT_GAMMA;
        } else {
            return gamma;
        }
    }

    /**
     * Sets the value of the gamma property.
     * 
     * @param gamma
     *     allowed object is
     *     {@link Double }
     *     
     */
    public RadialBasisKernel setGamma(
        @Property("gamma")
        Double gamma) {
        this.gamma = gamma;
        return this;
    }

    /**
     * Gets the value of the noiseVariance property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getNoiseVariance() {
        if (noiseVariance == null) {
            return DEFAULT_NOISE_VARIANCE;
        } else {
            return noiseVariance;
        }
    }

    /**
     * Sets the value of the noiseVariance property.
     * 
     * @param noiseVariance
     *     allowed object is
     *     {@link Double }
     *     
     */
    public RadialBasisKernel setNoiseVariance(
        @Property("noiseVariance")
        Double noiseVariance) {
        this.noiseVariance = noiseVariance;
        return this;
    }

    /**
     * Gets the value of the lambda property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getLambda() {
        if (lambda == null) {
            return DEFAULT_LAMBDA;
        } else {
            return lambda;
        }
    }

    /**
     * Sets the value of the lambda property.
     * 
     * @param lambda
     *     allowed object is
     *     {@link Double }
     *     
     */
    public RadialBasisKernel setLambda(
        @Property("lambda")
        Double lambda) {
        this.lambda = lambda;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Extension }
     * 
     * 
     */
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public RadialBasisKernel addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
