
package org.dmg.pmml.mining;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.schema.Added;
import org.jpmml.schema.Removed;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}LocalTransformations" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Segment" maxOccurs="unbounded"/>
 *       &lt;/sequence>
 *       &lt;attribute name="multipleModelMethod" use="required">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="majorityVote"/>
 *             &lt;enumeration value="weightedMajorityVote"/>
 *             &lt;enumeration value="average"/>
 *             &lt;enumeration value="weightedAverage"/>
 *             &lt;enumeration value="median"/>
 *             &lt;enumeration value="x-weightedMedian"/>
 *             &lt;enumeration value="max"/>
 *             &lt;enumeration value="sum"/>
 *             &lt;enumeration value="x-weightedSum"/>
 *             &lt;enumeration value="selectFirst"/>
 *             &lt;enumeration value="selectAll"/>
 *             &lt;enumeration value="modelChain"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "localTransformations",
    "segments"
})
@XmlRootElement(name = "Segmentation", namespace = "http://www.dmg.org/PMML-4_3")
@Added(Version.PMML_4_0)
public class Segmentation
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Segmentation>
{

    @XmlAttribute(name = "multipleModelMethod", required = true)
    private Segmentation.MultipleModelMethod multipleModelMethod;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<org.dmg.pmml.Extension> extensions;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_3")
    @Removed(Version.PMML_4_1)
    private LocalTransformations localTransformations;
    @XmlElement(name = "Segment", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private List<Segment> segments;
    private final static long serialVersionUID = 67305479L;

    public Segmentation() {
    }

    public Segmentation(
        @org.jpmml.model.Property("multipleModelMethod")
        Segmentation.MultipleModelMethod multipleModelMethod,
        @org.jpmml.model.Property("segments")
        List<Segment> segments) {
        this.multipleModelMethod = multipleModelMethod;
        this.segments = segments;
    }

    /**
     * Gets the value of the multipleModelMethod property.
     * 
     * @return
     *     possible object is
     *     {@link Segmentation.MultipleModelMethod }
     *     
     */
    public Segmentation.MultipleModelMethod getMultipleModelMethod() {
        return multipleModelMethod;
    }

    /**
     * Sets the value of the multipleModelMethod property.
     * 
     * @param multipleModelMethod
     *     allowed object is
     *     {@link Segmentation.MultipleModelMethod }
     *     
     */
    public Segmentation setMultipleModelMethod(
        @org.jpmml.model.Property("multipleModelMethod")
        Segmentation.MultipleModelMethod multipleModelMethod) {
        this.multipleModelMethod = multipleModelMethod;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link org.dmg.pmml.Extension }
     * 
     * 
     */
    public List<org.dmg.pmml.Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<org.dmg.pmml.Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param localTransformations
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public Segmentation setLocalTransformations(
        @org.jpmml.model.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    /**
     * Gets the value of the segments property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the segments property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSegments().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Segment }
     * 
     * 
     */
    public List<Segment> getSegments() {
        if (segments == null) {
            segments = new ArrayList<Segment>();
        }
        return this.segments;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Segmentation addExtensions(org.dmg.pmml.Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasSegments() {
        return ((this.segments!= null)&&(this.segments.size()> 0));
    }

    public Segmentation addSegments(Segment... segments) {
        getSegments().addAll(Arrays.asList(segments));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getLocalTransformations());
            }
            if ((status == VisitorAction.CONTINUE)&&hasSegments()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getSegments());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="majorityVote"/>
     *     &lt;enumeration value="weightedMajorityVote"/>
     *     &lt;enumeration value="average"/>
     *     &lt;enumeration value="weightedAverage"/>
     *     &lt;enumeration value="median"/>
     *     &lt;enumeration value="x-weightedMedian"/>
     *     &lt;enumeration value="max"/>
     *     &lt;enumeration value="sum"/>
     *     &lt;enumeration value="x-weightedSum"/>
     *     &lt;enumeration value="selectFirst"/>
     *     &lt;enumeration value="selectAll"/>
     *     &lt;enumeration value="modelChain"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    @Added(Version.PMML_4_0)
    public enum MultipleModelMethod {

        @XmlEnumValue("majorityVote")
        MAJORITY_VOTE("majorityVote"),
        @XmlEnumValue("weightedMajorityVote")
        WEIGHTED_MAJORITY_VOTE("weightedMajorityVote"),
        @XmlEnumValue("average")
        AVERAGE("average"),
        @XmlEnumValue("weightedAverage")
        WEIGHTED_AVERAGE("weightedAverage"),
        @XmlEnumValue("median")
        MEDIAN("median"),
        @XmlEnumValue("x-weightedMedian")
        @org.jpmml.schema.Extension
        WEIGHTED_MEDIAN("x-weightedMedian"),
        @XmlEnumValue("max")
        MAX("max"),
        @XmlEnumValue("sum")
        SUM("sum"),
        @XmlEnumValue("x-weightedSum")
        @org.jpmml.schema.Extension
        WEIGHTED_SUM("x-weightedSum"),
        @XmlEnumValue("selectFirst")
        SELECT_FIRST("selectFirst"),
        @XmlEnumValue("selectAll")
        SELECT_ALL("selectAll"),
        @XmlEnumValue("modelChain")
        @Added(Version.PMML_4_1)
        MODEL_CHAIN("modelChain");
        private final String value;

        MultipleModelMethod(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static Segmentation.MultipleModelMethod fromValue(String v) {
            for (Segmentation.MultipleModelMethod c: Segmentation.MultipleModelMethod.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
