
package org.dmg.pmml.scorecard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Extension" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}MiningSchema"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Output" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}ModelStats" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}ModelExplanation" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Targets" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}LocalTransformations" minOccurs="0"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}Characteristics"/>
 *         &lt;element ref="{http://www.dmg.org/PMML-4_3}ModelVerification" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="modelName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="functionName" use="required" type="{http://www.dmg.org/PMML-4_3}MINING-FUNCTION" />
 *       &lt;attribute name="algorithmName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="initialScore" type="{http://www.dmg.org/PMML-4_3}NUMBER" default="0" />
 *       &lt;attribute name="useReasonCodes" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       &lt;attribute name="reasonCodeAlgorithm" default="pointsBelow">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="pointsAbove"/>
 *             &lt;enumeration value="pointsBelow"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="baselineScore" type="{http://www.dmg.org/PMML-4_3}NUMBER" />
 *       &lt;attribute name="baselineMethod" default="other">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="max"/>
 *             &lt;enumeration value="min"/>
 *             &lt;enumeration value="mean"/>
 *             &lt;enumeration value="neutral"/>
 *             &lt;enumeration value="other"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="isScorable" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       &lt;attribute name="x-mathContext" type="{http://www.dmg.org/PMML-4_3}MATH-CONTEXT" default="double" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "characteristics",
    "modelVerification"
})
@XmlRootElement(name = "Scorecard", namespace = "http://www.dmg.org/PMML-4_3")
@Added(Version.PMML_4_1)
public class Scorecard
    extends Model
    implements HasExtensions<Scorecard>
{

    @XmlAttribute(name = "modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "initialScore")
    private Double initialScore;
    @XmlAttribute(name = "useReasonCodes")
    private Boolean useReasonCodes;
    @XmlAttribute(name = "reasonCodeAlgorithm")
    private Scorecard.ReasonCodeAlgorithm reasonCodeAlgorithm;
    @XmlAttribute(name = "baselineScore")
    private Double baselineScore;
    @XmlAttribute(name = "baselineMethod")
    private Scorecard.BaselineMethod baselineMethod;
    @XmlAttribute(name = "isScorable")
    @Added(Version.PMML_4_1)
    private Boolean scorable;
    @XmlAttribute(name = "x-mathContext")
    @org.jpmml.schema.Extension
    private MathContext mathContext;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<org.dmg.pmml.Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_3")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_3")
    private ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_3")
    private ModelExplanation modelExplanation;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_3")
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_3")
    private LocalTransformations localTransformations;
    @XmlElement(name = "Characteristics", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private Characteristics characteristics;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_3")
    private ModelVerification modelVerification;
    private final static Double DEFAULT_INITIAL_SCORE = 0.0D;
    private final static Boolean DEFAULT_USE_REASON_CODES = true;
    private final static Boolean DEFAULT_SCORABLE = true;
    private final static long serialVersionUID = 67305479L;

    public Scorecard() {
    }

    public Scorecard(
        @org.jpmml.model.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.Property("miningSchema")
        MiningSchema miningSchema,
        @org.jpmml.model.Property("characteristics")
        Characteristics characteristics) {
        this.miningFunction = miningFunction;
        this.miningSchema = miningSchema;
        this.characteristics = characteristics;
    }

    /**
     * Gets the value of the modelName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getModelName() {
        return modelName;
    }

    /**
     * Sets the value of the modelName property.
     * 
     * @param modelName
     *     allowed object is
     *     {@link String }
     *     
     */
    public Scorecard setModelName(
        @org.jpmml.model.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    /**
     * Gets the value of the miningFunction property.
     * 
     * @return
     *     possible object is
     *     {@link MiningFunction }
     *     
     */
    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    /**
     * Sets the value of the miningFunction property.
     * 
     * @param miningFunction
     *     allowed object is
     *     {@link MiningFunction }
     *     
     */
    public Scorecard setMiningFunction(
        @org.jpmml.model.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    /**
     * Gets the value of the algorithmName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAlgorithmName() {
        return algorithmName;
    }

    /**
     * Sets the value of the algorithmName property.
     * 
     * @param algorithmName
     *     allowed object is
     *     {@link String }
     *     
     */
    public Scorecard setAlgorithmName(
        @org.jpmml.model.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    /**
     * Gets the value of the initialScore property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getInitialScore() {
        if (initialScore == null) {
            return DEFAULT_INITIAL_SCORE;
        } else {
            return initialScore;
        }
    }

    /**
     * Sets the value of the initialScore property.
     * 
     * @param initialScore
     *     allowed object is
     *     {@link Double }
     *     
     */
    public Scorecard setInitialScore(
        @org.jpmml.model.Property("initialScore")
        Double initialScore) {
        this.initialScore = initialScore;
        return this;
    }

    /**
     * Gets the value of the useReasonCodes property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isUseReasonCodes() {
        if (useReasonCodes == null) {
            return DEFAULT_USE_REASON_CODES;
        } else {
            return useReasonCodes;
        }
    }

    /**
     * Sets the value of the useReasonCodes property.
     * 
     * @param useReasonCodes
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public Scorecard setUseReasonCodes(
        @org.jpmml.model.Property("useReasonCodes")
        Boolean useReasonCodes) {
        this.useReasonCodes = useReasonCodes;
        return this;
    }

    /**
     * Gets the value of the reasonCodeAlgorithm property.
     * 
     * @return
     *     possible object is
     *     {@link Scorecard.ReasonCodeAlgorithm }
     *     
     */
    public Scorecard.ReasonCodeAlgorithm getReasonCodeAlgorithm() {
        if (reasonCodeAlgorithm == null) {
            return Scorecard.ReasonCodeAlgorithm.POINTS_BELOW;
        } else {
            return reasonCodeAlgorithm;
        }
    }

    /**
     * Sets the value of the reasonCodeAlgorithm property.
     * 
     * @param reasonCodeAlgorithm
     *     allowed object is
     *     {@link Scorecard.ReasonCodeAlgorithm }
     *     
     */
    public Scorecard setReasonCodeAlgorithm(
        @org.jpmml.model.Property("reasonCodeAlgorithm")
        Scorecard.ReasonCodeAlgorithm reasonCodeAlgorithm) {
        this.reasonCodeAlgorithm = reasonCodeAlgorithm;
        return this;
    }

    /**
     * Gets the value of the baselineScore property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getBaselineScore() {
        return baselineScore;
    }

    /**
     * Sets the value of the baselineScore property.
     * 
     * @param baselineScore
     *     allowed object is
     *     {@link Double }
     *     
     */
    public Scorecard setBaselineScore(
        @org.jpmml.model.Property("baselineScore")
        Double baselineScore) {
        this.baselineScore = baselineScore;
        return this;
    }

    /**
     * Gets the value of the baselineMethod property.
     * 
     * @return
     *     possible object is
     *     {@link Scorecard.BaselineMethod }
     *     
     */
    public Scorecard.BaselineMethod getBaselineMethod() {
        if (baselineMethod == null) {
            return Scorecard.BaselineMethod.OTHER;
        } else {
            return baselineMethod;
        }
    }

    /**
     * Sets the value of the baselineMethod property.
     * 
     * @param baselineMethod
     *     allowed object is
     *     {@link Scorecard.BaselineMethod }
     *     
     */
    public Scorecard setBaselineMethod(
        @org.jpmml.model.Property("baselineMethod")
        Scorecard.BaselineMethod baselineMethod) {
        this.baselineMethod = baselineMethod;
        return this;
    }

    /**
     * Gets the value of the scorable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    /**
     * Sets the value of the scorable property.
     * 
     * @param scorable
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public Scorecard setScorable(
        @org.jpmml.model.Property("scorable")
        Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    /**
     * Gets the value of the mathContext property.
     * 
     * @return
     *     possible object is
     *     {@link MathContext }
     *     
     */
    public MathContext getMathContext() {
        if (mathContext == null) {
            return MathContext.DOUBLE;
        } else {
            return mathContext;
        }
    }

    /**
     * Sets the value of the mathContext property.
     * 
     * @param mathContext
     *     allowed object is
     *     {@link MathContext }
     *     
     */
    public Scorecard setMathContext(
        @org.jpmml.model.Property("mathContext")
        MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    /**
     * Gets the value of the extensions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the extensions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExtensions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link org.dmg.pmml.Extension }
     * 
     * 
     */
    public List<org.dmg.pmml.Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<org.dmg.pmml.Extension>();
        }
        return this.extensions;
    }

    /**
     * Gets the value of the miningSchema property.
     * 
     * @return
     *     possible object is
     *     {@link MiningSchema }
     *     
     */
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    /**
     * Sets the value of the miningSchema property.
     * 
     * @param miningSchema
     *     allowed object is
     *     {@link MiningSchema }
     *     
     */
    public Scorecard setMiningSchema(
        @org.jpmml.model.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    /**
     * Gets the value of the output property.
     * 
     * @return
     *     possible object is
     *     {@link Output }
     *     
     */
    public Output getOutput() {
        return output;
    }

    /**
     * Sets the value of the output property.
     * 
     * @param output
     *     allowed object is
     *     {@link Output }
     *     
     */
    public Scorecard setOutput(
        @org.jpmml.model.Property("output")
        Output output) {
        this.output = output;
        return this;
    }

    /**
     * Gets the value of the modelStats property.
     * 
     * @return
     *     possible object is
     *     {@link ModelStats }
     *     
     */
    public ModelStats getModelStats() {
        return modelStats;
    }

    /**
     * Sets the value of the modelStats property.
     * 
     * @param modelStats
     *     allowed object is
     *     {@link ModelStats }
     *     
     */
    public Scorecard setModelStats(
        @org.jpmml.model.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    /**
     * Gets the value of the modelExplanation property.
     * 
     * @return
     *     possible object is
     *     {@link ModelExplanation }
     *     
     */
    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    /**
     * Sets the value of the modelExplanation property.
     * 
     * @param modelExplanation
     *     allowed object is
     *     {@link ModelExplanation }
     *     
     */
    public Scorecard setModelExplanation(
        @org.jpmml.model.Property("modelExplanation")
        ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    /**
     * Gets the value of the targets property.
     * 
     * @return
     *     possible object is
     *     {@link Targets }
     *     
     */
    public Targets getTargets() {
        return targets;
    }

    /**
     * Sets the value of the targets property.
     * 
     * @param targets
     *     allowed object is
     *     {@link Targets }
     *     
     */
    public Scorecard setTargets(
        @org.jpmml.model.Property("targets")
        Targets targets) {
        this.targets = targets;
        return this;
    }

    /**
     * Gets the value of the localTransformations property.
     * 
     * @return
     *     possible object is
     *     {@link LocalTransformations }
     *     
     */
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    /**
     * Sets the value of the localTransformations property.
     * 
     * @param localTransformations
     *     allowed object is
     *     {@link LocalTransformations }
     *     
     */
    public Scorecard setLocalTransformations(
        @org.jpmml.model.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    /**
     * Gets the value of the characteristics property.
     * 
     * @return
     *     possible object is
     *     {@link Characteristics }
     *     
     */
    public Characteristics getCharacteristics() {
        return characteristics;
    }

    /**
     * Sets the value of the characteristics property.
     * 
     * @param characteristics
     *     allowed object is
     *     {@link Characteristics }
     *     
     */
    public Scorecard setCharacteristics(
        @org.jpmml.model.Property("characteristics")
        Characteristics characteristics) {
        this.characteristics = characteristics;
        return this;
    }

    /**
     * Gets the value of the modelVerification property.
     * 
     * @return
     *     possible object is
     *     {@link ModelVerification }
     *     
     */
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    /**
     * Sets the value of the modelVerification property.
     * 
     * @param modelVerification
     *     allowed object is
     *     {@link ModelVerification }
     *     
     */
    public Scorecard setModelVerification(
        @org.jpmml.model.Property("modelVerification")
        ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Scorecard addExtensions(org.dmg.pmml.Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getModelExplanation(), getTargets(), getLocalTransformations(), getCharacteristics(), getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="max"/>
     *     &lt;enumeration value="min"/>
     *     &lt;enumeration value="mean"/>
     *     &lt;enumeration value="neutral"/>
     *     &lt;enumeration value="other"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum BaselineMethod {

        @XmlEnumValue("max")
        MAX("max"),
        @XmlEnumValue("min")
        MIN("min"),
        @XmlEnumValue("mean")
        MEAN("mean"),
        @XmlEnumValue("neutral")
        NEUTRAL("neutral"),
        @XmlEnumValue("other")
        OTHER("other");
        private final String value;

        BaselineMethod(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static Scorecard.BaselineMethod fromValue(String v) {
            for (Scorecard.BaselineMethod c: Scorecard.BaselineMethod.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p>
     * <pre>
     * &lt;simpleType>
     *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     &lt;enumeration value="pointsAbove"/>
     *     &lt;enumeration value="pointsBelow"/>
     *   &lt;/restriction>
     * &lt;/simpleType>
     * </pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    public enum ReasonCodeAlgorithm {

        @XmlEnumValue("pointsAbove")
        POINTS_ABOVE("pointsAbove"),
        @XmlEnumValue("pointsBelow")
        POINTS_BELOW("pointsBelow");
        private final String value;

        ReasonCodeAlgorithm(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static Scorecard.ReasonCodeAlgorithm fromValue(String v) {
            for (Scorecard.ReasonCodeAlgorithm c: Scorecard.ReasonCodeAlgorithm.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
