
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.model.annotations.Required;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "expressions"
})
@XmlRootElement(name = "Apply", namespace = "http://www.dmg.org/PMML-4_3")
public class Apply
    extends org.dmg.pmml.Expression
    implements HasDefaultValue<Apply> , HasExtensions<Apply> , HasMapMissingTo<Apply, String>
{

    @XmlAttribute(name = "function", required = true)
    @Required((org.dmg.pmml.Version.PMML_3_1))
    private String function;
    @XmlAttribute(name = "mapMissingTo")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    private String mapMissingTo;
    @XmlAttribute(name = "defaultValue")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_2))
    private String defaultValue;
    @XmlAttribute(name = "invalidValueTreatment")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    private InvalidValueTreatmentMethod invalidValueTreatment;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElements({
        @XmlElement(name = "Constant", namespace = "http://www.dmg.org/PMML-4_3", type = Constant.class),
        @XmlElement(name = "FieldRef", namespace = "http://www.dmg.org/PMML-4_3", type = FieldRef.class),
        @XmlElement(name = "NormContinuous", namespace = "http://www.dmg.org/PMML-4_3", type = NormContinuous.class),
        @XmlElement(name = "NormDiscrete", namespace = "http://www.dmg.org/PMML-4_3", type = NormDiscrete.class),
        @XmlElement(name = "Discretize", namespace = "http://www.dmg.org/PMML-4_3", type = Discretize.class),
        @XmlElement(name = "MapValues", namespace = "http://www.dmg.org/PMML-4_3", type = MapValues.class),
        @XmlElement(name = "TextIndex", namespace = "http://www.dmg.org/PMML-4_3", type = TextIndex.class),
        @XmlElement(name = "Apply", namespace = "http://www.dmg.org/PMML-4_3", type = Apply.class),
        @XmlElement(name = "Aggregate", namespace = "http://www.dmg.org/PMML-4_3", type = Aggregate.class),
        @XmlElement(name = "Lag", namespace = "http://www.dmg.org/PMML-4_3", type = Lag.class)
    })
    private List<org.dmg.pmml.Expression> expressions;
    private final static long serialVersionUID = 67305481L;

    public Apply() {
    }

    public Apply(
        @org.jpmml.model.annotations.Property("function")
        String function) {
        this.function = function;
    }

    public String getFunction() {
        return function;
    }

    public Apply setFunction(
        @org.jpmml.model.annotations.Property("function")
        String function) {
        this.function = function;
        return this;
    }

    public String getMapMissingTo() {
        return mapMissingTo;
    }

    public Apply setMapMissingTo(
        @org.jpmml.model.annotations.Property("mapMissingTo")
        String mapMissingTo) {
        this.mapMissingTo = mapMissingTo;
        return this;
    }

    public String getDefaultValue() {
        return defaultValue;
    }

    public Apply setDefaultValue(
        @org.jpmml.model.annotations.Property("defaultValue")
        String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public InvalidValueTreatmentMethod getInvalidValueTreatment() {
        if (invalidValueTreatment == null) {
            return InvalidValueTreatmentMethod.RETURN_INVALID;
        } else {
            return invalidValueTreatment;
        }
    }

    public Apply setInvalidValueTreatment(
        @org.jpmml.model.annotations.Property("invalidValueTreatment")
        InvalidValueTreatmentMethod invalidValueTreatment) {
        this.invalidValueTreatment = invalidValueTreatment;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<org.dmg.pmml.Expression> getExpressions() {
        if (expressions == null) {
            expressions = new ArrayList<org.dmg.pmml.Expression>();
        }
        return this.expressions;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Apply addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasExpressions() {
        return ((this.expressions!= null)&&(this.expressions.size()> 0));
    }

    public Apply addExpressions(org.dmg.pmml.Expression... expressions) {
        getExpressions().addAll(Arrays.asList(expressions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasExpressions()) {
                status = PMMLObject.traverse(visitor, getExpressions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
