
package org.dmg.pmml;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;

@XmlType(name = "MISSING-VALUE-TREATMENT-METHOD", namespace = "http://www.dmg.org/PMML-4_3")
@XmlEnum
public enum MissingValueTreatmentMethod {

    @XmlEnumValue("asIs")
    AS_IS("asIs"),
    @XmlEnumValue("asMean")
    AS_MEAN("asMean"),
    @XmlEnumValue("asMode")
    AS_MODE("asMode"),
    @XmlEnumValue("asMedian")
    AS_MEDIAN("asMedian"),
    @XmlEnumValue("asValue")
    AS_VALUE("asValue");
    private final String value;

    MissingValueTreatmentMethod(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static MissingValueTreatmentMethod fromValue(String v) {
        for (MissingValueTreatmentMethod c: MissingValueTreatmentMethod.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
