
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "multivariateStats"
})
@XmlRootElement(name = "MultivariateStats", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_1))
public class MultivariateStats
    extends org.dmg.pmml.PMMLObject
    implements Iterable<MultivariateStat> , HasExtensions<MultivariateStats>
{

    @XmlAttribute(name = "targetCategory")
    private String targetCategory;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "MultivariateStat", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private List<MultivariateStat> multivariateStats;
    private final static long serialVersionUID = 67305481L;

    public MultivariateStats() {
    }

    public MultivariateStats(
        @org.jpmml.model.annotations.Property("multivariateStats")
        List<MultivariateStat> multivariateStats) {
        this.multivariateStats = multivariateStats;
    }

    public String getTargetCategory() {
        return targetCategory;
    }

    public MultivariateStats setTargetCategory(
        @org.jpmml.model.annotations.Property("targetCategory")
        String targetCategory) {
        this.targetCategory = targetCategory;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<MultivariateStat> getMultivariateStats() {
        if (multivariateStats == null) {
            multivariateStats = new ArrayList<MultivariateStat>();
        }
        return this.multivariateStats;
    }

    public Iterator<MultivariateStat> iterator() {
        return getMultivariateStats().iterator();
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public MultivariateStats addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasMultivariateStats() {
        return ((this.multivariateStats!= null)&&(this.multivariateStats.size()> 0));
    }

    public MultivariateStats addMultivariateStats(MultivariateStat... multivariateStats) {
        getMultivariateStats().addAll(Arrays.asList(multivariateStats));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasMultivariateStats()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getMultivariateStats());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
